/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.util.pathfinding.navmesh;

import java.util.ArrayList;
import org.newdawn.slick.util.pathfinding.navmesh.Link;
import org.newdawn.slick.util.pathfinding.navmesh.NavPath;
import org.newdawn.slick.util.pathfinding.navmesh.Space;

public class NavMesh {
    private ArrayList spaces = new ArrayList();

    public NavMesh() {
    }

    public NavMesh(ArrayList spaces) {
        this.spaces.addAll(spaces);
    }

    public int getSpaceCount() {
        return this.spaces.size();
    }

    public Space getSpace(int index) {
        return (Space)this.spaces.get(index);
    }

    public void addSpace(Space space) {
        this.spaces.add(space);
    }

    public Space findSpace(float x2, float y2) {
        for (int i2 = 0; i2 < this.spaces.size(); ++i2) {
            Space space = this.getSpace(i2);
            if (!space.contains(x2, y2)) continue;
            return space;
        }
        return null;
    }

    public NavPath findPath(float sx2, float sy2, float tx2, float ty2, boolean optimize) {
        Space source = this.findSpace(sx2, sy2);
        Space target = this.findSpace(tx2, ty2);
        if (source == null || target == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.spaces.size(); ++i2) {
            ((Space)this.spaces.get(i2)).clearCost();
        }
        target.fill(source, tx2, ty2, 0.0f);
        if (target.getCost() == Float.MAX_VALUE) {
            return null;
        }
        if (source.getCost() == Float.MAX_VALUE) {
            return null;
        }
        NavPath path = new NavPath();
        path.push(new Link(sx2, sy2, null));
        if (source.pickLowestCost(target, path)) {
            path.push(new Link(tx2, ty2, null));
            if (optimize) {
                this.optimize(path);
            }
            return path;
        }
        return null;
    }

    private boolean isClear(float x1, float y1, float x2, float y2, float step) {
        float dx2 = x2 - x1;
        float dy2 = y2 - y1;
        float len = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
        dx2 *= step;
        dx2 /= len;
        dy2 *= step;
        dy2 /= len;
        int steps = (int)(len / step);
        for (int i2 = 0; i2 < steps; ++i2) {
            float x3 = x1 + dx2 * (float)i2;
            float y3 = y1 + dy2 * (float)i2;
            if (this.findSpace(x3, y3) != null) continue;
            return false;
        }
        return true;
    }

    private void optimize(NavPath path) {
        int pt2 = 0;
        while (pt2 < path.length() - 2) {
            float ny2;
            float nx2;
            float sy2;
            float sx2 = path.getX(pt2);
            if (this.isClear(sx2, sy2 = path.getY(pt2), nx2 = path.getX(pt2 + 2), ny2 = path.getY(pt2 + 2), 0.1f)) {
                path.remove(pt2 + 1);
                continue;
            }
            ++pt2;
        }
    }
}

