/*
 * Decompiled with CFR 0.152.
 */
package wurst.command.commands;

import org.lwjgl.input.Keyboard;
import wurst.Client;
import wurst.command.Command;
import wurst.utils.MiscUtils;

public class Bind
extends Command {
    private static String[] commandHelp = new String[]{"Changes a keybind or lists all keybinds.", ".bind <mod> <key>", ".bind <mod> remove", ".bind list", ".bind list <page>"};
    private int bindsPerPage = 8;

    public Bind() {
        super("bind", commandHelp);
    }

    @Override
    public void onEnable(String input, String[] args) {
        if (args[0].equalsIgnoreCase("list")) {
            int totalBinds = 0;
            for (int i2 = 0; i2 < Client.Wurst.moduleManager.activeModules.size(); ++i2) {
                if (Client.Wurst.moduleManager.activeModules.get(i2).getBind() == 0) continue;
                ++totalBinds;
            }
            float pagesF = (float)((double)totalBinds / (double)this.bindsPerPage);
            int pages = (int)((float)Math.round(pagesF) == pagesF ? pagesF : pagesF + 1.0f);
            this.bindsPerPage = 8;
            if (args.length == 1) {
                if (pages <= 1) {
                    this.bindsPerPage = totalBinds;
                    Client.Wurst.chat.message("Current binds: " + totalBinds);
                    int i2 = 0;
                    for (int i3 = 0; i3 < Client.Wurst.moduleManager.activeModules.size() && i2 < this.bindsPerPage; ++i3) {
                        if (Client.Wurst.moduleManager.activeModules.get(i3).getBind() == 0) continue;
                        Client.Wurst.chat.message(Client.Wurst.moduleManager.activeModules.get(i3).getName() + ": " + Keyboard.getKeyName((int)Client.Wurst.moduleManager.activeModules.get(i3).getBind()));
                        ++i2;
                    }
                } else {
                    Client.Wurst.chat.message("Current binds: " + totalBinds);
                    Client.Wurst.chat.message("Bind list (page 1/" + pages + "):");
                    int i2 = 0;
                    for (int i4 = 0; i4 < Client.Wurst.moduleManager.activeModules.size() && i2 < this.bindsPerPage; ++i4) {
                        if (Client.Wurst.moduleManager.activeModules.get(i4).getBind() == 0) continue;
                        Client.Wurst.chat.message(Client.Wurst.moduleManager.activeModules.get(i4).getName() + ": " + Keyboard.getKeyName((int)Client.Wurst.moduleManager.activeModules.get(i4).getBind()));
                        ++i2;
                    }
                }
            } else {
                if (MiscUtils.isInteger(args[1])) {
                    int page = Integer.valueOf(args[1]);
                    if (page > pages || page == 0) {
                        this.commandError();
                        return;
                    }
                    Client.Wurst.chat.message("Current binds: " + Integer.toString(totalBinds));
                    Client.Wurst.chat.message("Bind list (page " + page + "/" + pages + "):");
                    int i2 = 0;
                    for (int i5 = 0; i5 < Client.Wurst.moduleManager.activeModules.size() && i2 < (page - 1) * this.bindsPerPage + this.bindsPerPage; ++i5) {
                        if (Client.Wurst.moduleManager.activeModules.get(i5).getBind() == 0) continue;
                        if (i2 >= (page - 1) * this.bindsPerPage) {
                            Client.Wurst.chat.message(Client.Wurst.moduleManager.activeModules.get(i5).getName() + ": " + Keyboard.getKeyName((int)Client.Wurst.moduleManager.activeModules.get(i5).getBind()));
                        }
                        ++i2;
                    }
                    return;
                }
                this.commandError();
            }
        } else if (args[1].equalsIgnoreCase("remove")) {
            for (int i6 = 0; i6 < Client.Wurst.moduleManager.activeModules.size(); ++i6) {
                if (!Client.Wurst.moduleManager.activeModules.get(i6).getName().toLowerCase().equals(args[0].toLowerCase())) continue;
                Client.Wurst.moduleManager.activeModules.get(i6).setBind(0);
                Client.Wurst.fileManager.saveModules();
                Client.Wurst.chat.message("Removed keybind for \"" + args[0] + "\".");
                return;
            }
            this.commandError();
        } else {
            for (int i7 = 0; i7 < Client.Wurst.moduleManager.activeModules.size(); ++i7) {
                if (!Client.Wurst.moduleManager.activeModules.get(i7).getName().toLowerCase().equals(args[0].toLowerCase())) continue;
                Client.Wurst.moduleManager.activeModules.get(i7).setBind(Keyboard.getKeyIndex((String)args[1].toUpperCase()));
                Client.Wurst.fileManager.saveModules();
                Client.Wurst.chat.message("Changed keybind for \"" + args[0] + "\" to " + args[1] + ".");
                return;
            }
            this.commandError();
        }
    }
}

