/*
 * Decompiled with CFR 0.152.
 */
package wurst.command.commands;

import wurst.Client;
import wurst.command.Command;
import wurst.utils.MiscUtils;

public class Friends
extends Command {
    private static String[] commandHelp = new String[]{"Adds or removes a friend or lists all friends.", ".friends <add|remove> <player name>", ".friends list", ".friends list <page>"};
    private int friendsPerPage = 8;

    public Friends() {
        super("friends", commandHelp);
    }

    @Override
    public void onEnable(String input, String[] args) {
        if (args[0].equalsIgnoreCase("list")) {
            int totalFriends = Client.Wurst.options.friends.size();
            float pagesF = (float)((double)totalFriends / (double)this.friendsPerPage);
            int pages = (int)((float)Math.round(pagesF) == pagesF ? pagesF : pagesF + 1.0f);
            this.friendsPerPage = 8;
            if (args.length == 1) {
                if (pages <= 1) {
                    this.friendsPerPage = totalFriends;
                    Client.Wurst.chat.message("Current friends: " + totalFriends);
                    for (int i2 = 0; i2 < Client.Wurst.options.friends.size() && i2 < this.friendsPerPage; ++i2) {
                        Client.Wurst.chat.message(Client.Wurst.options.friends.get(i2));
                    }
                } else {
                    Client.Wurst.chat.message("Current friends: " + totalFriends);
                    Client.Wurst.chat.message("Friends list (page 1/" + pages + "):");
                    for (int i3 = 0; i3 < Client.Wurst.options.friends.size() && i3 < this.friendsPerPage; ++i3) {
                        Client.Wurst.chat.message(Client.Wurst.options.friends.get(i3));
                    }
                }
            } else {
                if (MiscUtils.isInteger(args[1])) {
                    int page = Integer.valueOf(args[1]);
                    if (page > pages || page == 0) {
                        this.commandError();
                        return;
                    }
                    Client.Wurst.chat.message("Current friends: " + Integer.toString(totalFriends));
                    Client.Wurst.chat.message("Friends list (page " + page + "/" + pages + "):");
                    int i2 = 0;
                    for (int i4 = 0; i4 < Client.Wurst.options.friends.size() && i2 < (page - 1) * this.friendsPerPage + this.friendsPerPage; ++i2, ++i4) {
                        if (i2 < (page - 1) * this.friendsPerPage) continue;
                        Client.Wurst.chat.message(Client.Wurst.options.friends.get(i4));
                    }
                    return;
                }
                this.commandError();
            }
        } else if (args[0].equalsIgnoreCase("add")) {
            if (Client.Wurst.options.friends.contains(args[1])) {
                Client.Wurst.chat.error("\"" + args[1] + "\" is already in your friends list.");
                return;
            }
            Client.Wurst.options.friends.add(args[1]);
            Client.Wurst.fileManager.saveFriends();
            Client.Wurst.chat.message("Added friend \"" + args[1] + "\".");
        } else if (args[0].equalsIgnoreCase("remove")) {
            for (int i5 = 0; i5 < Client.Wurst.options.friends.size(); ++i5) {
                if (!Client.Wurst.options.friends.get(i5).toLowerCase().equals(args[1].toLowerCase())) continue;
                Client.Wurst.options.friends.remove(i5);
                Client.Wurst.fileManager.saveFriends();
                Client.Wurst.chat.message("Removed friend \"" + args[1] + "\".");
                return;
            }
            Client.Wurst.chat.error("\"" + args[1] + "\" is not in your friends list.");
        } else {
            this.commandError();
        }
    }
}

