/*
 * Decompiled with CFR 0.152.
 */
package wurst.command.commands;

import wurst.Client;
import wurst.command.Command;
import wurst.utils.MiscUtils;

public class XRay
extends Command {
    private static String[] commandHelp = new String[]{"Adds, removes or lists X-Ray blocks or toggles X-Ray.", ".xray", ".xray <add|remove> id <block id>", ".xray <add|remove> name <block name>", ".xray list", ".xray list <page>"};
    private int blocksPerPage = 8;

    public XRay() {
        super("xray", commandHelp);
    }

    @Override
    public void onEnable(String input, String[] args) {
        if (args == null) {
            Client.Wurst.moduleManager.xrayModule.toggleModule();
            Client.Wurst.chat.message("X-Ray turned " + (Client.Wurst.moduleManager.xrayModule.getToggled() ? "on" : "off") + ".");
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            int totalBlocks = wurst.module.modules.XRay.xrayBlocks.size();
            float pagesF = (float)((double)totalBlocks / (double)this.blocksPerPage);
            int pages = (int)((float)Math.round(pagesF) == pagesF ? pagesF : pagesF + 1.0f);
            this.blocksPerPage = 8;
            if (args.length == 1) {
                if (pages <= 1) {
                    this.blocksPerPage = totalBlocks;
                    Client.Wurst.chat.message("Current X-Ray blocks: " + totalBlocks);
                    for (int i2 = 0; i2 < wurst.module.modules.XRay.xrayBlocks.size() && i2 < this.blocksPerPage; ++i2) {
                        Client.Wurst.chat.message(Integer.toString(ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i2))));
                    }
                } else {
                    Client.Wurst.chat.message("Current X-Ray blocks: " + totalBlocks);
                    Client.Wurst.chat.message("X-Ray blocks list (page 1/" + pages + "):");
                    for (int i3 = 0; i3 < wurst.module.modules.XRay.xrayBlocks.size() && i3 < this.blocksPerPage; ++i3) {
                        Client.Wurst.chat.message(Integer.toString(ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i3))));
                    }
                }
            } else {
                if (MiscUtils.isInteger(args[1])) {
                    int page = Integer.valueOf(args[1]);
                    if (page > pages || page == 0) {
                        this.commandError();
                        return;
                    }
                    Client.Wurst.chat.message("Current X-Ray blocks: " + Integer.toString(totalBlocks));
                    Client.Wurst.chat.message("X-Ray blocks list (page " + page + "/" + pages + "):");
                    int i2 = 0;
                    for (int i4 = 0; i4 < wurst.module.modules.XRay.xrayBlocks.size() && i2 < (page - 1) * this.blocksPerPage + this.blocksPerPage; ++i2, ++i4) {
                        if (i2 < (page - 1) * this.blocksPerPage) continue;
                        Client.Wurst.chat.message(Integer.toString(ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i4))));
                    }
                    return;
                }
                this.commandError();
            }
        } else if (args[0].equalsIgnoreCase("add")) {
            if (args[1].equalsIgnoreCase("id") && MiscUtils.isInteger(args[2])) {
                if (wurst.module.modules.XRay.xrayBlocks.contains(ahu.e(Integer.valueOf(args[2])))) {
                    Client.Wurst.chat.error("\"" + args[2] + "\" is already in your X-Ray blocks list.");
                    return;
                }
                wurst.module.modules.XRay.xrayBlocks.add(ahu.e(Integer.valueOf(args[2])));
                Client.Wurst.fileManager.saveXRayBlocks();
                Client.Wurst.chat.message("Added block " + args[2] + ".");
                azd.A().g.a();
            } else if (args[1].equalsIgnoreCase("name")) {
                int newID = ahu.b(ahu.b(args[2]));
                if (newID == -1) {
                    Client.Wurst.chat.message("The block \"" + args[1] + "\" could not be found.");
                    return;
                }
                wurst.module.modules.XRay.xrayBlocks.add(ahu.e(newID));
                Client.Wurst.fileManager.saveXRayBlocks();
                Client.Wurst.chat.message("Added block " + newID + " (\"" + args[2] + "\").");
                azd.A().g.a();
            } else {
                this.commandError();
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (args[1].equalsIgnoreCase("id") && MiscUtils.isInteger(args[2])) {
                for (int i5 = 0; i5 < wurst.module.modules.XRay.xrayBlocks.size(); ++i5) {
                    if (!Integer.toString(ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i5))).toLowerCase().equals(args[2].toLowerCase())) continue;
                    wurst.module.modules.XRay.xrayBlocks.remove(i5);
                    Client.Wurst.fileManager.saveXRayBlocks();
                    Client.Wurst.chat.message("Removed block " + args[2] + ".");
                    azd.A().g.a();
                    return;
                }
                Client.Wurst.chat.error("Block " + args[2] + " is not in your X-Ray blocks list.");
            } else if (args[1].equalsIgnoreCase("name")) {
                int newID = ahu.b(ahu.b(args[2]));
                if (newID == -1) {
                    Client.Wurst.chat.message("The block \"" + args[2] + "\" could not be found.");
                    return;
                }
                for (int i6 = 0; i6 < wurst.module.modules.XRay.xrayBlocks.size(); ++i6) {
                    if (ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i6)) != newID) continue;
                    wurst.module.modules.XRay.xrayBlocks.remove(i6);
                    Client.Wurst.fileManager.saveXRayBlocks();
                    Client.Wurst.chat.message("Removed block " + newID + " (\"" + args[2] + "\").");
                    azd.A().g.a();
                    return;
                }
                Client.Wurst.chat.error("Block " + newID + " (\"" + args[2] + "\") is not in your X-Ray blocks list.");
            } else {
                this.commandError();
            }
        } else {
            this.commandError();
        }
    }
}

