/*
 * Decompiled with CFR 0.152.
 */
package wurst.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import wurst.Client;
import wurst.alts.Alt;
import wurst.alts.GuiAltList;
import wurst.module.Category;
import wurst.module.Module;
import wurst.module.modules.AdvForceOP;
import wurst.module.modules.ArenaBrawl;
import wurst.module.modules.AutoBuild;
import wurst.module.modules.DotAnnoy;
import wurst.module.modules.FastBreak;
import wurst.module.modules.FightBot;
import wurst.module.modules.Follow;
import wurst.module.modules.ForceOP;
import wurst.module.modules.Freecam;
import wurst.module.modules.Invisibility;
import wurst.module.modules.LSD;
import wurst.module.modules.NewArenaBrawl;
import wurst.module.modules.Nuker;
import wurst.module.modules.Protect;
import wurst.module.modules.RemoteView;
import wurst.module.modules.Search;
import wurst.module.modules.XRay;

public class FileManager {
    private static final Logger logger = LogManager.getLogger();
    private File WurstDir;
    public File SkinDir;
    public File Alts;
    public File Friends;
    public File GUI;
    public File Modules;
    public File Sliders;
    public File Values;
    public File XRay;
    private String split;
    private String[] moduleBlacklist;

    public FileManager() {
        this.WurstDir = new File(azd.A().w, "wurst");
        this.SkinDir = new File(this.WurstDir, "skins");
        this.Alts = new File(this.WurstDir, "alts.txt");
        this.Friends = new File(this.WurstDir, "friends.txt");
        this.GUI = new File(this.WurstDir, "gui.txt");
        this.Modules = new File(this.WurstDir, "modules.txt");
        this.Sliders = new File(this.WurstDir, "sliders.txt");
        this.Values = new File(this.WurstDir, "values.txt");
        this.XRay = new File(this.WurstDir, "xray.txt");
        this.split = "\u00a7";
        this.moduleBlacklist = new String[]{AdvForceOP.class.getName(), ArenaBrawl.class.getName(), DotAnnoy.class.getName(), FightBot.class.getName(), Follow.class.getName(), ForceOP.class.getName(), Freecam.class.getName(), Invisibility.class.getName(), LSD.class.getName(), NewArenaBrawl.class.getName(), Protect.class.getName(), RemoteView.class.getName()};
    }

    public void init() {
        if (!this.WurstDir.exists()) {
            this.WurstDir.mkdir();
        }
        if (!this.SkinDir.exists()) {
            this.SkinDir.mkdir();
        }
        if (!this.Values.exists()) {
            this.saveValues();
        } else {
            this.loadValues();
        }
        if (!this.Modules.exists()) {
            this.saveModules();
        } else {
            this.loadModules();
        }
        if (!this.Alts.exists()) {
            this.saveAlts();
        } else {
            this.loadAlts();
        }
        if (!this.Friends.exists()) {
            this.saveFriends();
        } else {
            this.loadFriends();
        }
        if (!this.XRay.exists()) {
            wurst.module.modules.XRay.initXRayBlocks();
            this.saveXRayBlocks();
        } else {
            this.loadXRayBlocks();
        }
    }

    public void saveGUI(Frame[] frames) {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.GUI));
            for (Frame frame : frames) {
                if (frame.getTitle().equalsIgnoreCase("ArenaBrawl")) continue;
                save.println(frame.getTitle() + this.split + frame.isMinimized() + this.split + frame.isPinned() + this.split + frame.getX() + this.split + frame.getY());
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadGUI(Frame[] frames) {
        BufferedReader load;
        try {
            load = new BufferedReader(new FileReader(this.GUI));
            int i2 = 0;
            String line = "";
            while ((line = load.readLine()) != null) {
                ++i2;
            }
            load.close();
            if (i2 != frames.length) {
                this.saveGUI(frames);
                return;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            load = new BufferedReader(new FileReader(this.GUI));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                for (Frame frame : frames) {
                    if (!frame.getTitle().equals(data[0])) continue;
                    frame.setMinimized(Boolean.valueOf(data[1]));
                    frame.setPinned(Boolean.valueOf(data[2]));
                    frame.setX(Integer.parseInt(data[3]));
                    frame.setY(Integer.parseInt(data[4]));
                }
            }
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveModules() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.Modules));
            for (int i2 = 0; i2 < Client.Wurst.moduleManager.activeModules.size(); ++i2) {
                Module module = Client.Wurst.moduleManager.activeModules.get(i2);
                save.println(module.getName() + this.split + module.getToggled() + this.split + module.getBind());
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadModules() {
        BufferedReader load;
        boolean shouldUpdate = false;
        try {
            load = new BufferedReader(new FileReader(this.Modules));
            int i2 = 0;
            String line = "";
            while ((line = load.readLine()) != null) {
                ++i2;
            }
            load.close();
            if (i2 != Client.Wurst.moduleManager.activeModules.size()) {
                shouldUpdate = true;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            load = new BufferedReader(new FileReader(this.Modules));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                Module module = Client.Wurst.moduleManager.getModuleByName(data[0]);
                if (module == null || data.length != 3) {
                    if (data.length == 0) continue;
                    shouldUpdate = true;
                    continue;
                }
                if (module.getCategory() != Category.HIDDEN) {
                    boolean shouldSkip = false;
                    for (int i3 = 0; i3 < this.moduleBlacklist.length; ++i3) {
                        if (!module.getClass().getName().equalsIgnoreCase(this.moduleBlacklist[i3])) continue;
                        shouldSkip = true;
                        break;
                    }
                    if (module.getToggled() != Boolean.valueOf(data[1]).booleanValue() && !shouldSkip) {
                        module.setToggled(Boolean.valueOf(data[1]));
                    }
                }
                if (module.getBind() == Integer.valueOf(data[2]).intValue()) continue;
                module.setBind(Integer.valueOf(data[2]));
            }
            load.close();
            if (shouldUpdate) {
                this.saveModules();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveValues() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.Values));
            save.println("AutoBuild" + this.split + AutoBuild.mode);
            save.println("AutoReconnect" + this.split + Client.Wurst.options.autoReconnect);
            save.println("FastBreak" + this.split + FastBreak.mode);
            save.println("MiddleClickFriends" + this.split + Client.Wurst.options.middleClickFriends);
            save.println("Nuker" + this.split + Nuker.mode + this.split + Nuker.id);
            save.println("Search" + this.split + Search.id);
            save.println("WIP" + this.split + Client.Wurst.options.WIP);
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadValues() {
        BufferedReader load;
        boolean shouldUpdate = false;
        try {
            load = new BufferedReader(new FileReader(this.Values));
            int i2 = 0;
            String line = "";
            while ((line = load.readLine()) != null) {
                ++i2;
            }
            load.close();
            if (i2 != 1) {
                shouldUpdate = true;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            load = new BufferedReader(new FileReader(this.Values));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                if (data[0].equals("Nuker")) {
                    Nuker.mode = Integer.valueOf(data[1]);
                    Nuker.id = Integer.valueOf(data[2]);
                    continue;
                }
                if (data[0].equals("FastBreak")) {
                    FastBreak.mode = Integer.valueOf(data[1]);
                    continue;
                }
                if (data[0].equals("Search")) {
                    Search.id = Integer.valueOf(data[1]);
                    continue;
                }
                if (data[0].equals("WIP")) {
                    Client.Wurst.options.WIP = Boolean.valueOf(data[1]);
                    continue;
                }
                if (data[0].equals("AutoBuild")) {
                    AutoBuild.mode = Integer.valueOf(data[1]);
                    continue;
                }
                if (data[0].equals("MiddleClickFriends")) {
                    Client.Wurst.options.middleClickFriends = Boolean.valueOf(data[1]);
                    continue;
                }
                if (data[0].equals("AutoReconnect")) {
                    Client.Wurst.options.autoReconnect = Boolean.valueOf(data[1]);
                    continue;
                }
                shouldUpdate = true;
            }
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (shouldUpdate) {
            this.saveValues();
        }
    }

    public void saveSliders() {
        ArrayList<BasicSlider> allSliders = new ArrayList<BasicSlider>();
        for (Module module : Client.Wurst.moduleManager.activeModules) {
            for (BasicSlider slider : module.getSliders()) {
                allSliders.add(slider);
            }
        }
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.Sliders));
            for (int i2 = 0; i2 < allSliders.size(); ++i2) {
                BasicSlider slider = (BasicSlider)allSliders.get(i2);
                save.println(i2 + this.split + (double)(Math.round(slider.getValue() / slider.getIncrement()) * 1000000L * (long)(slider.getIncrement() * 1000000.0)) / 1000000.0 / 1000000.0);
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadSliders() {
        BufferedReader load;
        ArrayList<BasicSlider> allSliders = new ArrayList<BasicSlider>();
        for (Module module : Client.Wurst.moduleManager.activeModules) {
            for (BasicSlider slider : module.getSliders()) {
                allSliders.add(slider);
            }
        }
        try {
            load = new BufferedReader(new FileReader(this.Sliders));
            int i2 = 0;
            String line = "";
            while ((line = load.readLine()) != null) {
                ++i2;
            }
            load.close();
            if (i2 != allSliders.size()) {
                this.saveSliders();
                return;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            load = new BufferedReader(new FileReader(this.Sliders));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                ((BasicSlider)allSliders.get(Integer.valueOf(data[0]))).setValue(Double.valueOf(data[1]));
            }
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveAlts() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.Alts));
            for (Alt alt2 : GuiAltList.alts) {
                String saveName = this.encode(alt2.name);
                String savePassword = this.encode(alt2.password);
                save.println(saveName + this.split + savePassword);
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String encode(String string) {
        String key = "9GjT.\\ACpb_>/!a,|~Hh\u00fcIl5XiJRBLK8`71zSdDn$Mmgq}PO=3Q\"{?Vru(\u00f6*y%]F'Yt\u00e4xEZ\u00b4<#W-U4k)eo2s+6&[cNfwv0";
        String encodedString = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            String oldLetter = string.substring(i2, i2 + 1);
            if (!key.contains(oldLetter)) {
                encodedString = encodedString.concat(oldLetter);
                continue;
            }
            int index = key.indexOf(oldLetter);
            String newLetter = "";
            int key2 = i2 + 1;
            while (index + key2 > key.length()) {
                key2 -= key.length();
            }
            newLetter = index + key2 == key.length() ? key.substring(0, 1) : key.substring(index + key2, index + key2 + 1);
            encodedString = encodedString.concat(newLetter);
        }
        return encodedString;
    }

    public void loadAlts() {
        if (!this.Alts.exists()) {
            this.saveAlts();
            return;
        }
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.Alts));
            GuiAltList.alts.clear();
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                String name = this.decode(data[0]);
                String password = "";
                if (data.length == 2) {
                    password = this.decode(data[1]);
                }
                GuiAltList.alts.add(new Alt(name, password));
            }
            GuiAltList.sortAlts();
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String decode(String string) {
        String key = "9GjT.\\ACpb_>/!a,|~Hh\u00fcIl5XiJRBLK8`71zSdDn$Mmgq}PO=3Q\"{?Vru(\u00f6*y%]F'Yt\u00e4xEZ\u00b4<#W-U4k)eo2s+6&[cNfwv0";
        String decodedString = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            String oldLetter = string.substring(i2, i2 + 1);
            if (!key.contains(oldLetter)) {
                decodedString = decodedString.concat(oldLetter);
                continue;
            }
            int index = key.indexOf(oldLetter);
            String newLetter = "";
            int key2 = i2 + 1;
            while (index - key2 < -1) {
                key2 -= key.length();
            }
            newLetter = index - key2 == -1 ? key.substring(key.length() - 1, key.length()) : key.substring(index - key2, index - key2 + 1);
            decodedString = decodedString.concat(newLetter);
        }
        return decodedString;
    }

    public void saveFriends() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.Friends));
            for (int i2 = 0; i2 < Client.Wurst.options.friends.size(); ++i2) {
                save.println(Client.Wurst.options.friends.get(i2));
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFriends() {
        BufferedReader load;
        boolean shouldUpdate = false;
        try {
            load = new BufferedReader(new FileReader(this.Friends));
            int i2 = 0;
            String line = "";
            while ((line = load.readLine()) != null) {
                ++i2;
            }
            load.close();
            if (i2 != 1) {
                shouldUpdate = true;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            load = new BufferedReader(new FileReader(this.Friends));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                Client.Wurst.options.friends.add(data[0]);
            }
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (shouldUpdate) {
            this.saveFriends();
        }
    }

    public void saveXRayBlocks() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.XRay));
            for (int i2 = 0; i2 < wurst.module.modules.XRay.xrayBlocks.size(); ++i2) {
                save.println(ahu.b(wurst.module.modules.XRay.xrayBlocks.get(i2)));
            }
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadXRayBlocks() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.XRay));
            String line = "";
            while ((line = load.readLine()) != null) {
                String[] data = line.split(this.split);
                wurst.module.modules.XRay.xrayBlocks.add(ahu.e(Integer.valueOf(data[0])));
            }
            load.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

