/*
 * Decompiled with CFR 0.152.
 */
package wurst.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.darkstorm.minecraft.gui.AbstractGuiManager;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.ComboBox;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.Slider;
import org.darkstorm.minecraft.gui.component.basic.BasicButton;
import org.darkstorm.minecraft.gui.component.basic.BasicComboBox;
import org.darkstorm.minecraft.gui.component.basic.BasicFrame;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import org.darkstorm.minecraft.gui.layout.Constraint;
import org.darkstorm.minecraft.gui.layout.GridLayoutManager;
import org.darkstorm.minecraft.gui.listener.ButtonListener;
import org.darkstorm.minecraft.gui.listener.ComboBoxListener;
import org.darkstorm.minecraft.gui.listener.SliderListener;
import org.darkstorm.minecraft.gui.theme.Theme;
import wurst.Client;
import wurst.module.Category;
import wurst.module.Module;
import wurst.module.modules.AutoBuild;

public final class GuiManager
extends AbstractGuiManager {
    private final AtomicBoolean setup = new AtomicBoolean();

    @Override
    public void setup() {
        int scaleFactor;
        if (!this.setup.compareAndSet(false, true)) {
            return;
        }
        HashMap<Category, ModuleFrame> categoryFrames = new HashMap<Category, ModuleFrame>();
        ModuleFrame settings = new ModuleFrame("Settings");
        settings.setTheme(this.theme);
        settings.setLayoutManager(new GridLayoutManager(1, 0));
        settings.setVisible(true);
        settings.setClosable(false);
        settings.setMinimized(true);
        settings.setPinnable(true);
        this.addFrame(settings);
        categoryFrames.put(Category.SETTINGS, settings);
        for (final Module module : Client.Wurst.moduleManager.activeModules) {
            String moduleDescription;
            ModuleFrame frame = (ModuleFrame)categoryFrames.get((Object)module.getCategory());
            if (frame == null) {
                String name = module.getCategory().name().toLowerCase();
                if (Client.Wurst.fileManager.Values.exists()) {
                    Client.Wurst.fileManager.loadValues();
                }
                if (name.equalsIgnoreCase("HIDDEN") || name.equalsIgnoreCase("WIP") && !Client.Wurst.options.WIP) continue;
                if ((name = Character.toUpperCase(name.charAt(0)) + name.substring(1)).equalsIgnoreCase("WIP")) {
                    name = "WIP";
                }
                frame = new ModuleFrame(name);
                frame.setTheme(this.theme);
                frame.setLayoutManager(new GridLayoutManager(1, 0));
                frame.setVisible(true);
                frame.setClosable(false);
                frame.setMinimized(true);
                frame.setPinnable(true);
                this.addFrame(frame);
                categoryFrames.put(module.getCategory(), frame);
            }
            if ((moduleDescription = module.getDescription()).equals("")) {
                moduleDescription = "Error! This is a bug. Please report it.";
            }
            final Module updateModule = module;
            BasicButton button = new BasicButton(module.getName(), moduleDescription){

                @Override
                public void update() {
                    this.setForegroundColor(updateModule.getToggled() ? Color.BLACK : Color.WHITE);
                    this.setBackgroundColor(updateModule.getToggled() ? new Color(0, 255, 0, 128) : new Color(0, 0, 0, 0));
                }
            };
            button.addButtonListener(new ButtonListener(){

                @Override
                public void onButtonPress(Button button) {
                    updateModule.toggleModule();
                }
            });
            frame.add(button, new Constraint[0]);
            if (module.getSliders().isEmpty()) continue;
            for (BasicSlider slider : module.getSliders()) {
                slider.addSliderListener(new SliderListener(){

                    @Override
                    public void onSliderValueChanged(Slider slider) {
                        ArrayList<BasicSlider> moduleSliders = module.getSliders();
                        if (moduleSliders.contains(slider)) {
                            int id2 = moduleSliders.indexOf(slider);
                            moduleSliders.set(id2, (BasicSlider)slider);
                            Client.Wurst.fileManager.saveSliders();
                        }
                        module.setSliders(moduleSliders);
                        module.updateSettings();
                    }
                });
                settings.add(slider, new Constraint[0]);
            }
        }
        if (Client.Wurst.options.WIP) {
            ModuleFrame blocksFrame = (ModuleFrame)categoryFrames.get((Object)Category.WIP);
            BasicComboBox autoBuildBox = new BasicComboBox("Bridge", "Floor", "Nazi", "Penis", "Pillar", "Wall", "Wurst");
            autoBuildBox.addComboBoxListener(new ComboBoxListener(){

                @Override
                public void onComboBoxSelectionChanged(ComboBox comboBox) {
                    AutoBuild.mode = comboBox.getSelectedIndex();
                    Client.Wurst.fileManager.saveValues();
                    Client.Wurst.chat.debug("Selected mode: " + comboBox.getSelectedElement() + " (ID " + comboBox.getSelectedIndex() + ")");
                }
            });
            autoBuildBox.setSelectedIndex(AutoBuild.mode);
            blocksFrame.add(autoBuildBox, GridLayoutManager.HorizontalGridConstraint.CENTER);
        }
        if (!Client.Wurst.fileManager.Sliders.exists()) {
            Client.Wurst.fileManager.saveSliders();
        } else {
            Client.Wurst.fileManager.loadSliders();
        }
        this.resizeComponents();
        azd minecraft = azd.A();
        Dimension maxSize = this.recalculateSizes();
        int offsetX = 5;
        int offsetY = 5;
        int scale = minecraft.u.at;
        if (scale == 0) {
            scale = 1000;
        }
        for (scaleFactor = 0; scaleFactor < scale && minecraft.d / (scaleFactor + 1) >= 320 && minecraft.e / (scaleFactor + 1) >= 240; ++scaleFactor) {
        }
        for (Frame frame : this.getFrames()) {
            frame.setX(offsetX);
            frame.setY(offsetY);
            if ((offsetX += maxSize.width + 5) + maxSize.width + 5 <= minecraft.d / scaleFactor) continue;
            offsetX = 5;
            offsetY += maxSize.height + 5;
        }
        if (Client.Wurst.fileManager.GUI.exists()) {
            Client.Wurst.fileManager.loadGUI(this.getFrames());
        }
    }

    @Override
    protected void resizeComponents() {
        Theme theme = this.getTheme();
        Frame[] frames = this.getFrames();
        BasicButton enable = new BasicButton("Enable", "");
        BasicButton disable = new BasicButton("Disable", "");
        Dimension enableSize = theme.getUIForComponent(enable).getDefaultSize(enable);
        Dimension disableSize = theme.getUIForComponent(disable).getDefaultSize(disable);
        int buttonWidth = Math.max(enableSize.width, disableSize.width);
        int buttonHeight = Math.max(enableSize.height, disableSize.height);
        for (Frame frame : frames) {
            if (!(frame instanceof ModuleFrame)) continue;
            for (Component component : frame.getChildren()) {
                if (!(component instanceof Button)) continue;
                component.setWidth(buttonWidth);
                component.setHeight(buttonHeight);
            }
        }
        this.recalculateSizes();
    }

    private Dimension recalculateSizes() {
        Frame[] frames = this.getFrames();
        int maxWidth = 0;
        int maxHeight = 0;
        for (Frame frame : frames) {
            if (frame.getTitle().equalsIgnoreCase("settings")) continue;
            Dimension defaultDimension = frame.getTheme().getUIForComponent(frame).getDefaultSize(frame);
            maxWidth = Math.max(maxWidth, defaultDimension.width);
            frame.setHeight(defaultDimension.height);
            if (frame.isMinimized()) {
                for (Rectangle area : frame.getTheme().getUIForComponent(frame).getInteractableRegions(frame)) {
                    maxHeight = Math.max(maxHeight, area.height);
                }
                continue;
            }
            maxHeight = Math.max(maxHeight, defaultDimension.height);
        }
        for (Frame frame : frames) {
            if (frame.getTitle().equalsIgnoreCase("settings")) continue;
            frame.setWidth(maxWidth);
            frame.layoutChildren();
        }
        Frame[] frames1 = this.getFrames();
        int maxWidth1 = 0;
        int maxHeight1 = 0;
        for (Frame frame : frames1) {
            if (!frame.getTitle().equalsIgnoreCase("settings")) continue;
            Dimension defaultDimension = frame.getTheme().getUIForComponent(frame).getDefaultSize(frame);
            maxWidth1 = Math.max(maxWidth1, defaultDimension.width);
            frame.setHeight(defaultDimension.height);
            if (frame.isMinimized()) {
                for (Rectangle area : frame.getTheme().getUIForComponent(frame).getInteractableRegions(frame)) {
                    maxHeight1 = Math.max(maxHeight1, area.height);
                }
                continue;
            }
            maxHeight1 = Math.max(maxHeight1, defaultDimension.height);
        }
        for (Frame frame : frames1) {
            if (!frame.getTitle().equalsIgnoreCase("settings")) continue;
            frame.setWidth(maxWidth1);
            frame.layoutChildren();
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private class ModuleFrame
    extends BasicFrame {
        private ModuleFrame() {
        }

        private ModuleFrame(String title) {
            super(title);
        }
    }
}

