/*
 * Decompiled with CFR 0.152.
 */
package wurst.update;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wurst.Client;

public class Updater {
    public boolean updateAvailable = false;
    public String newVersion;
    private static final Logger logger = LogManager.getLogger();

    public void checkForUpdate() {
        HttpURLConnection versionsURL = null;
        try {
            String streamLine;
            URL versionsLink = new URL("https://sites.google.com/site/wurstclient/client/versions");
            versionsURL = (HttpsURLConnection)versionsLink.openConnection();
            versionsURL.setRequestMethod("GET");
            versionsURL.setRequestProperty("Content-Language", "en-US");
            versionsURL.setUseCaches(false);
            versionsURL.setDoInput(true);
            versionsURL.setDoOutput(false);
            versionsURL.connect();
            InputStream replyStream = versionsURL.getInputStream();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(replyStream));
            StringBuffer stringbuffer = new StringBuffer();
            while ((streamLine = streamReader.readLine()) != null) {
                stringbuffer.append(streamLine);
                stringbuffer.append('\r');
            }
            streamReader.close();
            if (versionsURL != null) {
                versionsURL.disconnect();
            }
            String reply = stringbuffer.toString();
            String versions = reply.substring(reply.indexOf("\u00a7{") + 2, reply.indexOf("}$"));
            versions = versions.replace("<br />", "");
            versions = versions.replace("\u00c2", "");
            versions = versions.replace("</div>", "");
            this.newVersion = versions.substring(versions.indexOf("Wurst 1.7"));
            this.newVersion = this.newVersion.substring(0, this.newVersion.indexOf("$"));
            this.newVersion = this.newVersion.substring(this.newVersion.indexOf("'") + 1, this.newVersion.lastIndexOf("'"));
            String currentVersion = Client.Wurst.CLIENT_VERSION;
            boolean bl2 = this.updateAvailable = !this.newVersion.equals(currentVersion) && !currentVersion.contains("(pre-release)");
            if (this.updateAvailable) {
                logger.info("[WURST]: Update available: \"" + this.newVersion + "\".");
                logger.info("[WURST]: Your current version \"" + currentVersion + "\" is out of date.");
            } else if (currentVersion.contains("(pre-release)")) {
                logger.info("[WURST]: Update available: \"" + this.newVersion + "\".");
                logger.info("[WURST]: Ignoring available update because you are using a pre-release.");
            } else {
                logger.info("[WURST]: No update available.");
                logger.info("[WURST]: Your current version \"" + currentVersion + "\" is up to date.");
            }
        }
        catch (Exception e2) {
            if (versionsURL != null) {
                versionsURL.disconnect();
            }
            logger.error("[WURST]: Unable to check for updates.");
            e2.printStackTrace();
        }
    }
}

