/*
 * Decompiled with CFR 0.152.
 */
package diversity;

import diversity.structure.StructureTools;
import diversity.suppliers.SupplierStructure;
import diversity.utils.Configurations;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenStructureDiversity
extends MapGenScatteredFeature {
    private int maxDistanceBetweenScatteredFeatures = Configurations.maxDistanceBetweenStructures.getIntegerConfig();
    private int minDistanceBetweenScatteredFeatures = Configurations.minDistanceBetweenStructures.getIntegerConfig();

    public MapGenStructureDiversity() {
    }

    public MapGenStructureDiversity(Map p_i2061_1_) {
        this();
        for (Map.Entry entry : p_i2061_1_.entrySet()) {
            if (!((String)entry.getKey()).equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.maxDistanceBetweenScatteredFeatures, (int)(this.minDistanceBetweenScatteredFeatures + 1));
        }
    }

    public String func_143025_a() {
        return "Diversity.Structure";
    }

    protected boolean func_75047_a(int x, int z) {
        int coordX = x;
        int coordZ = z;
        if (x < 0) {
            x -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (z < 0) {
            z -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int x1 = x / this.maxDistanceBetweenScatteredFeatures;
        int z1 = z / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(x1, z1, 14357617);
        x1 *= this.maxDistanceBetweenScatteredFeatures;
        z1 *= this.maxDistanceBetweenScatteredFeatures;
        if (coordX == (x1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && coordZ == (z1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            BiomeGenBase biome = this.field_75039_c.func_72959_q().func_76935_a(coordX * 16 + 8, coordZ * 16 + 8);
            return SupplierStructure.canSpawnInBiome(biome);
        }
        return false;
    }

    protected StructureStart func_75049_b(int coordX, int coordZ) {
        return new Start(this.field_75039_c, this.field_75038_b, coordX, coordZ);
    }

    public boolean func_143030_a(int p_143030_1_, int p_143030_2_, int p_143030_3_) {
        return false;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random random, int coordX, int coordZ) {
            super(coordX, coordZ);
            StructureTools.GlobalFeature feature;
            BiomeGenBase biome = world.func_72807_a(coordX * 16 + 8, coordZ * 16 + 8);
            StructureTools structure = SupplierStructure.getRandomStructure(biome, random);
            if (structure != null && (feature = structure.getRandomComponent(random, coordX * 16, coordZ * 16)) != null) {
                this.field_75075_a.add(feature);
            }
            this.func_75072_c();
        }
    }
}

