/*
 * Decompiled with CFR 0.152.
 */
package diversity;

import diversity.suppliers.SupplierVillage;
import diversity.utils.Configurations;
import diversity.village.VillageTools;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenVillageDiversity
extends MapGenVillage {
    private int terrainType;
    private int maxDistanceBetweenVillages = Configurations.maxDistanceBetweenVillages.getIntegerConfig();
    private int minDistanceBetweenVillages = Configurations.minDistanceBetweenVillages.getIntegerConfig();

    public MapGenVillageDiversity() {
    }

    public MapGenVillageDiversity(Map p_i2093_1_) {
        this();
        for (Map.Entry entry : p_i2093_1_.entrySet()) {
            if (((String)entry.getKey()).equals("size")) {
                this.terrainType = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.terrainType, (int)0);
                continue;
            }
            if (!((String)entry.getKey()).equals("distance")) continue;
            this.maxDistanceBetweenVillages = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.maxDistanceBetweenVillages, (int)(this.minDistanceBetweenVillages + 1));
        }
    }

    public String func_143025_a() {
        return "Diversity.Village";
    }

    protected StructureStart func_75049_b(int coordX, int coordZ) {
        return new Start(this.field_75039_c, this.field_75038_b, coordX, coordZ, this.terrainType);
    }

    protected boolean func_75047_a(int x, int z) {
        boolean flag;
        int coordX = x;
        int coordZ = z;
        if (x < 0) {
            x -= this.maxDistanceBetweenVillages - 1;
        }
        if (z < 0) {
            z -= this.maxDistanceBetweenVillages - 1;
        }
        int i1 = x / this.maxDistanceBetweenVillages;
        int j1 = z / this.maxDistanceBetweenVillages;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 10387312);
        i1 *= this.maxDistanceBetweenVillages;
        j1 *= this.maxDistanceBetweenVillages;
        if (coordX == (i1 += random.nextInt(this.maxDistanceBetweenVillages - this.minDistanceBetweenVillages)) && coordZ == (j1 += random.nextInt(this.maxDistanceBetweenVillages - this.minDistanceBetweenVillages)) && (flag = this.field_75039_c.func_72959_q().func_76940_a(coordX * 16 + 8, coordZ * 16 + 8, 0, field_75055_e))) {
            BiomeGenBase biome = this.field_75039_c.func_72959_q().func_76935_a(x * 16 + 8, z * 16 + 8);
            return SupplierVillage.canSpawnInBiome(biome);
        }
        return false;
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World world, Random random, int coordX, int coordZ, int terrainType) {
            super(coordX, coordZ);
            int l;
            BiomeGenBase biome = world.func_72959_q().func_76935_a(coordX * 16 + 8, coordZ * 16 + 8);
            VillageTools villageInstance = SupplierVillage.getRandomVillage(biome, random);
            if (villageInstance == null) {
                this.hasMoreThanTwoComponents = false;
                this.func_75072_c();
                return;
            }
            List list = villageInstance.getStructureVillageWeightedPieceList(random);
            VillageTools.GlobalStart start = villageInstance.getStart(world.func_72959_q(), 0, random, (coordX << 4) + 2, (coordZ << 4) + 2, list, terrainType);
            this.field_75075_a.add(start);
            start.func_74861_a((StructureComponent)start, this.field_75075_a, random);
            List basicComponents = start.field_74930_j;
            List pieceComponents = start.field_74932_i;
            while (!basicComponents.isEmpty() || !pieceComponents.isEmpty()) {
                StructureComponent structurecomponent;
                if (basicComponents.isEmpty()) {
                    l = random.nextInt(pieceComponents.size());
                    structurecomponent = (StructureComponent)pieceComponents.remove(l);
                    structurecomponent.func_74861_a((StructureComponent)start, (List)this.field_75075_a, random);
                    continue;
                }
                l = random.nextInt(basicComponents.size());
                structurecomponent = (StructureComponent)basicComponents.remove(l);
                structurecomponent.func_74861_a((StructureComponent)start, (List)this.field_75075_a, random);
            }
            l = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePieces.Road) continue;
                ++l;
            }
            this.hasMoreThanTwoComponents = l > 2;
            this.func_75072_c();
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound p_143022_1_) {
            super.func_143022_a(p_143022_1_);
            p_143022_1_.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound p_143017_1_) {
            super.func_143017_b(p_143017_1_);
            this.hasMoreThanTwoComponents = p_143017_1_.func_74767_n("Valid");
        }
    }
}

