/*
 * Decompiled with CFR 0.152.
 */
package diversity.entity;

import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import diversity.Diversity;
import diversity.entity.ai.EntityAIChiefHurtByTarget;
import diversity.entity.ai.EntityAIOpenGate;
import diversity.item.ItemSpear;
import diversity.suppliers.SupplierTribe;
import diversity.utils.Configurations;
import diversity.utils.VillageData;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public abstract class EntityGlobalVillager
extends EntityVillager {
    private Village villageObj;
    public final SupplierTribe.EnumTribe tribe;
    private int randomTickDivider;
    private EntityAIBase askForHelp = new EntityAIHurtByTarget((EntityCreature)this, true);
    protected EntityAIBase attackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false);
    protected EntityAIMoveTowardsRestriction aiMoveTowardsRestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
    private EntityAIBase chiefHurt = new EntityAIChiefHurtByTarget(this);
    private EntityAIBase entityHurt = new EntityAIHurtByTarget((EntityCreature)this, true);
    private EntityAITradePlayer aiTradePlayer = new EntityAITradePlayer((EntityVillager)this);
    private EntityAILookAtTradePlayer aiLookAtTradePlayer = new EntityAILookAtTradePlayer((EntityVillager)this);

    public EntityGlobalVillager(World world) {
        this(world, SupplierTribe.EnumVillager.SETTLED_VILLAGER);
    }

    public EntityGlobalVillager(World world, SupplierTribe.EnumVillager type) {
        super(world, type.profession);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiTradePlayer);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiLookAtTradePlayer);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIVillagerMate((EntityVillager)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowGolem((EntityVillager)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIPlay((EntityVillager)this, 0.32));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityVillager.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenGate((EntityLiving)this, true));
        this.tribe = type.tribe;
        this.updateTasks(type);
    }

    public void updateTasks(SupplierTribe.EnumVillager type) {
        if (this.canAskForHelp() && !this.func_70631_g_()) {
            this.field_70715_bh.func_75776_a(1, this.askForHelp);
        } else {
            this.field_70715_bh.func_85156_a(this.askForHelp);
        }
        if (this.canDefend() && !this.func_70631_g_()) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiTradePlayer);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLookAtTradePlayer);
            this.field_70714_bg.func_75776_a(1, this.attackOnCollide);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMoveTowardsRestriction);
            this.field_70715_bh.func_75776_a(2, this.chiefHurt);
            this.field_70715_bh.func_75776_a(3, this.entityHurt);
        } else {
            this.field_70714_bg.func_85156_a(this.attackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMoveTowardsRestriction);
            this.field_70715_bh.func_85156_a(this.chiefHurt);
            this.field_70715_bh.func_85156_a(this.entityHurt);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiTradePlayer);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiLookAtTradePlayer);
        }
        this.func_94058_c(Diversity.proxy.getI18format(type));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attribute != null) {
            attribute.func_111128_a(2.0);
        } else {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.36000001192092895);
    }

    protected abstract boolean canAskForHelp();

    public abstract boolean canDefend();

    public boolean isChief() {
        return SupplierTribe.EnumVillager.findEnum((int)this.func_70946_n()).isChief;
    }

    public void setChief() {
        SupplierTribe.EnumVillager villager = SupplierTribe.EnumVillager.findEnum((int)this.func_70946_n()).tribe.findChief();
        if (villager != null && villager.isChief) {
            this.func_70938_b(villager.profession);
            this.updateTasks(villager);
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_110161_a(p_110161_1_);
        this.setRandomProfession();
        return p_110161_1_;
    }

    private void setRandomProfession() {
        do {
            this.func_70938_b(this.getEnumTribe().getRandomVillager().profession);
        } while (this.isChief());
        this.updateTasks(SupplierTribe.EnumVillager.findEnum(this.func_70946_n()));
    }

    private SupplierTribe.EnumTribe getEnumTribe() {
        return SupplierTribe.EnumTribe.getEnumTribe(this);
    }

    protected void func_70629_bd() {
        super.func_70629_bd();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj != null) {
                if (this.villageObj.func_75566_g()) {
                    VillageData.onAnihilated(this.villageObj);
                    return;
                }
                EntityGlobalVillager chief = (EntityGlobalVillager)this.getChief();
                if (this.isChief()) {
                    if (chief == null) {
                        VillageData.addChief(this.villageObj, this);
                    } else if (!chief.equals((Object)this)) {
                        this.setRandomProfession();
                    }
                } else {
                    Random random = new Random();
                    if (chief == null && random.nextInt(Configurations.chanceVillagerBecomesChief.getIntegerConfig()) == 0) {
                        VillageData.addChief(this.villageObj, this);
                        if (this.isChief()) {
                            this.func_70934_b(null).clear();
                            VillagerRegistry.manageVillagerTrades((MerchantRecipeList)this.func_70934_b(null), (EntityVillager)this, (int)this.func_70946_n(), (Random)this.field_70146_Z);
                            this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 1.666, this.field_70161_v, 1.0, 1.0, 1.0);
                            this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.5, this.field_70163_u + 1.666, this.field_70161_v, 1.0, 1.0, 1.0);
                            this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.5, this.field_70163_u + 1.666, this.field_70161_v, 1.0, 1.0, 1.0);
                            this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 1.666, this.field_70161_v - 0.5, 1.0, 1.0, 1.0);
                            this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 1.666, this.field_70161_v + 0.5, 1.0, 1.0, 1.0);
                        }
                    }
                }
            }
        }
    }

    protected void func_70785_a(Entity p_70785_1_, float p_70785_2_) {
        if (this.field_70724_aR <= 0 && p_70785_2_ < 2.0f && p_70785_1_.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && p_70785_1_.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(p_70785_1_);
        }
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (p_70652_1_ instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)p_70652_1_));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)p_70652_1_));
        }
        boolean flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        return flag;
    }

    protected void func_70609_aI() {
        if (this.isChief()) {
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            VillageData.onDeadChief(this.villageObj);
        }
        super.func_70609_aI();
    }

    protected void func_82160_b(boolean p_82160_1_, int p_82160_2_) {
        if (this.canDefend() && !this.func_70631_g_()) {
            super.func_82160_b(p_82160_1_, p_82160_2_);
        }
    }

    public boolean func_142018_a(EntityLivingBase p_142018_1_, EntityLivingBase p_142018_2_) {
        if (!(p_142018_1_ instanceof EntityCreeper) && !(p_142018_1_ instanceof EntityGhast)) {
            EntityWolf entitywolf;
            if (p_142018_1_ instanceof EntityWolf && (entitywolf = (EntityWolf)p_142018_1_).func_70909_n() && entitywolf.func_70902_q() == p_142018_2_) {
                return false;
            }
            return p_142018_1_ instanceof EntityPlayer && p_142018_2_ instanceof EntityGlobalVillager ? false : !(p_142018_1_ instanceof EntityHorse) || !((EntityHorse)p_142018_1_).func_110248_bS();
        }
        return false;
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        if (!this.canDefend()) {
            return super.func_70085_c(p_70085_1_);
        }
        return false;
    }

    public EntityLivingBase getChief() {
        if (this.villageObj != null) {
            return VillageData.getChief(this.villageObj);
        }
        return null;
    }

    public boolean func_94056_bM() {
        return false;
    }

    public ItemStack func_70694_bm() {
        return this.canDefend() && !this.func_70631_g_() ? super.func_70694_bm() : null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_70620_b(ItemStack p_70620_1_, int p_70620_2_) {
        if (p_70620_1_.func_77973_b() instanceof ItemSpear) {
            return ((ItemSpear)p_70620_1_.func_77973_b()).getIcon(p_70620_1_, 0);
        }
        return p_70620_1_.func_77973_b().func_77623_v() ? p_70620_1_.func_77973_b().func_77618_c(p_70620_1_.func_77960_j(), p_70620_2_) : p_70620_1_.func_77954_c();
    }
}

