/*
 * Decompiled with CFR 0.152.
 */
package diversity.structure;

import diversity.entity.EntityWarriorSkeleton;
import diversity.structure.StructureTools;
import diversity.utils.ChestGenTools;
import diversity.utils.DirectionTools;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class StructureForest
extends StructureTools {
    @Override
    public StructureTools.GlobalFeature getRandomComponent(Random random, int coordX, int coordZ) {
        return new Catacomb(random, coordX, coordZ);
    }

    public static class Catacomb
    extends StructureTools.GlobalFeature {
        private static MossyStones randomMossyStones = new MossyStones(null);
        private static CrackedStones randomCrackedStones = new CrackedStones(null);
        private static MossyCobbestones randomMossyCobblestones = new MossyCobbestones(null);
        public static final WeightedRandomChestContent[] itemsToGenerateCatacomb = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 3), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151043_k, 0, 2, 7, 15), new WeightedRandomChestContent(Items.field_151166_bC, 0, 1, 3, 2), new WeightedRandomChestContent(Items.field_151103_aS, 0, 4, 6, 20), new WeightedRandomChestContent(Items.field_151078_bh, 0, 3, 7, 16), new WeightedRandomChestContent(Items.field_151070_bp, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151061_bv, 0, 1, 1, 1), new WeightedRandomChestContent(Items.field_151062_by, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151020_U, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151023_V, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151022_W, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151029_X, 0, 1, 1, 1)};
        private boolean[] isTrap = new boolean[2];

        public Catacomb() {
        }

        public Catacomb(Random random, int coordX, int coordZ) {
            super(random, coordX, coordZ, 25, 21, 26);
            this.isTrap[0] = random.nextBoolean();
            this.isTrap[1] = random.nextBoolean();
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("T0", this.isTrap[0]);
            p_143012_1_.func_74757_a("T1", this.isTrap[1]);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.isTrap[0] = p_143011_1_.func_74767_n("T0");
            this.isTrap[1] = p_143011_1_.func_74767_n("T1");
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int y;
            if (!this.func_74935_a(world, structureBoundingBox, -16)) {
                return false;
            }
            this.func_151549_a(world, structureBoundingBox, 4, 0, 0, 20, 5, 12, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_151549_a(world, structureBoundingBox, 5, -1, 16, 19, 9, 24, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            for (int x = 10; x < 15; ++x) {
                for (int z = 12; z < 17; ++z) {
                    this.func_74871_b(world, x, 0, z, structureBoundingBox);
                    if (!(x != 10 && x != 14 || z != 12 && z != 16)) {
                        y = 2 + random.nextInt(5);
                        this.func_74882_a(world, structureBoundingBox, x, 0, z, x, y, z, false, random, randomMossyStones);
                        this.func_74882_a(world, structureBoundingBox, x, y + 1, z, x, 16, z, false, random, randomCrackedStones);
                        continue;
                    }
                    this.func_74882_a(world, structureBoundingBox, x, 0, z, x, 0, z, false, random, randomMossyCobblestones);
                    this.func_151550_a(world, Blocks.field_150355_j, 0, x, 1, z, structureBoundingBox);
                }
            }
            for (int k = 0; k < 3; ++k) {
                y = 2 + random.nextInt(5);
                this.func_74882_a(world, structureBoundingBox, 9, 0, 13 + k, 9, y, 13 + k, false, random, randomMossyStones);
                this.func_74882_a(world, structureBoundingBox, 9, y + 1, 13 + k, 9, 16, 13 + k, false, random, randomCrackedStones);
                y = 2 + random.nextInt(5);
                this.func_74882_a(world, structureBoundingBox, 15, 0, 13 + k, 15, y, 13 + k, false, random, randomMossyStones);
                this.func_74882_a(world, structureBoundingBox, 15, y + 1, 13 + k, 15, 16, 13 + k, false, random, randomCrackedStones);
                y = 2 + random.nextInt(5);
                this.func_74882_a(world, structureBoundingBox, 11 + k, 0, 11, 11 + k, y, 11, false, random, randomMossyStones);
                this.func_74882_a(world, structureBoundingBox, 11 + k, y + 1, 11, 11 + k, 16, 11, false, random, randomCrackedStones);
                y = 2 + random.nextInt(5);
                this.func_74882_a(world, structureBoundingBox, 11 + k, 0, 17, 11 + k, y, 17, false, random, randomMossyStones);
                this.func_74882_a(world, structureBoundingBox, 11 + k, y + 1, 17, 11 + k, 16, 17, false, random, randomCrackedStones);
            }
            for (y = 17; y < 19; ++y) {
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 9, y, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 9, y, 15, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 10, y, 16, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 10, y, 12, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 15, y, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 15, y, 15, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 14, y, 16, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 14, y, 12, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 11, y, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 13, y, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 11, y, 17, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150463_bK, 0, 13, y, 17, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 11, 19, 16, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 10, 19, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 9, 19, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 10, 19, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 11, 19, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 9, 19, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 10, 19, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 11, 19, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 12, 19, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 13, 19, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 14, 19, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 15, 19, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 13, 19, 16, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 14, 19, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 15, 19, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 14, 19, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 13, 19, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 9, 19, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 10, 19, 16, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 11, 19, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 12, 19, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 13, 19, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 14, 19, 16, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 15, 19, 15, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 10, 20, 14, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 11, 20, 15, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 12, 20, 16, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 13, 20, 15, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 14, 20, 14, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 13, 20, 13, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 12, 20, 12, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 11, 20, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][0], 11, 20, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][2], 12, 20, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][1], 13, 20, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, DirectionTools.stair[this.field_74885_f][3], 12, 20, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 12, 20, 14, structureBoundingBox);
            this.func_74882_a(world, structureBoundingBox, 0, 0, 8, 4, 0, 20, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 0, 1, 8, 4, 1, 20, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 0, 2, 8, 4, 4, 20, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 1, 2, 10, 3, 3, 18);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 10, 2, 1, 18, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151556_a(world, structureBoundingBox, 1, 3, 10, 1, 3, 18, Blocks.field_150390_bg, DirectionTools.reversed_stairs[this.field_74885_f][1], Blocks.field_150446_ar, DirectionTools.reversed_stairs[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 3, 3, 10, 3, 3, 18, Blocks.field_150390_bg, DirectionTools.reversed_stairs[this.field_74885_f][0], Blocks.field_150446_ar, DirectionTools.reversed_stairs[this.field_74885_f][0], false);
            this.spawnEntity(world, structureBoundingBox, 2, 1, 10, 0);
            this.spawnEntity(world, structureBoundingBox, 2, 1, 18, 0);
            this.func_74882_a(world, structureBoundingBox, 20, 0, 8, 24, 0, 20, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 20, 1, 8, 24, 1, 20, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 20, 2, 8, 24, 4, 20, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 21, 2, 10, 23, 3, 18);
            this.func_151549_a(world, structureBoundingBox, 22, 1, 10, 22, 1, 18, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151556_a(world, structureBoundingBox, 21, 3, 10, 21, 3, 18, Blocks.field_150390_bg, DirectionTools.reversed_stairs[this.field_74885_f][1], Blocks.field_150446_ar, DirectionTools.reversed_stairs[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 23, 3, 10, 23, 3, 18, Blocks.field_150390_bg, DirectionTools.reversed_stairs[this.field_74885_f][0], Blocks.field_150446_ar, DirectionTools.reversed_stairs[this.field_74885_f][0], false);
            this.spawnEntity(world, structureBoundingBox, 22, 1, 10, 0);
            this.spawnEntity(world, structureBoundingBox, 22, 1, 18, 0);
            this.func_74882_a(world, structureBoundingBox, 5, 0, 13, 9, 0, 15, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 5, 1, 13, 9, 1, 15, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 5, 2, 13, 9, 3, 15, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 4, 2, 14, 9, 2, 14);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 14, 9, 1, 14, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74882_a(world, structureBoundingBox, 15, 0, 13, 19, 0, 15, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 15, 1, 13, 19, 1, 15, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 15, 2, 13, 19, 3, 15, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 15, 2, 14, 20, 2, 14);
            this.func_151549_a(world, structureBoundingBox, 15, 1, 14, 21, 1, 14, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74882_a(world, structureBoundingBox, 11, 0, 18, 13, 0, 25, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 11, 1, 18, 13, 1, 25, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 11, 2, 18, 13, 3, 25, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 12, 2, 17, 12, 2, 23);
            this.func_151549_a(world, structureBoundingBox, 12, 1, 17, 12, 1, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 11, 2, 23, 13, 2, 23);
            this.func_151549_a(world, structureBoundingBox, 11, 1, 23, 13, 1, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74882_a(world, structureBoundingBox, 6, 0, 20, 10, 0, 25, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 6, 1, 20, 10, 4, 25, false, random, randomMossyStones);
            this.func_74878_a(world, structureBoundingBox, 7, 2, 22, 9, 3, 23);
            this.func_151549_a(world, structureBoundingBox, 7, 1, 22, 9, 1, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 10, 1, 22, 10, 2, 22);
            this.func_74882_a(world, structureBoundingBox, 14, 0, 20, 18, 0, 25, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 14, 1, 20, 18, 4, 25, false, random, randomMossyStones);
            this.func_74878_a(world, structureBoundingBox, 15, 2, 22, 17, 3, 23);
            this.func_151549_a(world, structureBoundingBox, 15, 1, 22, 17, 1, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 14, 1, 22, 14, 2, 22);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 12, 2, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150355_j, 0, 12, 1, 11, structureBoundingBox);
            this.func_74882_a(world, structureBoundingBox, 10, 0, 6, 14, 0, 10, false, random, randomMossyCobblestones);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 6, 14, 1, 10, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 10, 2, 6, 14, 3, 10);
            this.func_74882_a(world, structureBoundingBox, 10, 4, 6, 14, 4, 10, false, random, randomCrackedStones);
            this.func_74882_a(world, structureBoundingBox, 10, 1, 6, 10, 1, 6, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 10, 2, 6, 10, 3, 6, false, random, randomCrackedStones);
            this.func_74882_a(world, structureBoundingBox, 10, 1, 10, 10, 1, 10, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 10, 2, 10, 10, 3, 10, false, random, randomCrackedStones);
            this.func_74882_a(world, structureBoundingBox, 14, 1, 6, 14, 1, 6, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 14, 2, 6, 14, 3, 6, false, random, randomCrackedStones);
            this.func_74882_a(world, structureBoundingBox, 14, 1, 10, 14, 1, 10, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 14, 2, 10, 14, 3, 10, false, random, randomCrackedStones);
            this.func_74882_a(world, structureBoundingBox, 15, 0, 6, 18, 0, 9, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 15, 1, 6, 18, 1, 9, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 15, 2, 6, 18, 3, 9, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 15, 2, 8, 15, 2, 8);
            this.func_74878_a(world, structureBoundingBox, 17, 2, 8, 17, 2, 8);
            this.func_151549_a(world, structureBoundingBox, 15, 1, 8, 15, 1, 8, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 17, 1, 8, 17, 1, 8, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 16, 1, 9, 16, 2, 9);
            this.func_74882_a(world, structureBoundingBox, 6, 0, 6, 9, 0, 9, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 6, 1, 6, 9, 1, 9, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 6, 2, 6, 9, 3, 9, false, random, randomCrackedStones);
            this.func_74878_a(world, structureBoundingBox, 7, 2, 8, 7, 2, 8);
            this.func_74878_a(world, structureBoundingBox, 9, 2, 8, 9, 2, 8);
            this.func_151549_a(world, structureBoundingBox, 7, 1, 8, 7, 1, 8, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 8, 9, 1, 8, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_74878_a(world, structureBoundingBox, 8, 1, 9, 8, 2, 9);
            this.func_74882_a(world, structureBoundingBox, 10, 0, 3, 14, 0, 5, false, random, randomMossyCobblestones);
            this.func_74882_a(world, structureBoundingBox, 10, 1, 3, 14, 1, 5, false, random, randomMossyStones);
            this.func_74882_a(world, structureBoundingBox, 10, 2, 3, 14, 3, 5, false, random, randomCrackedStones);
            this.func_151550_a(world, Blocks.field_150355_j, 0, 12, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 12, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 12, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 12, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 11, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 13, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150442_at, 6, 2, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 3, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][1], 4, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 0, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 1, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 9, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 2), 10, 1, 21, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 2), 10, 2, 21, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150416_aS, this.func_151555_a((Block)Blocks.field_150416_aS, 0), 10, 2, 20, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 8, 1, 22, 0);
            this.func_151550_a(world, Blocks.field_150442_at, 6, 22, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 21, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 20, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][0], 20, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 18, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 0, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 16, 1, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 0, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 15, 1, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 15, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 2), 14, 1, 21, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 2), 14, 2, 21, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150416_aS, this.func_151555_a((Block)Blocks.field_150416_aS, 0), 14, 2, 20, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 16, 1, 22, 0);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 12, 2, 24, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 16, 2, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 16, 2, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 19, 2, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 19, 2, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 8, 2, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 8, 2, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 5, 2, 15, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 5, 2, 13, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 8, 3, 21, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 16, 3, 21, structureBoundingBox);
            if (this.isTrap[0]) {
                this.generateStructureTrappedChestContents(world, structureBoundingBox, random, 16, 2, 21, ChestGenTools.getItems("catacombChest", random), ChestGenTools.getCount("catacombChest", random));
            } else {
                this.func_74879_a(world, structureBoundingBox, random, 16, 2, 21, ChestGenTools.getItems("catacombChest", random), ChestGenTools.getCount("catacombChest", random));
            }
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 2, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 16, 1, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 2), 16, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 2, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 3), 15, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 2, 18, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 16, 3, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 3, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 16, 4, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 4, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 17, 5, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 5, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 16, 6, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 6, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 6, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 5, 16, 7, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 7, 21, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 16, 8, 21, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 15, 8, 22, 17, 8, 23, (Block)Blocks.field_150488_af, (Block)Blocks.field_150488_af, false);
            this.func_74878_a(world, structureBoundingBox, 15, 5, 22, 17, 5, 23);
            this.func_151556_a(world, structureBoundingBox, 15, 6, 22, 17, 6, 23, (Block)Blocks.field_150320_F, 0, (Block)Blocks.field_150320_F, 0, false);
            this.func_151549_a(world, structureBoundingBox, 14, 4, 22, 14, 4, 22, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 18, 4, 22, 18, 4, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 15, 4, 21, 17, 4, 21, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 15, 4, 24, 17, 4, 24, Blocks.field_150355_j, Blocks.field_150355_j, false);
            if (this.isTrap[1]) {
                this.generateStructureTrappedChestContents(world, structureBoundingBox, random, 8, 2, 21, ChestGenTools.getItems("catacombChest", random), ChestGenTools.getCount("catacombChest", random));
            } else {
                this.func_74879_a(world, structureBoundingBox, random, 8, 2, 21, ChestGenTools.getItems("catacombChest", random), ChestGenTools.getCount("catacombChest", random));
            }
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 2, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 8, 1, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 2), 8, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 2, 19, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 2, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 1), 9, 2, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 2, 18, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 3, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 3, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 13, 8, 4, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 4, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 7, 5, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 5, 17, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 6, 17, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 6, 18, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 6, 19, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 5, 8, 7, 20, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 7, 21, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 8, 21, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 7, 8, 22, 9, 8, 23, (Block)Blocks.field_150488_af, (Block)Blocks.field_150488_af, false);
            this.func_74878_a(world, structureBoundingBox, 7, 5, 22, 9, 5, 23);
            this.func_151556_a(world, structureBoundingBox, 7, 6, 22, 9, 6, 23, (Block)Blocks.field_150320_F, 0, (Block)Blocks.field_150320_F, 0, false);
            this.func_151549_a(world, structureBoundingBox, 6, 4, 22, 6, 4, 23, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 10, 4, 22, 10, 4, 22, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 7, 4, 21, 9, 4, 21, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 7, 4, 24, 9, 4, 24, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151550_a(world, Blocks.field_150442_at, 6, 22, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][0], 21, 1, 9, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 20, 1, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 20, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 19, 3, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 19, 4, 8, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 2, 9, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 18, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 3, 8, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 4, 7, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 4, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 4, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 19, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 18, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 15, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 13, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150442_at, 6, 2, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][1], 3, 1, 9, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 4, 1, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 3, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 4, 8, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 2, 9, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 3, 8, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 4, 7, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 4, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 4, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 5, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 9, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 11, 4, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 16, 1, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 16, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 5, 17, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 8, 1, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 8, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 5, 7, 2, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, 0, 12, 4, 4, structureBoundingBox);
            this.generateStructureTrappedChestContents(world, structureBoundingBox, random, 12, 2, 3, ChestGenTools.getItems("catacombChest", random), ChestGenTools.getCount("catacombChest", random));
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 2), 12, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 12, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 13, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 14, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 15, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 16, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 15, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 3), 16, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 18, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 18, 3, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 18, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 18, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 5, 18, 3, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 17, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 15, 1, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 15, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 15, 3, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 4), 16, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 4), 16, 2, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 4), 16, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 14, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 14, 3, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 11, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 9, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 9, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150413_aR, this.func_151555_a((Block)Blocks.field_150413_aR, 1), 8, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 3, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 5, 6, 3, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 7, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 1, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 3, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 5), 8, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 5), 8, 2, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 5), 8, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 10, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 10, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 12, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 12, 1, 7, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 12, 2, 8, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 12, 2, 7, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 17, 1, 8, 0);
            this.spawnEntity(world, structureBoundingBox, 7, 1, 8, 0);
            this.spawnEntity(world, structureBoundingBox, 10, 2, 5, 0);
            this.spawnEntity(world, structureBoundingBox, 14, 2, 5, 0);
            this.spawnEntity(world, structureBoundingBox, 12, 1, 14, 0);
            return false;
        }

        protected boolean func_74935_a(World p_74935_1_, StructureBoundingBox p_74935_2_, int p_74935_3_) {
            if (this.field_74936_d >= 0) {
                return true;
            }
            int j = 0;
            int k = 0;
            for (int l = this.field_74887_e.field_78896_c; l <= this.field_74887_e.field_78892_f; ++l) {
                for (int i1 = this.field_74887_e.field_78897_a; i1 <= this.field_74887_e.field_78893_d; ++i1) {
                    if (!p_74935_2_.func_78890_b(i1, 64, l)) continue;
                    j += Math.max(p_74935_1_.func_72825_h(i1, l), p_74935_1_.field_73011_w.func_76557_i());
                    ++k;
                }
            }
            if (k == 0) {
                return false;
            }
            this.field_74936_d = j / k;
            this.field_74887_e.func_78886_a(0, this.field_74936_d - this.field_74887_e.field_78895_b + p_74935_3_, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityWarriorSkeleton(world, false);
        }

        static class MossyCobbestones
        extends StructureComponent.BlockSelector {
            private MossyCobbestones() {
            }

            public void func_75062_a(Random p_75062_1_, int p_75062_2_, int p_75062_3_, int p_75062_4_, boolean p_75062_5_) {
                this.field_151562_a = p_75062_1_.nextFloat() < 0.4f ? Blocks.field_150347_e : Blocks.field_150341_Y;
            }

            MossyCobbestones(Object p_i2063_1_) {
                this();
            }
        }

        static class CrackedStones
        extends StructureComponent.BlockSelector {
            private CrackedStones() {
            }

            public void func_75062_a(Random p_75062_1_, int p_75062_2_, int p_75062_3_, int p_75062_4_, boolean p_75062_5_) {
                this.field_151562_a = Blocks.field_150417_aV;
                this.field_75065_b = p_75062_1_.nextFloat() < 0.4f ? 0 : 2;
            }

            CrackedStones(Object p_i2063_1_) {
                this();
            }
        }

        static class MossyStones
        extends StructureComponent.BlockSelector {
            private MossyStones() {
            }

            public void func_75062_a(Random p_75062_1_, int p_75062_2_, int p_75062_3_, int p_75062_4_, boolean p_75062_5_) {
                this.field_151562_a = Blocks.field_150417_aV;
                this.field_75065_b = p_75062_1_.nextFloat() < 0.4f ? 0 : 1;
            }

            MossyStones(Object p_i2063_1_) {
                this();
            }
        }
    }
}

