/*
 * Decompiled with CFR 0.152.
 */
package diversity.structure;

import diversity.entity.EntitySettled;
import diversity.entity.EntityWorshipper;
import diversity.structure.StructureTools;
import diversity.suppliers.SupplierTribe;
import diversity.utils.ChestGenTools;
import diversity.utils.DirectionTools;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class StructurePlain
extends StructureTools {
    @Override
    public StructureTools.GlobalFeature getRandomComponent(Random random, int coordX, int coordZ) {
        return new Inn(random, coordX, coordZ);
    }

    public static class Inn
    extends StructureTools.GlobalFeature {
        public static final WeightedRandomChestContent[] itemsToGenerateInn = new WeightedRandomChestContent[]{new WeightedRandomChestContent((Item)Items.field_151169_ag, 0, 1, 5, 10), new WeightedRandomChestContent((Item)Items.field_151151_aj, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151043_k, 0, 2, 9, 15), new WeightedRandomChestContent(Items.field_151010_B, 0, 1, 5, 12), new WeightedRandomChestContent((Item)Items.field_151171_ah, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151153_ao, 0, 5, 10, 20), new WeightedRandomChestContent((Item)Items.field_151149_ai, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151074_bl, 0, 10, 10, 20)};
        private boolean[] isTorch = new boolean[3];

        public Inn() {
        }

        public Inn(Random random, int coordX, int coordZ) {
            super(random, coordX, coordZ, 21, 8, 12);
            this.isTorch[0] = random.nextBoolean();
            this.isTorch[1] = random.nextBoolean();
            this.isTorch[2] = this.isTorch[0] && this.isTorch[1] ? false : random.nextBoolean();
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("T0", this.isTorch[0]);
            p_143012_1_.func_74757_a("T1", this.isTorch[1]);
            p_143012_1_.func_74757_a("T2", this.isTorch[2]);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.isTorch[0] = p_143011_1_.func_74767_n("T0");
            this.isTorch[1] = p_143011_1_.func_74767_n("T1");
            this.isTorch[2] = p_143011_1_.func_74767_n("T2");
        }

        @Override
        protected boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            int x;
            if (!this.func_74935_a(world, structureBoundingBox, -1)) {
                return false;
            }
            for (x = 3; x < 19; ++x) {
                for (z = 1; z < 10; ++z) {
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            for (x = 0; x < 21; ++x) {
                for (z = -1; z < 11; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150349_c, 0, x, 0, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 1, -2, 4, 11, -1, 10, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_74878_a(world, structureBoundingBox, 4, -2, 5, 10, -1, 8);
            this.func_151549_a(world, structureBoundingBox, 0, -10, -1, 20, -3, 10, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 4, 3, 5, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, -2, 8, 3, 5, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 3, 4, 6, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 4, -2, 9, 4, 6, 9, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 3, 8, 6, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 9, 8, 6, 9, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 4, 9, 5, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 8, 9, 5, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 13, 1, 4, 13, 3, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 13, 1, 8, 13, 3, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151556_a(world, structureBoundingBox, 5, 4, 3, 7, 4, 3, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 5, 4, 9, 7, 4, 9, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 3, 4, 5, 3, 4, 7, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 9, 4, 5, 9, 4, 7, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 13, 4, 5, 13, 4, 7, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 3, 7, 3, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 5, 5, 3, 7, 7, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 9, 7, 3, 9, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 5, 5, 9, 7, 7, 9, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 4, 12, 3, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 8, 12, 3, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 5, 3, 3, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 13, 1, 5, 13, 3, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151556_a(world, structureBoundingBox, 2, 5, 4, 2, 5, 8, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 3, 6, 3, 3, 6, 9, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 4, 7, 3, 4, 7, 9, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151549_a(world, structureBoundingBox, 5, 8, 3, 5, 8, 9, (Block)Blocks.field_150376_bx, (Block)Blocks.field_150376_bx, false);
            this.func_151549_a(world, structureBoundingBox, 6, 8, 3, 6, 8, 9, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 7, 8, 3, 7, 8, 9, (Block)Blocks.field_150376_bx, (Block)Blocks.field_150376_bx, false);
            this.func_151556_a(world, structureBoundingBox, 8, 7, 3, 8, 7, 9, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 9, 6, 3, 9, 6, 9, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 10, 5, 4, 10, 5, 8, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 9, 3, 3, 13, 3, 3, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 10, 4, 4, 13, 4, 4, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151549_a(world, structureBoundingBox, 11, 5, 5, 13, 5, 5, (Block)Blocks.field_150376_bx, (Block)Blocks.field_150376_bx, false);
            this.func_151549_a(world, structureBoundingBox, 10, 5, 6, 13, 5, 6, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 11, 5, 7, 13, 5, 7, (Block)Blocks.field_150376_bx, (Block)Blocks.field_150376_bx, false);
            this.func_151556_a(world, structureBoundingBox, 10, 4, 8, 13, 4, 8, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 9, 3, 9, 13, 3, 9, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 4, 8, 0, 8, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 9, 0, 5, 12, 0, 7, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151556_a(world, structureBoundingBox, 4, 4, 4, 8, 4, 8, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 6, 0, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 11, 0, 8, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 5, 0, 5, 5, 0, 7, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], false);
            this.func_151550_a(world, Blocks.field_150364_r, 0, 5, 1, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 5, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 5, 1, 7, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 5, -2, 8, 5, 1, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151550_a(world, Blocks.field_150396_be, this.func_151555_a(Blocks.field_150396_be, 1), 5, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 5, 2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 6, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 7, 2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 8, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][2], 8, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 8, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 9, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][3], 12, 1, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 12, 1, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 12, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][2], 12, 1, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 3, 9, 1, 9, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 11, 9, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 1, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 12, 1, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 12, 2, 9, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 9, 0, 3, 12, 0, 3, Blocks.field_150346_d, 1, Blocks.field_150346_d, 1, false);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 4, 9, 1, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 12, 9, 2, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150328_O, 8, 10, 1, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150328_O, 0, 11, 1, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 3, 12, 1, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150398_cm, 11, 12, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 11, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 13, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150396_be, this.func_151555_a(Blocks.field_150396_be, 1), 13, 1, 2, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 13, 1, 1, 18, 1, 1, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 18, 1, 2, 18, 1, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 14, 1, 8, 18, 1, 8, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 3, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 6, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 6, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 11, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 13, 2, 6, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 6, 1, 3, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_74881_a(world, structureBoundingBox, random, 11, 1, 8, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151549_a(world, structureBoundingBox, 5, 0, 2, 12, 0, 2, Blocks.field_150351_n, Blocks.field_150351_n, false);
            this.func_151550_a(world, Blocks.field_150351_n, 0, 11, 0, 9, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 10, 4, 5, 12, 4, 7, Blocks.field_150344_f, Blocks.field_150344_f, false);
            int meta = this.func_151555_a(Blocks.field_150468_ap, 3);
            this.func_151556_a(world, structureBoundingBox, 4, -2, 8, 4, 5, 8, Blocks.field_150468_ap, meta, Blocks.field_150468_ap, meta, false);
            this.func_151550_a(world, Blocks.field_150364_r, 0, 7, -2, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 8, -2, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 9, -2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, 0, 10, -2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 10, -1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 6, -2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 6, -1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150442_at, BlockLever.func_149819_b((int)this.func_151555_a(Blocks.field_150442_at, 3)) + 8, 6, -1, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 8, -2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 8, -1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150442_at, BlockLever.func_149819_b((int)this.func_151555_a(Blocks.field_150442_at, 3)) + 8, 8, -1, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 10, -2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 10, -1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150442_at, BlockLever.func_149819_b((int)this.func_151555_a(Blocks.field_150442_at, 3)) + 8, 10, -1, 7, structureBoundingBox);
            if (this.isTorch[0]) {
                this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][2], 6, -1, 9, structureBoundingBox);
            } else {
                this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 6, -1, 9, structureBoundingBox);
            }
            if (this.isTorch[1]) {
                this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][2], 8, -1, 9, structureBoundingBox);
            } else {
                this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 8, -1, 9, structureBoundingBox);
            }
            if (this.isTorch[2]) {
                this.func_151550_a(world, Blocks.field_150429_aA, DirectionTools.torch[this.field_74885_f][2], 10, -1, 9, structureBoundingBox);
            } else {
                this.func_151550_a(world, (Block)Blocks.field_150488_af, 0, 10, -1, 9, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 4, -1, 10, 10, -1, 10, (Block)Blocks.field_150488_af, (Block)Blocks.field_150488_af, false);
            this.func_151549_a(world, structureBoundingBox, 4, -1, 11, 10, -1, 11, Blocks.field_150346_d, Blocks.field_150346_d, false);
            this.func_151549_a(world, structureBoundingBox, 3, -7, 9, 3, -1, 9, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151556_a(world, structureBoundingBox, 3, -7, 8, 3, -3, 8, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 3), Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 3), false);
            this.func_74878_a(world, structureBoundingBox, 3, -2, 8, 3, -1, 8);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 3, -1, 10, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150320_F, this.func_151555_a((Block)Blocks.field_150320_F, 3), 3, -2, 10, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 4, -3, 1, 19, -3, 9, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_74878_a(world, structureBoundingBox, 3, -7, 7, 3, -6, 7);
            this.func_151549_a(world, structureBoundingBox, 1, -8, 4, 3, -8, 8, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_151549_a(world, structureBoundingBox, 4, -8, 4, 4, -8, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_74878_a(world, structureBoundingBox, 1, -7, 4, 4, -5, 6);
            this.func_151549_a(world, structureBoundingBox, 5, -9, 3, 5, -9, 7, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_74878_a(world, structureBoundingBox, 5, -8, 3, 5, -5, 7);
            this.func_151549_a(world, structureBoundingBox, 6, -9, 2, 6, -9, 8, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_74878_a(world, structureBoundingBox, 6, -8, 2, 6, -5, 8);
            this.func_151549_a(world, structureBoundingBox, 7, -10, 1, 16, -10, 9, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_74878_a(world, structureBoundingBox, 7, -9, 1, 16, -4, 9);
            this.func_151549_a(world, structureBoundingBox, 17, -10, 2, 17, -10, 8, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_74878_a(world, structureBoundingBox, 17, -9, 2, 17, -4, 8);
            this.func_151549_a(world, structureBoundingBox, 18, -10, 3, 18, -10, 7, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_74878_a(world, structureBoundingBox, 18, -9, 3, 18, -4, 7);
            this.func_151549_a(world, structureBoundingBox, 19, -10, 4, 19, -10, 6, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_74878_a(world, structureBoundingBox, 19, -9, 4, 19, -4, 6);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, -7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 1, -6, 5, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 9, -9, 2, 9, -4, 2, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 9, -9, 3, 9, -8, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 9, -7, 3, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 9, -9, 8, 9, -4, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 9, -9, 7, 9, -8, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 9, -7, 7, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 12, -9, 2, 12, -4, 2, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 12, -9, 3, 12, -8, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 12, -7, 3, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 12, -9, 8, 12, -4, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 12, -9, 7, 12, -8, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 12, -7, 7, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 2, 15, -4, 2, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 3, 15, -8, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 15, -7, 3, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 8, 15, -4, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 7, 15, -8, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 15, -7, 7, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 4, 17, -9, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 15, -9, 5, 16, -9, 5, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151549_a(world, structureBoundingBox, 15, -8, 5, 16, -8, 5, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 19, -9, 5, 19, -8, 5, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 19, -7, 5, structureBoundingBox);
            this.func_74879_a(world, structureBoundingBox, random, 14, -9, 5, ChestGenTools.getItems("underInnChest", random), ChestGenTools.getCount("underInnChest", random));
            this.spawnEntity(world, structureBoundingBox, 10, -8, 1, 0);
            this.spawnEntity(world, structureBoundingBox, 10, -8, 9, 0);
            this.spawnEntity(world, structureBoundingBox, 13, -8, 1, 0);
            this.spawnEntity(world, structureBoundingBox, 13, -8, 9, 0);
            this.spawnEntity(world, structureBoundingBox, 16, -8, 1, 0);
            this.spawnEntity(world, structureBoundingBox, 16, -8, 9, 0);
            this.spawnEntity(world, structureBoundingBox, 17, -7, 5, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 6, 1);
            this.spawnEntity(world, structureBoundingBox, 7, 2, 6, 2);
            this.spawnEntity(world, structureBoundingBox, 8, 2, 6, 2);
            this.spawnEntity(world, structureBoundingBox, 9, 2, 6, 2);
            this.spawnEntity(world, structureBoundingBox, 16, 2, 3, 3);
            this.spawnEntity(world, structureBoundingBox, 16, 2, 5, 3);
            return false;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntityWorshipper(world, false);
                }
                case 1: {
                    return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_INNKEEPER);
                }
                case 2: {
                    return new EntitySettled(world, world.field_73012_v.nextBoolean() ? SupplierTribe.EnumVillager.SETTLED_VILLAGER : SupplierTribe.EnumVillager.SETTLED_FARMER);
                }
                case 3: {
                    EntityHorse entityHorse = new EntityHorse(world);
                    entityHorse.func_110235_q(3 + world.field_73012_v.nextInt(4));
                    return entityHorse;
                }
            }
            return null;
        }
    }
}

