/*
 * Decompiled with CFR 0.152.
 */
package diversity.structure;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class StructureTools {
    public abstract GlobalFeature getRandomComponent(Random var1, int var2, int var3);

    public static abstract class GlobalFeature
    extends ComponentScatteredFeaturePieces.DesertPyramid {
        private int avarageGroundLevel;

        public GlobalFeature() {
        }

        public GlobalFeature(Random random, int coordX, int coordZ, int sizeX, int sizeY, int sizeZ) {
            super(random, coordX, coordZ);
            this.field_74939_a = sizeX;
            this.field_74937_b = sizeY;
            this.field_74938_c = sizeZ;
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(coordX, 64, coordZ, coordX + sizeX - 1, 64 + sizeY - 1, coordZ + sizeZ - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(coordX, 64, coordZ, coordX + sizeZ - 1, 64 + sizeY - 1, coordZ + sizeX - 1);
                }
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.build(world, random, structureBoundingBox);
            return true;
        }

        protected abstract boolean build(World var1, Random var2, StructureBoundingBox var3);

        protected void spawnEntity(World world, StructureBoundingBox structureBoundingBox, int spawnX, int spawnY, int spawnZ, int choice) {
            int z;
            int y;
            int x = this.func_74865_a(spawnX, spawnZ);
            if (!structureBoundingBox.func_78890_b(x, y = this.func_74862_a(spawnY), z = this.func_74873_b(spawnX, spawnZ))) {
                return;
            }
            EntityLiving entity = this.getNewEntity(world, choice);
            entity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entity);
        }

        protected abstract EntityLiving getNewEntity(World var1, int var2);

        protected int getAverageGroundLevel(World p_74889_1_, StructureBoundingBox p_74889_2_) {
            int i = 0;
            int j = 0;
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    if (!p_74889_2_.func_78890_b(l, 64, k)) continue;
                    i += Math.max(p_74889_1_.func_72825_h(l, k), p_74889_1_.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected boolean generateStructureTrappedChestContents(World p_74879_1_, StructureBoundingBox p_74879_2_, Random p_74879_3_, int p_74879_4_, int p_74879_5_, int p_74879_6_, WeightedRandomChestContent[] p_74879_7_, int p_74879_8_) {
            int k1;
            int j1;
            int i1 = this.func_74865_a(p_74879_4_, p_74879_6_);
            if (p_74879_2_.func_78890_b(i1, j1 = this.func_74862_a(p_74879_5_), k1 = this.func_74873_b(p_74879_4_, p_74879_6_)) && p_74879_1_.func_147439_a(i1, j1, k1) != Blocks.field_150447_bR) {
                p_74879_1_.func_147465_d(i1, j1, k1, Blocks.field_150447_bR, 0, 2);
                TileEntityChest tileentitychest = (TileEntityChest)p_74879_1_.func_147438_o(i1, j1, k1);
                if (tileentitychest != null) {
                    WeightedRandomChestContent.func_76293_a((Random)p_74879_3_, (WeightedRandomChestContent[])p_74879_7_, (IInventory)tileentitychest, (int)p_74879_8_);
                }
                return true;
            }
            return false;
        }
    }
}

