/*
 * Decompiled with CFR 0.152.
 */
package diversity.suppliers;

import diversity.MapGenVillageDiversity;
import diversity.structure.StructureDesert;
import diversity.structure.StructureForest;
import diversity.structure.StructureJungle;
import diversity.structure.StructurePlain;
import diversity.structure.StructureSwamp;
import diversity.structure.StructureTools;
import diversity.suppliers.SupplierEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class SupplierStructure {
    private static Map<StructureTools, EnumStructure> mapStructureEnum = new HashMap<StructureTools, EnumStructure>();
    private static Map<BiomeGenBase, List<EnumStructure>> biomeEnumMap = new HashMap<BiomeGenBase, List<EnumStructure>>();

    public static void convert() {
        for (EnumStructure enumVillage : EnumSet.allOf(EnumStructure.class)) {
            for (BiomeGenBase biome : enumVillage.biomes) {
                if (!biomeEnumMap.containsKey(biome)) {
                    biomeEnumMap.put(biome, new ArrayList<EnumStructure>(Arrays.asList(enumVillage)));
                    continue;
                }
                if (biomeEnumMap.get(biome).contains((Object)enumVillage)) continue;
                biomeEnumMap.get(biome).add(enumVillage);
            }
        }
    }

    public static boolean canSpawnInBiome(BiomeGenBase biome) {
        return biomeEnumMap.get(biome) != null && !biomeEnumMap.get(biome).isEmpty();
    }

    public static EnumStructure getEnumFromStructure(StructureTools structureTools) {
        return mapStructureEnum.get(structureTools);
    }

    public static StructureTools getRandomStructure(BiomeGenBase biome, Random random) {
        List<EnumStructure> list = biomeEnumMap.get(biome);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get((int)random.nextInt((int)list.size())).instance;
    }

    public static enum EnumComponent {
        EGYPTIAN_PYRAMID(EnumStructure.DESERT, 25, StructureDesert.Pyramid.class),
        AZTEC_PYRAMID(EnumStructure.JUNGLE, 25, StructureJungle.Pyramid.class),
        CATACOMB(EnumStructure.FOREST, 25, StructureForest.Catacomb.class),
        SWAMPHUT(EnumStructure.SWAMP, 25, StructureSwamp.SwampHut.class),
        INN(EnumStructure.PLAIN, 25, StructurePlain.Inn.class);

        public final EnumStructure structure;
        public final int weight;
        public final Class pieceClass;

        private EnumComponent(EnumStructure structure, int weight, Class pieceClass) {
            this(structure, weight, pieceClass, null);
        }

        private EnumComponent(EnumStructure structure, int weight, Class pieceClass, SupplierEntity.EnumEntity monster) {
            structure.components.add(this);
            structure.totalWeight += weight;
            this.structure = structure;
            this.weight = weight;
            this.pieceClass = pieceClass;
        }
    }

    public static enum EnumStructure {
        DESERT(new StructureDesert()),
        JUNGLE(new StructureJungle()),
        FOREST(new StructureForest()),
        SWAMP(new StructureSwamp()),
        PLAIN(new StructurePlain());

        public StructureTools instance;
        public int totalWeight;
        public List<EnumComponent> components = new ArrayList<EnumComponent>();
        private List<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();

        private EnumStructure(StructureTools instance) {
            this.instance = instance;
            mapStructureEnum.put(instance, this);
        }

        public EnumStructure initialize(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            ArrayList<BiomeGenBase> newBiomes = new ArrayList<BiomeGenBase>();
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                newBiomes.add(biome);
            }
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumStructure intersection(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
            ArrayList<BiomeGenBase> newBiomes = new ArrayList<BiomeGenBase>();
            for (BiomeGenBase biome : biomeArray) {
                if (!this.biomes.contains(biome)) continue;
                newBiomes.add(biome);
            }
            this.biomes.clear();
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumStructure union(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (this.biomes.contains(biome)) continue;
                this.biomes.add(biome);
            }
            return this;
        }

        public EnumStructure exclusion(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (!this.biomes.contains(biome)) continue;
                this.biomes.remove(biome);
            }
            return this;
        }

        public EnumStructure all() {
            ArrayList<BiomeGenBase> newBiomes = new ArrayList<BiomeGenBase>();
            for (BiomeGenBase biome : MapGenVillageDiversity.field_75055_e) {
                newBiomes.add(biome);
            }
            this.biomes.clear();
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumStructure addBiome(BiomeGenBase biome) {
            if (!this.biomes.contains(biome)) {
                this.biomes.add(biome);
            }
            return this;
        }
    }
}

