/*
 * Decompiled with CFR 0.152.
 */
package diversity.suppliers;

import diversity.MapGenVillageDiversity;
import diversity.utils.HandlerTools;
import diversity.village.VillageApache;
import diversity.village.VillageAztec;
import diversity.village.VillageEgyptian;
import diversity.village.VillageInuit;
import diversity.village.VillageLakeside;
import diversity.village.VillageSettled;
import diversity.village.VillageTibetan;
import diversity.village.VillageTools;
import diversity.village.VillageZulu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class SupplierVillage {
    private static Map<Integer, List<EnumVillage>> biomeEnumMap = new HashMap<Integer, List<EnumVillage>>();

    public static void convert() {
        for (EnumVillage enumVillage : EnumSet.allOf(EnumVillage.class)) {
            for (Integer biomeId : enumVillage.biomes) {
                if (!biomeEnumMap.containsKey(biomeId)) {
                    biomeEnumMap.put(biomeId, new ArrayList<EnumVillage>(Arrays.asList(enumVillage)));
                    continue;
                }
                if (biomeEnumMap.get(biomeId).contains((Object)enumVillage)) continue;
                biomeEnumMap.get(biomeId).add(enumVillage);
            }
        }
    }

    public static boolean canSpawnInBiome(BiomeGenBase biome) {
        return biomeEnumMap.get(biome.field_76756_M) != null && !biomeEnumMap.get(biome.field_76756_M).isEmpty();
    }

    public static VillageTools getRandomVillage(BiomeGenBase biome, Random rand) {
        List<EnumVillage> list = biomeEnumMap.get(biome.field_76756_M);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get((int)rand.nextInt((int)list.size())).instance;
    }

    public static enum EnumBasic implements IEnumPiece
    {
        APACHE_START(EnumVillage.APACHE, VillageApache.Start.class),
        APACHE_PATH(EnumVillage.APACHE, VillageApache.Path.class),
        APACHE_TORCH(EnumVillage.APACHE, VillageApache.Torch.class),
        AZTEC_START(EnumVillage.AZTEC, VillageAztec.Start.class),
        AZTEC_PATH(EnumVillage.AZTEC, VillageAztec.Path.class),
        AZTEC_TORCH(EnumVillage.AZTEC, VillageAztec.Torch.class),
        ESKIMO_START(EnumVillage.INUIT, VillageInuit.Start.class),
        ESKIMO_PATH(EnumVillage.INUIT, VillageInuit.Path.class),
        ESKIMO_TORCH(EnumVillage.INUIT, VillageInuit.Torch.class),
        SETTLED_START(EnumVillage.SETTLED, VillageSettled.Start.class),
        SETTLED_PATH(EnumVillage.SETTLED, VillageSettled.Path.class),
        SETTLED_TORCH(EnumVillage.SETTLED, VillageSettled.Torch.class),
        ZOULOU_START(EnumVillage.ZULU, VillageZulu.Start.class),
        ZOULOU_PATH(EnumVillage.ZULU, VillageZulu.Path.class),
        ZOULOU_TORCH(EnumVillage.ZULU, VillageZulu.Torch.class),
        TIBETAN_START(EnumVillage.TIBETAN, VillageTibetan.Start.class),
        TIBETAN_PATH(EnumVillage.TIBETAN, VillageTibetan.Path.class),
        TIBETAN_TORCH(EnumVillage.TIBETAN, VillageTibetan.Torch.class),
        EGYPTIAN_START(EnumVillage.EGYPTIAN, VillageEgyptian.Start.class),
        EGYPTIAN_PATH(EnumVillage.EGYPTIAN, VillageEgyptian.Path.class),
        EGYPTIAN_TORCH(EnumVillage.EGYPTIAN, VillageEgyptian.Torch.class),
        LAKE_START(EnumVillage.LAKESIDE, VillageLakeside.Start.class),
        LAKE_PATH(EnumVillage.LAKESIDE, VillageLakeside.Path.class),
        LAKE_TORCH(EnumVillage.LAKESIDE, VillageLakeside.Torch.class);

        public EnumVillage village;
        public Class pieceClass;

        private EnumBasic(EnumVillage village, Class pieceClass) {
            village.defaultPieces.add(this);
            this.village = village;
            this.pieceClass = pieceClass;
        }

        @Override
        public EnumVillage getVillage() {
            return this.village;
        }
    }

    public static enum EnumPiece implements IEnumPiece
    {
        APACHE_HOUSE1(EnumVillage.APACHE, 10, 3, VillageApache.House1.class),
        APACHE_HOUSE2(EnumVillage.APACHE, 10, 3, VillageApache.House2.class),
        APACHE_CHIEFTENT(EnumVillage.APACHE, 6, 1, VillageApache.ChiefTent.class),
        APACHE_LIVESTOCK(EnumVillage.APACHE, 6, 1, VillageApache.Livestock.class),
        APACHE_SHAMANTENT(EnumVillage.APACHE, 6, 1, VillageApache.ShamanTent.class),
        AZTEC_HOUSE1(EnumVillage.AZTEC, 15, 3, VillageAztec.House1.class),
        AZTEC_HOUSE2(EnumVillage.AZTEC, 15, 3, VillageAztec.House2.class),
        AZTEC_TEMPLE(EnumVillage.AZTEC, 10, 1, VillageAztec.Temple.class),
        AZTEC_PALACE(EnumVillage.AZTEC, 10, 1, VillageAztec.Palace.class),
        AZTEC_LIVESTOCK(EnumVillage.AZTEC, 5, 2, VillageAztec.Livestock.class),
        AZTEC_FIELD(EnumVillage.AZTEC, 5, 2, VillageAztec.Field.class),
        INUIT_IGLOO1(EnumVillage.INUIT, 25, 3, VillageInuit.Igloo1.class),
        INUIT_IGLOO2(EnumVillage.INUIT, 15, 3, VillageInuit.Igloo2.class),
        INUIT_CHIEFIGLOO(EnumVillage.INUIT, 6, 1, VillageInuit.ChiefIgloo.class),
        INUIT_KENNEL(EnumVillage.INUIT, 10, 1, VillageInuit.Kennel.class),
        SETTLED_CHURCH(EnumVillage.SETTLED, 51, 1, VillageSettled.Church.class),
        SETTLED_FIELD1(EnumVillage.SETTLED, 3, 2, VillageSettled.Field1.class),
        SETTLED_FIELD2(EnumVillage.SETTLED, 3, 2, VillageSettled.Field2.class),
        SETTLED_BUTCHERY(EnumVillage.SETTLED, 15, 2, VillageSettled.Butchery.class),
        SETTLED_LIBRARY(EnumVillage.SETTLED, 20, 1, VillageSettled.Library.class),
        SETTLED_FORGE(EnumVillage.SETTLED, 15, 1, VillageSettled.Forge.class),
        SETTLED_HOUSE3(EnumVillage.SETTLED, 8, 4, VillageSettled.House3.class),
        SETTLED_HOUSE4GARDEN(EnumVillage.SETTLED, 4, 3, VillageSettled.House4Garden.class),
        ZULU_HOUSE1(EnumVillage.ZULU, 15, 3, VillageZulu.House1.class),
        ZULU_HOUSE2(EnumVillage.ZULU, 15, 3, VillageZulu.House2.class),
        ZULU_HOUSE3(EnumVillage.ZULU, 10, 1, VillageZulu.House3.class),
        ZULU_HOUSE4(EnumVillage.ZULU, 10, 1, VillageZulu.House4.class),
        ZULU_LIVESTOCK(EnumVillage.ZULU, 12, 2, VillageZulu.Livestock.class),
        TIBETAN_MAINHOUSE(EnumVillage.TIBETAN, 15, 1, VillageTibetan.MainHouse.class),
        TIBETAN_HOUSE1(EnumVillage.TIBETAN, 25, 3, VillageTibetan.House1.class),
        TIBETAN_HOUSE2(EnumVillage.TIBETAN, 20, 2, VillageTibetan.House2.class),
        TIBETAN_FIELD(EnumVillage.TIBETAN, 10, 2, VillageTibetan.Field.class),
        EGYPTIAN_HOUSE1(EnumVillage.EGYPTIAN, 12, 3, VillageEgyptian.House1.class),
        EGYPTIAN_HOUSE2(EnumVillage.EGYPTIAN, 17, 2, VillageEgyptian.House2.class),
        EGYPTIAN_HOUSE3(EnumVillage.EGYPTIAN, 12, 2, VillageEgyptian.House3.class),
        EGYPTIAN_TOWER(EnumVillage.EGYPTIAN, 20, 4, VillageEgyptian.Tower.class),
        EGYPTIAN_FIELD(EnumVillage.EGYPTIAN, 4, 2, VillageEgyptian.Field.class),
        EGYPTIAN_TEMPLE(EnumVillage.EGYPTIAN, 18, 1, VillageEgyptian.Temple.class),
        EGYPTIAN_PALACE(EnumVillage.EGYPTIAN, 51, 1, VillageEgyptian.Palace.class),
        EGYPTIAN_FIELD2(EnumVillage.EGYPTIAN, 4, 2, VillageEgyptian.Field2.class),
        LAKESIDE_HOUSE1(EnumVillage.LAKESIDE, 20, 4, VillageLakeside.House1.class),
        LAKESIDE_HOUSE2(EnumVillage.LAKESIDE, 20, 1, VillageLakeside.House2.class),
        LAKESIDE_TOWER(EnumVillage.LAKESIDE, 6, 2, VillageLakeside.Tower.class),
        LAKESIDE_BREEDING(EnumVillage.LAKESIDE, 4, 1, VillageLakeside.Breeding.class),
        LAKESIDE_FIELD(EnumVillage.LAKESIDE, 3, 2, VillageLakeside.Field.class);

        public final HandlerTools.VillageCreationHandler handler;
        public final EnumVillage village;

        private EnumPiece(EnumVillage village, int weight, int limit, Class pieceClass) {
            village.pieces.add(this);
            this.village = village;
            this.handler = new HandlerTools.VillageCreationHandler(pieceClass, weight, limit);
        }

        @Override
        public EnumVillage getVillage() {
            return this.village;
        }
    }

    public static interface IEnumPiece {
        public EnumVillage getVillage();
    }

    public static enum EnumVillage {
        APACHE(VillageApache.class),
        AZTEC(VillageAztec.class),
        INUIT(VillageInuit.class),
        SETTLED(VillageSettled.class),
        ZULU(VillageZulu.class),
        TIBETAN(VillageTibetan.class),
        EGYPTIAN(VillageEgyptian.class),
        LAKESIDE(VillageLakeside.class);

        public VillageTools instance;
        private final List<Integer> biomes = new ArrayList<Integer>();
        public final List<EnumPiece> pieces = new ArrayList<EnumPiece>();
        public final List<EnumBasic> defaultPieces = new ArrayList<EnumBasic>();

        private EnumVillage(Class villageClass) {
            if (villageClass.getSuperclass() == VillageTools.class) {
                try {
                    this.instance = (VillageTools)villageClass.getConstructors()[0].newInstance(new Object[]{this});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public EnumVillage initialize(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            ArrayList<Integer> newBiomes = new ArrayList<Integer>();
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                newBiomes.add(biome.field_76756_M);
            }
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumVillage intersection(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
            ArrayList<Integer> newBiomes = new ArrayList<Integer>();
            for (BiomeGenBase biome : biomeArray) {
                if (!this.biomes.contains(biome.field_76756_M)) continue;
                newBiomes.add(biome.field_76756_M);
            }
            this.biomes.clear();
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumVillage union(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (this.biomes.contains(biome.field_76756_M)) continue;
                this.biomes.add(biome.field_76756_M);
            }
            return this;
        }

        public EnumVillage exclusion(BiomeDictionary.Type type) {
            BiomeGenBase[] biomeArray;
            for (BiomeGenBase biome : biomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (!this.biomes.contains(biome.field_76756_M)) continue;
                this.biomes.remove((Object)biome.field_76756_M);
            }
            return this;
        }

        public EnumVillage all() {
            ArrayList<Integer> newBiomes = new ArrayList<Integer>();
            for (BiomeGenBase biome : MapGenVillageDiversity.field_75055_e) {
                newBiomes.add(biome.field_76756_M);
            }
            this.biomes.clear();
            this.biomes.addAll(newBiomes);
            return this;
        }

        public EnumVillage addBiome(BiomeGenBase biome) {
            if (!this.biomes.contains(biome.field_76756_M)) {
                this.biomes.add(biome.field_76756_M);
            }
            return this;
        }
    }
}

