/*
 * Decompiled with CFR 0.152.
 */
package diversity.utils;

import diversity.structure.StructureForest;
import diversity.structure.StructurePlain;
import diversity.structure.StructureSwamp;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ChestGenTools
extends ChestGenHooks {
    public static final String SWAMPHUT_CHEST = "swampHutChest";
    public static final String CATACOMB_CHEST = "catacombChest";
    public static final String INN_CHEST = "underInnChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenTools.addInfo(SWAMPHUT_CHEST, StructureSwamp.SwampHut.itemsToGenerateInHut, 3, 7);
        ChestGenTools.addInfo(CATACOMB_CHEST, StructureForest.Catacomb.itemsToGenerateCatacomb, 4, 8);
        ChestGenTools.addInfo(INN_CHEST, StructurePlain.Inn.itemsToGenerateInn, 2, 5);
    }

    public ChestGenTools(String category, WeightedRandomChestContent[] items, int min, int max) {
        super(category, items, min, max);
    }

    private static void addInfo(String category, WeightedRandomChestContent[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static WeightedRandomChestContent[] getItems(String category, Random rnd) {
        return ChestGenTools.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenTools.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, WeightedRandomChestContent item) {
        ChestGenTools.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ItemStack item) {
        ChestGenTools.getInfo(category).removeItem(item);
    }

    public static ItemStack getOneItem(String category, Random rand) {
        return ChestGenTools.getInfo(category).getOneItem(rand);
    }

    static {
        ChestGenTools.init();
    }
}

