/*
 * Decompiled with CFR 0.152.
 */
package diversity.utils;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public enum Configurations {
    maxDistanceBetweenStructures(32),
    minDistanceBetweenStructures(8),
    maxDistanceBetweenVillages(32),
    minDistanceBetweenVillages(8),
    chanceVillagerBecomesChief(5000);

    private String config;
    private static final String configFile;

    private Configurations(int config) {
        this.config = String.valueOf(config);
    }

    private Configurations(String config) {
        this.config = config;
    }

    public int getIntegerConfig() {
        return Integer.valueOf(this.config);
    }

    public String getStringConfig() {
        return this.config;
    }

    public static void saveConfig() {
        Properties properties = new Properties();
        properties.setProperty(maxDistanceBetweenVillages.name(), Configurations.maxDistanceBetweenVillages.config);
        properties.setProperty(minDistanceBetweenVillages.name(), Configurations.minDistanceBetweenVillages.config);
        properties.setProperty(maxDistanceBetweenStructures.name(), Configurations.maxDistanceBetweenStructures.config);
        properties.setProperty(minDistanceBetweenStructures.name(), Configurations.minDistanceBetweenStructures.config);
        properties.setProperty(chanceVillagerBecomesChief.name(), Configurations.chanceVillagerBecomesChief.config);
        try {
            File file = new File(configFile);
            properties.store(new FileOutputStream(file), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String config = properties.getProperty(maxDistanceBetweenVillages.name());
        if (config != null && !config.isEmpty()) {
            Configurations.maxDistanceBetweenVillages.config = config;
        }
        if ((config = properties.getProperty(minDistanceBetweenVillages.name())) != null && !config.isEmpty()) {
            Configurations.minDistanceBetweenVillages.config = config;
        }
        if ((config = properties.getProperty(maxDistanceBetweenStructures.name())) != null && !config.isEmpty()) {
            Configurations.maxDistanceBetweenStructures.config = config;
        }
        if ((config = properties.getProperty(minDistanceBetweenStructures.name())) != null && !config.isEmpty()) {
            Configurations.minDistanceBetweenStructures.config = config;
        }
        if ((config = properties.getProperty(chanceVillagerBecomesChief.name())) != null && !config.isEmpty()) {
            Configurations.chanceVillagerBecomesChief.config = config;
        }
    }

    static {
        configFile = Loader.instance().getConfigDir() + "/diversity.cfg";
    }
}

