/*
 * Decompiled with CFR 0.152.
 */
package diversity.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class Economy {
    private static final String configFile = Loader.instance().getConfigDir() + "/diversity-economy.cfg";

    public static void savePrice() {
        Properties properties = new Properties();
        for (Table.Cell cell : IPrice.priceMap.cellSet()) {
            properties.setProperty(((IPrice)cell.getValue()).name(), String.valueOf(((IPrice)cell.getValue()).getPrice()));
        }
        try {
            File file = new File(configFile);
            properties.store(new FileOutputStream(file), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadPrice() {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (Table.Cell cell : IPrice.priceMap.cellSet()) {
            String price = properties.getProperty(((IPrice)cell.getValue()).name());
            if (price == null || price.isEmpty()) continue;
            ((IPrice)cell.getValue()).setPrice(Float.valueOf(price).floatValue());
            properties.remove(((IPrice)cell.getValue()).name());
        }
    }

    public static float getPrice(Item item, int metaData) {
        return Float.valueOf(((IPrice)IPrice.priceMap.get((Object)item, (Object)metaData)).getPrice()).floatValue();
    }

    public static float getPrice(Item item) {
        return Economy.getPrice(item, 0);
    }

    public static Item getItem(IPrice itemPrice) {
        for (Table.Cell cell : IPrice.priceMap.cellSet()) {
            if (!((IPrice)cell.getValue()).name().equals(itemPrice.name())) continue;
            return (Item)cell.getRowKey();
        }
        return null;
    }

    public static int getMetadata(IPrice itemPrice) {
        for (Table.Cell cell : IPrice.priceMap.cellSet()) {
            if (!((IPrice)cell.getValue()).name().equals(itemPrice.name())) continue;
            return (Integer)cell.getColumnKey();
        }
        return 0;
    }

    public static enum EPrice implements IPrice,
    IItem
    {
        stone(Blocks.field_150348_b, 0, 3.0f),
        grass_block((Block)Blocks.field_150349_c, 0, 3.0f),
        dirt(Blocks.field_150346_d, 0, 1.0f),
        coarse_dirt(Blocks.field_150346_d, 1, 4.0f),
        potzol(Blocks.field_150346_d, 2, 4.0f),
        cobblestone(Blocks.field_150347_e, 0, 1.0f),
        oak_planks(Blocks.field_150344_f, 0, 1.0f),
        spruce_planks(Blocks.field_150344_f, 1, 1.0f),
        birch_planks(Blocks.field_150344_f, 2, 1.0f),
        jungle_planks(Blocks.field_150344_f, 3, 1.0f),
        acacia_planks(Blocks.field_150344_f, 4, 1.0f),
        dark_oak_planks(Blocks.field_150344_f, 5, 1.0f),
        oak_sapling(Blocks.field_150345_g, 0, 3.0f),
        spruce_sapling(Blocks.field_150345_g, 1, 3.0f),
        birch_sapling(Blocks.field_150345_g, 2, 3.0f),
        jungle_sapling(Blocks.field_150345_g, 3, 3.0f),
        acacia_sapling(Blocks.field_150345_g, 4, 3.0f),
        dark_oak_sapling(Blocks.field_150345_g, 5, 3.0f),
        sand(Blocks.field_150354_m, 0, 1.0f),
        red_sand(Blocks.field_150354_m, 1, 3.0f),
        gravel(Blocks.field_150351_n, 0, 3.0f),
        oak_wood(Blocks.field_150364_r, 0, 2.0f),
        spruce_wood(Blocks.field_150364_r, 1, 2.0f),
        birch_wood(Blocks.field_150364_r, 2, 2.0f),
        jungle_wood(Blocks.field_150364_r, 3, 2.0f),
        oak_leaves((Block)Blocks.field_150362_t, 0, 3.0f),
        spruce_leaves((Block)Blocks.field_150362_t, 1, 3.0f),
        birch_leaves((Block)Blocks.field_150362_t, 2, 3.0f),
        jungle_leaves((Block)Blocks.field_150362_t, 3, 3.0f),
        sponge(Blocks.field_150360_v, 0, 60.0f),
        glass(Blocks.field_150359_w, 0, 3.0f),
        lapis_lazuli_block(Blocks.field_150368_y, 0, 24.0f),
        dispenser(Blocks.field_150367_z, 0, 12.0f),
        sandstone(Blocks.field_150322_A, 0, 4.0f),
        chiseled_sandstone(Blocks.field_150322_A, 1, 30.0f),
        smooth_sandstone(Blocks.field_150322_A, 2, 4.0f),
        note_block(Blocks.field_150323_B, 0, 8.0f),
        powered_rail(Blocks.field_150318_D, 0, 50.0f),
        detector_rail(Blocks.field_150319_E, 0, 28.0f),
        sticky_piston((Block)Blocks.field_150320_F, 0, 14.0f),
        cobweb(Blocks.field_150321_G, 0, 20.0f),
        dead_shrub((Block)Blocks.field_150329_H, 0, 4.0f),
        grass((Block)Blocks.field_150329_H, 1, 4.0f),
        fern((Block)Blocks.field_150329_H, 2, 4.0f),
        piston((Block)Blocks.field_150331_J, 0, 12.0f),
        white_wool(Blocks.field_150325_L, 0, 6.0f),
        orange_wool(Blocks.field_150325_L, 1, 8.0f),
        magenta_wool(Blocks.field_150325_L, 2, 8.0f),
        light_blue_wool(Blocks.field_150325_L, 3, 8.0f),
        yellow_wool(Blocks.field_150325_L, 4, 8.0f),
        lime_wool(Blocks.field_150325_L, 5, 8.0f),
        pink_wool(Blocks.field_150325_L, 6, 8.0f),
        gray_wool(Blocks.field_150325_L, 7, 7.0f),
        light_gray_wool(Blocks.field_150325_L, 8, 7.0f),
        cyan_wool(Blocks.field_150325_L, 9, 8.0f),
        purple_wool(Blocks.field_150325_L, 10, 8.0f),
        blue_wool(Blocks.field_150325_L, 11, 8.0f),
        brown_wool(Blocks.field_150325_L, 12, 8.0f),
        green_wool(Blocks.field_150325_L, 13, 8.0f),
        red_wool(Blocks.field_150325_L, 14, 8.0f),
        black_wool(Blocks.field_150325_L, 15, 7.0f),
        dandelion((Block)Blocks.field_150327_N, 0, 4.0f),
        poppy((Block)Blocks.field_150328_O, 0, 4.0f),
        blue_orchid((Block)Blocks.field_150328_O, 1, 4.0f),
        allium((Block)Blocks.field_150328_O, 2, 4.0f),
        azure_bluet((Block)Blocks.field_150328_O, 3, 4.0f),
        red_tulip((Block)Blocks.field_150328_O, 4, 4.0f),
        orange_tulip((Block)Blocks.field_150328_O, 5, 4.0f),
        white_tulip((Block)Blocks.field_150328_O, 6, 4.0f),
        pink_tulip((Block)Blocks.field_150328_O, 7, 4.0f),
        oxeye_daisy((Block)Blocks.field_150328_O, 8, 4.0f),
        brown_mushroom((Block)Blocks.field_150338_P, 0, 4.0f),
        red_mushroom((Block)Blocks.field_150337_Q, 0, 4.0f),
        bricks(Blocks.field_150336_V, 0, 18.0f),
        tnt(Blocks.field_150335_W, 0, 24.0f),
        bookshelf(Blocks.field_150342_X, 0, 38.0f),
        mossy_cobblestone(Blocks.field_150341_Y, 0, 12.0f),
        obsidian(Blocks.field_150343_Z, 0, 20.0f),
        torch(Blocks.field_150478_aa, 0, 1.0f),
        chest((Block)Blocks.field_150486_ae, 0, 8.0f),
        ladder(Blocks.field_150468_ap, 0, 1.0f),
        rail(Blocks.field_150448_aq, 0, 2.0f),
        lever(Blocks.field_150442_at, 0, 2.0f),
        snow(Blocks.field_150433_aE, 0, 4.0f),
        ice(Blocks.field_150432_aD, 0, 8.0f),
        cactus(Blocks.field_150434_aF, 0, 6.0f),
        jukebox(Blocks.field_150421_aI, 0, 60.0f),
        pumpkin(Blocks.field_150423_aK, 0, 10.0f),
        netherrack(Blocks.field_150424_aL, 0, 3.0f),
        soul_sand(Blocks.field_150425_aM, 0, 10.0f),
        glowstone(Blocks.field_150426_aN, 0, 30.0f),
        jack_o_lantern(Blocks.field_150428_aP, 0, 12.0f),
        white_glass((Block)Blocks.field_150399_cn, 0, 5.0f),
        orange_glass((Block)Blocks.field_150399_cn, 1, 7.0f),
        magenta_glass((Block)Blocks.field_150399_cn, 2, 7.0f),
        light_blue_glass((Block)Blocks.field_150399_cn, 3, 7.0f),
        yellow_glass((Block)Blocks.field_150399_cn, 4, 6.0f),
        lime_glass((Block)Blocks.field_150399_cn, 5, 7.0f),
        pink_glass((Block)Blocks.field_150399_cn, 6, 7.0f),
        gray_glass((Block)Blocks.field_150399_cn, 7, 7.0f),
        light_gray_glass((Block)Blocks.field_150399_cn, 8, 7.0f),
        cyan_glass((Block)Blocks.field_150399_cn, 9, 7.0f),
        purple_glass((Block)Blocks.field_150399_cn, 10, 7.0f),
        blue_glass((Block)Blocks.field_150399_cn, 11, 7.0f),
        brown_glass((Block)Blocks.field_150399_cn, 12, 7.0f),
        green_glass((Block)Blocks.field_150399_cn, 13, 7.0f),
        red_glass((Block)Blocks.field_150399_cn, 14, 6.0f),
        black_glass((Block)Blocks.field_150399_cn, 15, 5.0f),
        stonebrick(Blocks.field_150417_aV, 0, 3.0f),
        mossy_stonebrick(Blocks.field_150417_aV, 1, 8.0f),
        cracked_stonebrick(Blocks.field_150417_aV, 2, 8.0f),
        chiseled_stonebrick(Blocks.field_150417_aV, 3, 8.0f),
        melon_block(Blocks.field_150440_ba, 0, 10.0f),
        vines(Blocks.field_150395_bd, 0, 8.0f),
        mycelium((Block)Blocks.field_150391_bh, 0, 24.0f),
        lily_pad(Blocks.field_150392_bi, 0, 10.0f),
        nether_brick_block(Blocks.field_150385_bj, 0, 20.0f),
        cocoa(Blocks.field_150375_by, 0, 14.0f),
        quartz_block(Blocks.field_150371_ca, 0, 32.0f),
        white_clay(Blocks.field_150406_ce, 0, 6.0f),
        orange_clay(Blocks.field_150406_ce, 1, 6.0f),
        magenta_clay(Blocks.field_150406_ce, 2, 6.0f),
        light_blue_clay(Blocks.field_150406_ce, 3, 6.0f),
        yellow_clay(Blocks.field_150406_ce, 4, 6.0f),
        lime_clay(Blocks.field_150406_ce, 5, 6.0f),
        pink_clay(Blocks.field_150406_ce, 6, 6.0f),
        gray_clau(Blocks.field_150406_ce, 7, 6.0f),
        light_gray_clay(Blocks.field_150406_ce, 8, 6.0f),
        cyan_clay(Blocks.field_150406_ce, 9, 6.0f),
        purple_clay(Blocks.field_150406_ce, 10, 6.0f),
        blue_clay(Blocks.field_150406_ce, 11, 6.0f),
        brown_clay(Blocks.field_150406_ce, 12, 6.0f),
        green_clay(Blocks.field_150406_ce, 13, 6.0f),
        red_clay(Blocks.field_150406_ce, 14, 6.0f),
        black_clay(Blocks.field_150406_ce, 15, 6.0f),
        accacia_leaves((Block)Blocks.field_150361_u, 0, 3.0f),
        dark_oak_leaves((Block)Blocks.field_150361_u, 1, 3.0f),
        accacia_wood(Blocks.field_150363_s, 0, 2.0f),
        dark_oak_wood(Blocks.field_150363_s, 0, 2.0f),
        hay_bale(Blocks.field_150407_cf, 0, 16.0f),
        hardened_clay(Blocks.field_150405_ch, 0, 5.0f),
        packed_ice(Blocks.field_150403_cj, 0, 24.0f),
        sunflower((Block)Blocks.field_150398_cm, 0, 6.0f),
        lilac((Block)Blocks.field_150398_cm, 1, 6.0f),
        double_tallgrass((Block)Blocks.field_150398_cm, 2, 6.0f),
        large_fern((Block)Blocks.field_150398_cm, 3, 6.0f),
        rose_bush((Block)Blocks.field_150398_cm, 4, 6.0f),
        peony((Block)Blocks.field_150398_cm, 5, 6.0f),
        iron_shovel(Items.field_151037_a, 0, 5.0f),
        iron_pickaxe(Items.field_151035_b, 0, 10.0f),
        iron_axe(Items.field_151036_c, 0, 10.0f),
        flint_and_steel(Items.field_151033_d, 0, 8.0f),
        apple(Items.field_151034_e, 0, 6.0f),
        bow((Item)Items.field_151031_f, 0, 6.0f),
        arrow(Items.field_151032_g, 0, 1.0f),
        coal(Items.field_151044_h, 0, 3.0f),
        charcoal(Items.field_151044_h, 1, 3.0f),
        diamond(Items.field_151045_i, 0, 60.0f),
        iron_ingot(Items.field_151042_j, 0, 4.0f),
        gold_ingot(Items.field_151043_k, 0, 8.0f),
        iron_sword(Items.field_151040_l, 0, 9.0f),
        wooden_sword(Items.field_151041_m, 0, 1.0f),
        wooden_shovel(Items.field_151038_n, 0, 1.0f),
        wooden_pickaxe(Items.field_151039_o, 0, 2.0f),
        wooden_axe(Items.field_151053_p, 0, 2.0f),
        stone_sword(Items.field_151052_q, 0, 3.0f),
        stone_shovel(Items.field_151051_r, 0, 2.0f),
        stone_pickaxe(Items.field_151050_s, 0, 4.0f),
        stone_axe(Items.field_151049_t, 0, 4.0f),
        diamond_sword(Items.field_151048_u, 0, 120.0f),
        diamond_shovel(Items.field_151047_v, 0, 60.0f),
        diamond_pickaxe(Items.field_151046_w, 0, 180.0f),
        diamond_axe(Items.field_151056_x, 0, 180.0f),
        stick(Items.field_151055_y, 0, 0.1f),
        bowl(Items.field_151054_z, 0, 4.0f),
        mushroom_stew(Items.field_151009_A, 0, 12.0f),
        golden_sword(Items.field_151010_B, 0, 16.0f),
        golden_shovel(Items.field_151011_C, 0, 8.0f),
        golden_pickaxe(Items.field_151005_D, 0, 24.0f),
        golden_axe(Items.field_151006_E, 0, 24.0f),
        string(Items.field_151007_F, 0, 0.9f),
        feather(Items.field_151008_G, 0, 1.0f),
        gunpowder(Items.field_151016_H, 0, 4.0f),
        wooden_hoe(Items.field_151017_I, 0, 1.0f),
        stone_hoe(Items.field_151018_J, 0, 3.0f),
        iron_hoe(Items.field_151019_K, 0, 9.0f),
        diamond_hoe(Items.field_151012_L, 0, 120.0f),
        golden_hoe(Items.field_151013_M, 0, 16.0f),
        wheat_seeds(Items.field_151014_N, 0, 0.5f),
        wheat(Items.field_151015_O, 0, 2.0f),
        bread(Items.field_151025_P, 0, 6.0f),
        leather_helmet((Item)Items.field_151024_Q, 0, 15.0f),
        leather_tunic((Item)Items.field_151027_R, 0, 24.0f),
        leather_pants((Item)Items.field_151026_S, 0, 21.0f),
        leather_boots((Item)Items.field_151021_T, 0, 12.0f),
        chainmail_helmet((Item)Items.field_151020_U, 0, 30.0f),
        chainmail_chestplate((Item)Items.field_151023_V, 0, 48.0f),
        chainmail_leggings((Item)Items.field_151022_W, 0, 42.0f),
        chainmail_boots((Item)Items.field_151029_X, 0, 24.0f),
        iron_helmet((Item)Items.field_151028_Y, 0, 20.0f),
        iron_chestplate((Item)Items.field_151030_Z, 0, 32.0f),
        iron_leggings((Item)Items.field_151165_aa, 0, 28.0f),
        iron_boots((Item)Items.field_151167_ab, 0, 16.0f),
        diamond_helmet((Item)Items.field_151161_ac, 0, 300.0f),
        diamond_chestplate((Item)Items.field_151163_ad, 0, 480.0f),
        diamond_leggings((Item)Items.field_151173_ae, 0, 420.0f),
        diamond_boots((Item)Items.field_151175_af, 0, 240.0f),
        golden_helmet((Item)Items.field_151169_ag, 0, 40.0f),
        golden_chesplate((Item)Items.field_151171_ah, 0, 64.0f),
        golden_leggings((Item)Items.field_151149_ai, 0, 56.0f),
        golden_boots((Item)Items.field_151151_aj, 0, 32.0f),
        flint(Items.field_151145_ak, 0, 4.0f),
        raw_porkchop(Items.field_151147_al, 0, 3.0f),
        cooked_porkchop(Items.field_151157_am, 0, 5.0f),
        painting(Items.field_151159_an, 0, 8.0f),
        golden_apple(Items.field_151153_ao, 0, 70.0f),
        enchanted_golden_apple(Items.field_151153_ao, 1, 582.0f),
        sign(Items.field_151155_ap, 0, 2.0f),
        bucket(Items.field_151133_ar, 0, 12.0f),
        minecart(Items.field_151143_au, 0, 20.0f),
        saddle(Items.field_151141_av, 0, 32.0f),
        redstone(Items.field_151137_ax, 0, 4.0f),
        snowball(Items.field_151126_ay, 0, 0.1f),
        boat(Items.field_151124_az, 0, 10.0f),
        leather(Items.field_151116_aA, 0, 3.0f),
        brick(Items.field_151118_aC, 0, 4.5f),
        clay(Items.field_151119_aD, 0, 3.0f),
        sugar_canes(Items.field_151120_aE, 0, 3.0f),
        paper(Items.field_151121_aF, 0, 3.0f),
        book(Items.field_151122_aG, 0, 12.0f),
        slimeball(Items.field_151123_aH, 0, 5.0f),
        egg(Items.field_151110_aK, 0, 3.0f),
        compass(Items.field_151111_aL, 0, 20.0f),
        fishing_rod((Item)Items.field_151112_aM, 0, 1.0f),
        clock(Items.field_151113_aN, 0, 36.0f),
        glowstone_dust(Items.field_151114_aO, 0, 7.5f),
        raw_fish(Items.field_151115_aP, 0, 5.0f),
        raw_salmon(Items.field_151115_aP, 1, 5.0f),
        clownfish(Items.field_151115_aP, 2, 5.0f),
        pufferfish(Items.field_151115_aP, 3, 5.0f),
        cooked_fish(Items.field_151101_aQ, 0, 7.0f),
        cooked_salmon(Items.field_151101_aQ, 1, 7.0f),
        ink(Items.field_151100_aR, 0, 3.0f),
        rose_red(Items.field_151100_aR, 1, 4.0f),
        cactus_green(Items.field_151100_aR, 2, 4.0f),
        coco_beans(Items.field_151100_aR, 3, 4.0f),
        lapis_lazuli(Items.field_151100_aR, 4, 4.0f),
        purple_dye(Items.field_151100_aR, 5, 4.0f),
        cyan_dye(Items.field_151100_aR, 6, 4.0f),
        light_gray_dye(Items.field_151100_aR, 7, 4.0f),
        gray_dye(Items.field_151100_aR, 8, 4.0f),
        pink_dye(Items.field_151100_aR, 9, 4.0f),
        lime_dye(Items.field_151100_aR, 10, 4.0f),
        dandelion_yellow(Items.field_151100_aR, 11, 4.0f),
        light_blue_dye(Items.field_151100_aR, 12, 4.0f),
        magenta_dye(Items.field_151100_aR, 13, 4.0f),
        orange_dye(Items.field_151100_aR, 14, 4.0f),
        bone_meal(Items.field_151100_aR, 15, 1.0f),
        bone(Items.field_151103_aS, 0, 3.0f),
        sugar(Items.field_151102_aT, 0, 3.0f),
        cake(Items.field_151105_aU, 0, 15.0f),
        cookie(Items.field_151106_aX, 0, 1.0f),
        map((Item)Items.field_151098_aY, 0, 60.0f),
        shears((Item)Items.field_151097_aZ, 0, 8.0f),
        melon(Items.field_151127_ba, 0, 1.5f),
        pumpkin_seeds(Items.field_151080_bb, 0, 2.0f),
        melon_seeds(Items.field_151081_bc, 0, 2.0f),
        raw_beef(Items.field_151082_bd, 0, 4.0f),
        steak(Items.field_151083_be, 0, 6.0f),
        raw_chicken(Items.field_151076_bf, 0, 4.0f),
        cooked_chicken(Items.field_151077_bg, 0, 6.0f),
        rotten_flesh(Items.field_151078_bh, 0, 0.5f),
        ender_pearl(Items.field_151079_bi, 0, 80.0f),
        blaze_rod(Items.field_151072_bj, 0, 30.0f),
        ghast_tear(Items.field_151073_bk, 0, 80.0f),
        nether_wart(Items.field_151075_bm, 0, 32.0f),
        potion_speed((Item)Items.field_151068_bn, 1, 30.0f),
        potion_slowness((Item)Items.field_151068_bn, 2, 30.0f),
        potion_haste((Item)Items.field_151068_bn, 3, 30.0f),
        potion_mining_fatigue((Item)Items.field_151068_bn, 4, 30.0f),
        potion_strength((Item)Items.field_151068_bn, 5, 30.0f),
        potion_instant_health((Item)Items.field_151068_bn, 6, 30.0f),
        potion_instant_damage((Item)Items.field_151068_bn, 7, 30.0f),
        potion_jump_boost((Item)Items.field_151068_bn, 8, 30.0f),
        potion_nausea((Item)Items.field_151068_bn, 9, 30.0f),
        potion_renegeration((Item)Items.field_151068_bn, 10, 30.0f),
        potion_resistance((Item)Items.field_151068_bn, 11, 30.0f),
        potion_fire_resistance((Item)Items.field_151068_bn, 12, 30.0f),
        potion_water_breathing((Item)Items.field_151068_bn, 13, 30.0f),
        potion_invisibility((Item)Items.field_151068_bn, 14, 30.0f),
        potion_blindness((Item)Items.field_151068_bn, 15, 30.0f),
        potion_night_vision((Item)Items.field_151068_bn, 16, 30.0f),
        potion_hunger((Item)Items.field_151068_bn, 17, 30.0f),
        potion_weakness((Item)Items.field_151068_bn, 18, 30.0f),
        potion_poison((Item)Items.field_151068_bn, 19, 30.0f),
        potion_wither((Item)Items.field_151068_bn, 20, 30.0f),
        potion_health_boost((Item)Items.field_151068_bn, 21, 30.0f),
        potion_absorption((Item)Items.field_151068_bn, 22, 30.0f),
        potion_saturation((Item)Items.field_151068_bn, 23, 30.0f),
        glass_bottle(Items.field_151069_bo, 0, 9.0f),
        spider_eye(Items.field_151070_bp, 0, 3.0f),
        fermented_spider_eye(Items.field_151071_bq, 0, 11.0f),
        blaze_powder(Items.field_151065_br, 0, 30.0f),
        magma_cream(Items.field_151064_bs, 0, 20.0f),
        glistering_melon(Items.field_151060_bw, 0, 11.0f),
        bottle_o_enchanting(Items.field_151062_by, 0, 20.0f),
        fire_charge(Items.field_151059_bz, 0, 13.0f),
        book_and_quill(Items.field_151099_bA, 0, 15.0f),
        written_book(Items.field_151164_bB, 0, 25.0f),
        emerald(Items.field_151166_bC, 0, 72.0f),
        item_frame(Items.field_151160_bD, 0, 5.0f),
        flower_pot(Items.field_151162_bE, 0, 13.0f),
        carrot(Items.field_151172_bF, 0, 3.0f),
        potato(Items.field_151174_bG, 0, 3.0f),
        baked_potato(Items.field_151168_bH, 0, 5.0f),
        poisonous_potato(Items.field_151170_bI, 0, 3.0f),
        empty_map((Item)Items.field_151148_bJ, 0, 44.0f),
        golden_carrot(Items.field_151150_bK, 0, 11.0f),
        carrot_on_a_stick(Items.field_151146_bM, 0, 4.0f),
        pumpkin_pie(Items.field_151158_bO, 0, 8.0f),
        enchanted_book_protection((Item)Items.field_151134_bR, 0, 80.0f),
        enchanted_book_fire_protection((Item)Items.field_151134_bR, 1, 80.0f),
        enchanted_book_feather_falling((Item)Items.field_151134_bR, 2, 80.0f),
        enchanted_book_blast_protection((Item)Items.field_151134_bR, 3, 80.0f),
        enchanted_book_projectile_protection((Item)Items.field_151134_bR, 4, 80.0f),
        enchanted_book_respiration((Item)Items.field_151134_bR, 5, 80.0f),
        enchanted_book_aqua_affinity((Item)Items.field_151134_bR, 6, 80.0f),
        enchanted_book_thorns((Item)Items.field_151134_bR, 7, 80.0f),
        enchanted_book_depth_strider((Item)Items.field_151134_bR, 8, 80.0f),
        enchanted_book_sharpness((Item)Items.field_151134_bR, 16, 80.0f),
        enchanted_book_smite((Item)Items.field_151134_bR, 17, 80.0f),
        enchanted_book_bane_of_arthropods((Item)Items.field_151134_bR, 18, 80.0f),
        enchanted_book_knockback((Item)Items.field_151134_bR, 19, 80.0f),
        enchanted_book_fire_aspect((Item)Items.field_151134_bR, 20, 80.0f),
        enchanted_book_looting((Item)Items.field_151134_bR, 21, 80.0f),
        enchanted_book_efficiency((Item)Items.field_151134_bR, 32, 80.0f),
        enchanted_book_silk_touch((Item)Items.field_151134_bR, 33, 80.0f),
        enchanted_book_unbreaking((Item)Items.field_151134_bR, 34, 80.0f),
        enchanted_book_fortune((Item)Items.field_151134_bR, 35, 80.0f),
        enchanted_book_power((Item)Items.field_151134_bR, 48, 80.0f),
        enchanted_book_punch((Item)Items.field_151134_bR, 49, 80.0f),
        enchanted_book_flame((Item)Items.field_151134_bR, 50, 80.0f),
        enchanted_book_infinity((Item)Items.field_151134_bR, 51, 80.0f),
        enchanted_book_luck_of_the_sea((Item)Items.field_151134_bR, 61, 80.0f),
        enchanted_book_lure((Item)Items.field_151134_bR, 62, 80.0f),
        nether_brick(Items.field_151130_bT, 0, 5.0f),
        quartz(Items.field_151128_bU, 0, 8.0f),
        iron_horse_armor(Items.field_151138_bX, 0, 80.0f),
        golden_horse_armor(Items.field_151136_bY, 0, 160.0f),
        diamond_horse_armor(Items.field_151125_bZ, 0, 1200.0f),
        lead(Items.field_151058_ca, 0, 6.0f);

        private float price;

        private EPrice(Block block, int metadataId, float price) {
            this(Item.func_150898_a((Block)block), metadataId, price);
        }

        private EPrice(Item item, int metadataId, float price) {
            this.price = price;
            priceMap.put((Object)item, (Object)metadataId, (Object)this);
        }

        @Override
        public float getPrice() {
            return this.price;
        }

        @Override
        public void setPrice(float price) {
            this.price = price;
        }
    }

    public static enum GPrice implements IItem
    {
        wool(Blocks.field_150325_L),
        dye(Items.field_151100_aR),
        potionitem((Item)Items.field_151068_bn),
        echantmentbook((Item)Items.field_151134_bR);

        Item item;

        private GPrice(Block block) {
            this(Item.func_150898_a((Block)block));
        }

        private GPrice(Item item) {
            this.item = item;
        }

        public IItem[] getIPrices() {
            Map map = IPrice.priceMap.row((Object)this.item);
            return map.values().toArray(new IItem[0]);
        }
    }

    public static interface IItem {
    }

    public static interface IPrice {
        public static final Table<Item, Integer, IPrice> priceMap = HashBasedTable.create();

        public String name();

        public float getPrice();

        public void setPrice(float var1);
    }
}

