/*
 * Decompiled with CFR 0.152.
 */
package diversity.utils;

import cpw.mods.fml.common.registry.VillagerRegistry;
import diversity.entity.EntityGlobalVillager;
import diversity.utils.Economy;
import diversity.utils.TradeTools;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public abstract class HandlerTools {

    public static class VillagerTradeHandler
    implements VillagerRegistry.IVillageTradeHandler {
        private final List<Economy.IItem> buyList = new ArrayList<Economy.IItem>();
        private final List<Economy.IItem> sellList = new ArrayList<Economy.IItem>();

        public VillagerTradeHandler(Economy.IItem[] buyList, Economy.IItem[] sellList) {
            for (Economy.IItem item : buyList) {
                this.buyList.add(item);
            }
            for (Economy.IItem item : sellList) {
                this.sellList.add(item);
            }
        }

        public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
            if (villager instanceof EntityGlobalVillager) {
                ArrayList<Economy.IItem> totalList = new ArrayList<Economy.IItem>();
                totalList.addAll(this.buyList);
                totalList.addAll(this.sellList);
                Collections.shuffle(totalList);
                for (Economy.IItem item : totalList) {
                    if (!(item instanceof Economy.IPrice)) continue;
                    if (this.buyList.contains(item)) {
                        recipeList.func_77205_a(TradeTools.getBuyTrade((Economy.IPrice)((Object)item), ((EntityGlobalVillager)villager).tribe, random));
                    }
                    if (!this.sellList.contains(item)) continue;
                    recipeList.func_77205_a(TradeTools.getSellTrade((Economy.IPrice)((Object)item), ((EntityGlobalVillager)villager).tribe, random));
                }
            }
        }
    }

    public static class VillageCreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public final Class pieceClass;
        public final int weight;
        public final int limit;

        public VillageCreationHandler(Class pieceClass, int weight, int limit) {
            this.pieceClass = pieceClass;
            this.weight = weight;
            this.limit = limit;
        }

        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
            return new StructureVillagePieces.PieceWeight(this.pieceClass, this.weight, i + random.nextInt(this.limit));
        }

        public Class<?> getComponentClass() {
            return this.pieceClass;
        }

        public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
            try {
                Class[] parametersType = new Class[]{StructureVillagePieces.Start.class, List.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Method method = this.pieceClass.getDeclaredMethod("buildComponent", StructureVillagePieces.Start.class, List.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return method.invoke(this.pieceClass.newInstance(), startPiece, pieces, random, p1, p2, p3, p4, p5);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

