/*
 * Decompiled with CFR 0.152.
 */
package diversity.utils;

import diversity.suppliers.SupplierTribe;
import diversity.utils.Economy;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;

public class TradeTools {
    public static MerchantRecipe getBuyTrade(Economy.IPrice enumPrice, SupplierTribe.EnumTribe tribe, Random random) {
        return TradeTools.getTrade(enumPrice, tribe, random, true);
    }

    public static MerchantRecipe getSellTrade(Economy.IPrice enumPrice, SupplierTribe.EnumTribe tribe, Random random) {
        return TradeTools.getTrade(enumPrice, tribe, random, false);
    }

    private static MerchantRecipe getTrade(Economy.IPrice itemPrice, SupplierTribe.EnumTribe tribe, Random random, boolean isBuyTrade) {
        float price = itemPrice.getPrice();
        ItemStack buyStack = null;
        ItemStack buyStack2 = null;
        ItemStack sellStack = null;
        int m = 1;
        if (Economy.getItem(itemPrice) instanceof ItemEnchantedBook) {
            Enchantment enchantment = Enchantment.field_77331_b[Economy.getMetadata(itemPrice)];
            int level = MathHelper.func_76136_a((Random)random, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            if (isBuyTrade) {
                buyStack = Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, level));
            } else {
                sellStack = Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, level));
            }
            price = (int)(itemPrice.getPrice() * (float)level + (float)random.nextInt(level) * itemPrice.getPrice() / 10.0f);
        } else {
            while (price != (float)((int)price) && m < 10) {
                price = itemPrice.getPrice() * (float)(++m);
            }
        }
        int nugget_price = 0;
        int ingot_price = 0;
        if (price > 64.0f) {
            if (price % 8.0f == 0.0f) {
                ingot_price = (int)price / 8;
            } else {
                nugget_price = (int)price % 8;
                ingot_price = (int)(price - (float)nugget_price) / 8;
            }
        } else {
            nugget_price = (int)price;
        }
        if (isBuyTrade) {
            if (buyStack == null) {
                buyStack = new ItemStack(Economy.getItem(itemPrice), m, Economy.getMetadata(itemPrice));
            }
            sellStack = ingot_price == 0 ? new ItemStack(Items.field_151074_bl, nugget_price) : new ItemStack(Items.field_151043_k, ingot_price);
        } else {
            if (ingot_price == 0) {
                buyStack = new ItemStack(Items.field_151074_bl, nugget_price);
            } else if (nugget_price == 0) {
                buyStack = new ItemStack(Items.field_151043_k, ingot_price);
            } else {
                buyStack = new ItemStack(Items.field_151043_k, ingot_price);
                buyStack2 = new ItemStack(Items.field_151074_bl, nugget_price);
            }
            if (sellStack == null) {
                sellStack = new ItemStack(Economy.getItem(itemPrice), m, Economy.getMetadata(itemPrice));
            }
        }
        if (buyStack2 == null) {
            return new MerchantRecipe(buyStack, sellStack);
        }
        return new MerchantRecipe(buyStack, buyStack2, sellStack);
    }
}

