/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import diversity.entity.EntityApache;
import diversity.suppliers.SupplierTribe;
import diversity.suppliers.SupplierVillage;
import diversity.village.VillageTools;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public final class VillageApache
extends VillageTools {
    private static VillageApache instance;

    public VillageApache(SupplierVillage.EnumVillage ENUM) {
        super(ENUM);
        instance = this;
    }

    @Override
    protected VillageTools.GlobalPath getPath(VillageTools.GlobalStart p_75080_0_, int p_75080_7_, Random p_75080_2_, StructureBoundingBox structureboundingbox, int p_75080_6_) {
        return new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
    }

    @Override
    public VillageTools.GlobalStart getStart(WorldChunkManager worldChunkManager, int i, Random rand, int j, int k, List list, int numberOfVillagers) {
        return new Start(worldChunkManager, i, rand, j, k, list, numberOfVillagers);
    }

    @Override
    protected VillageTools.GlobalTorch getTorch(VillageTools.GlobalStart villagePiece, int par2, Random rand, StructureBoundingBox boundingBox, int coordBaseMode) {
        return new Torch(villagePiece, par2, rand, boundingBox, coordBaseMode);
    }

    public static class Livestock
    extends VillageTools.GlobalVillage {
        public Livestock() {
        }

        public Livestock(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.APACHE_LIVESTOCK, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static Livestock buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)10, (int)4, (int)10, (int)coordBaseMode);
            return Livestock.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Livestock(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = 0; x < 10; ++x) {
                for (int z = 0; z < 10; ++z) {
                    this.func_151554_b(world, Blocks.field_150406_ce, 8, x, -1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150346_d, 0, x, 0, z, structureBoundingBox);
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 9, 0, 9, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 8, 0, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150396_be, this.func_151555_a(Blocks.field_150396_be, 0), 3, 0, 0, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 1);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntityApache(world, SupplierTribe.EnumVillager.APACHE_BREEDER);
                }
                case 1: {
                    return new EntityHorse(world);
                }
            }
            return null;
        }
    }

    public static class Torch
    extends VillageTools.GlobalTorch {
        public Torch() {
        }

        public Torch(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumBasic.APACHE_TORCH, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150325_L, random.nextBoolean() ? 1 : 3, 1, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 0, structureBoundingBox);
            return true;
        }
    }

    public static class ShamanTent
    extends VillageTools.GlobalVillage {
        public ShamanTent() {
        }

        public ShamanTent(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.APACHE_SHAMANTENT, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static ShamanTent buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)5, (int)10, (int)coordBaseMode);
            return ShamanTent.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new ShamanTent(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int x;
            this.func_151550_a(world, Blocks.field_150325_L, 0, 1, 1, 4, structureBoundingBox);
            this.func_74871_b(world, 1, 2, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 1, 0, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 9, 1, 4, structureBoundingBox);
            this.func_74871_b(world, 9, 2, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 9, 0, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 1, 8, structureBoundingBox);
            this.func_74871_b(world, 5, 2, 8, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 5, 0, 8, structureBoundingBox);
            for (int k = 0; k < 3; ++k) {
                this.func_74871_b(world, 2, 1, 3 + k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 2, 0, 3 + k, structureBoundingBox);
                this.func_74871_b(world, 8, 1, 3 + k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 8, 0, 3 + k, structureBoundingBox);
                this.func_74871_b(world, 4 + k, 1, 1, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 4 + k, 0, 1, structureBoundingBox);
                this.func_74871_b(world, 4 + k, 1, 7, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 4 + k, 0, 7, structureBoundingBox);
            }
            for (x = 3; x < 8; ++x) {
                for (int z = 3; z < 6; ++z) {
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, z, structureBoundingBox);
                }
            }
            for (x = 4; x < 7; ++x) {
                this.func_74871_b(world, x, 1, 2, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, 2, structureBoundingBox);
                this.func_74871_b(world, x, 1, 6, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, 6, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 2, 1, 3, 2, 2, 5, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 3, 8, 2, 5, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 1, 6, 2, 1, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 7, 6, 2, 7, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 2, 3, 3, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 7, 1, 2, 7, 3, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 2, 7, 3, 2, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 6, 7, 3, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 4, 4, 3, 6, 4, 5, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 7, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 7, 3, 6, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 3, 7, 2, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 2, 6, 2, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int i = 0; i < 5; ++i) {
                this.func_151550_a(world, Blocks.field_150325_L, 14, 4, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, 5, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, 6, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 3, 0, 3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 3, 0, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 3, 0, 5, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150325_L, 14, 5, 0, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 5, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 5, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 1, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 2, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 3, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 3, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 1, 0, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 5, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150429_aA, 0, 3, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 0, 7, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150429_aA, 0, 5, 2, 6, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 5, 2, 4, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityApache(world, SupplierTribe.EnumVillager.APACHE_SHAMAN);
        }
    }

    public static class ChiefTent
    extends VillageTools.GlobalVillage {
        public ChiefTent() {
        }

        public ChiefTent(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.APACHE_CHIEFTENT, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(5);
        }

        public static ChiefTent buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)15, (int)7, (int)13, (int)coordBaseMode);
            return ChiefTent.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new ChiefTent(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int x;
            this.func_151550_a(world, Blocks.field_150325_L, 0, 1, 1, 5, structureBoundingBox);
            this.func_74871_b(world, 1, 2, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 1, 0, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 13, 1, 5, structureBoundingBox);
            this.func_74871_b(world, 13, 2, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 13, 0, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 7, 1, 11, structureBoundingBox);
            this.func_74871_b(world, 7, 2, 11, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 7, 0, 11, structureBoundingBox);
            this.func_74871_b(world, 2, 3, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 2, 0, 5, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 5, 2, 2, 5, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_74871_b(world, 12, 3, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 12, 0, 5, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 12, 1, 5, 12, 2, 5, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_74871_b(world, 7, 3, 10, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 7, 0, 10, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 7, 1, 10, 7, 2, 10, Blocks.field_150325_L, Blocks.field_150325_L, false);
            for (int k = 0; k < 3; ++k) {
                this.func_74871_b(world, 3, 1, 4 + k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 3, 0, 4 + k, structureBoundingBox);
                this.func_74871_b(world, 11, 1, 4 + k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 11, 0, 4 + k, structureBoundingBox);
                this.func_74871_b(world, 6 + k, 1, 1, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 6 + k, 0, 1, structureBoundingBox);
                this.func_74871_b(world, 6 + k, 1, 9, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, 6 + k, 0, 9, structureBoundingBox);
            }
            for (x = 4; x < 11; ++x) {
                for (int z = 3; z < 8; ++z) {
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, z, structureBoundingBox);
                }
            }
            for (x = 5; x < 10; ++x) {
                this.func_74871_b(world, x, 1, 2, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, 2, structureBoundingBox);
                this.func_74871_b(world, x, 1, 8, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150406_ce, 8, x, 0, 8, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 3, 1, 4, 3, 3, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 11, 1, 4, 11, 3, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 9, 8, 3, 9, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 1, 8, 3, 1, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 3, 4, 4, 7, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 3, 10, 4, 7, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 8, 9, 4, 8, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 2, 9, 4, 2, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 5, 5, 3, 9, 5, 7, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 6, 6, 4, 8, 6, 6, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 9, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 5, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 4, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 9, 5, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 9, 4, 7, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 4, 4, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 8, 8, 3, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 2, 8, 3, 2, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 6, 5, 4, 8, 5, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int i = 0; i < 7; ++i) {
                this.func_151550_a(world, Blocks.field_150325_L, 14, 6, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, 7, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, 8, 0, i + 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 4, 0, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 4, 0, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150325_L, 14, i + 4, 0, 6, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150325_L, 14, 5, 0, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 14, 9, 0, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 14, 5, 0, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 14, 9, 0, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 14, 7, 0, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 7, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 7, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 7, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 7, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 7, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 7, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 5, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 11, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 11, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 12, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 13, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 14, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 2, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 3, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 5, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 5, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 6, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 6, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 6, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 6, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 4, 1, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 0, 6, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 0, 8, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_74881_a(world, structureBoundingBox, random, 7, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 4, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 10, 3, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 7, 3, 8, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 7, 2, 5, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityApache(world, SupplierTribe.EnumVillager.APACHE_CHIEF);
        }
    }

    public static class House2
    extends VillageTools.GlobalVillage {
        public House2() {
        }

        public House2(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.APACHE_HOUSE2, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static House2 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)5, (int)11, (int)coordBaseMode);
            return House2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House2(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int radius = 5;
            int base = 5;
            for (int y = 1; y < radius; ++y) {
                for (int x = -5; x < 6; ++x) {
                    for (int z = -5; z < 6; ++z) {
                        if (y == Math.abs(x) + Math.abs(z)) {
                            this.func_74871_b(world, base + x, 1, base + z, structureBoundingBox);
                            this.func_151554_b(world, Blocks.field_150406_ce, 8, base + x, 0, base + z, structureBoundingBox);
                            this.func_151550_a(world, Blocks.field_150325_L, 0, base + x, radius - y, base + z, structureBoundingBox);
                            if (y != radius - 1) {
                                this.func_151550_a(world, Blocks.field_150325_L, 12, base + x, 0, base + z, structureBoundingBox);
                            }
                            if (radius - y == 2) {
                                this.func_151550_a(world, Blocks.field_150404_cg, 7, base + x, 1, base + z, structureBoundingBox);
                            }
                        }
                        if ((y != Math.abs(x) || z != 0) && (x != 0 || y != Math.abs(z))) continue;
                        this.func_151550_a(world, Blocks.field_150422_aJ, 0, base + x, radius - y + 1, base + z, structureBoundingBox);
                    }
                }
            }
            this.func_74871_b(world, base, 2, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, base, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 1, 0, structureBoundingBox);
            this.func_74871_b(world, base, 2, 10, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, base, 0, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 1, 10, structureBoundingBox);
            this.func_74871_b(world, 0, 2, base, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 0, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 1, base, structureBoundingBox);
            this.func_74871_b(world, 10, 2, base, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 10, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, base, 4, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 12, base, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 5, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base - 2, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base + 2, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base, 1, base - 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base, 1, base + 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 3, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 4, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 2, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 3, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 4, 3, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 5, 2, 5, 0);
            this.spawnEntity(world, structureBoundingBox, 5, 2, 5, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityApache(world, SupplierTribe.EnumVillager.APACHE_WARRIOR);
        }
    }

    public static class House1
    extends VillageTools.GlobalVillage {
        public House1() {
        }

        public House1(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.APACHE_HOUSE1, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static House1 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)13, (int)6, (int)13, (int)coordBaseMode);
            return House1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House1(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int radius = 6;
            int base = 6;
            for (int y = 1; y < radius; ++y) {
                for (int x = -6; x < 7; ++x) {
                    for (int z = -6; z < 7; ++z) {
                        if (y == Math.abs(x) + Math.abs(z)) {
                            this.func_74871_b(world, base + x, 1, base + z, structureBoundingBox);
                            this.func_151554_b(world, Blocks.field_150406_ce, 8, base + x, 0, base + z, structureBoundingBox);
                            this.func_151550_a(world, Blocks.field_150325_L, 0, base + x, radius - y, base + z, structureBoundingBox);
                            if (y != radius - 1) {
                                this.func_151550_a(world, Blocks.field_150325_L, 12, base + x, 0, base + z, structureBoundingBox);
                            }
                            if (radius - y == 2) {
                                this.func_151550_a(world, Blocks.field_150404_cg, 7, base + x, 1, base + z, structureBoundingBox);
                            }
                        }
                        if ((y != Math.abs(x) || z != 0) && (x != 0 || y != Math.abs(z))) continue;
                        this.func_151550_a(world, Blocks.field_150422_aJ, 0, base + x, radius - y + 1, base + z, structureBoundingBox);
                    }
                }
            }
            this.func_74871_b(world, base, 2, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, base, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 1, 0, structureBoundingBox);
            this.func_74871_b(world, base, 2, 12, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, base, 0, 12, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 1, 12, structureBoundingBox);
            this.func_74871_b(world, 0, 2, base, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 0, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 1, base, structureBoundingBox);
            this.func_74871_b(world, 12, 2, base, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150406_ce, 8, 12, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 12, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, base, 5, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 12, base, 0, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 2, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 3, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 4, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, base, 6, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base - 3, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base + 3, 1, base, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base, 1, base - 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150404_cg, 7, base, 1, base + 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 3, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 4, 3, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 0, 5, 2, 4, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 4, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 6, 2, 6, 0);
            this.spawnEntity(world, structureBoundingBox, 6, 2, 6, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityApache(world, SupplierTribe.EnumVillager.APACHE_HUNTER);
        }
    }

    public static class Path
    extends VillageTools.GlobalPath {
        public Path() {
        }

        public Path(VillageTools.GlobalStart p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(instance, p_i2105_1_, p_i2105_2_, p_i2105_3_, p_i2105_4_, p_i2105_5_);
        }

        @Override
        protected VillageTools.BlockData getPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150406_ce, 0);
        }

        @Override
        protected VillageTools.BlockData getPathBridge(Random random) {
            return new VillageTools.BlockData((Block)Blocks.field_150376_bx, 0);
        }

        @Override
        protected VillageTools.BlockData getUnderPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150347_e, 0);
        }
    }

    public static class Start
    extends VillageTools.GlobalStart {
        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(instance, p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (super.addComponentParts(world, random, structureBoundingBox, 3)) {
                return true;
            }
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 5, 9, 5, Blocks.field_150346_d, Blocks.field_150346_d, false);
            this.func_151549_a(world, structureBoundingBox, 0, 10, 0, 5, 10, 5, Blocks.field_150406_ce, Blocks.field_150406_ce, false);
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.func_74871_b(world, j, 11, i, structureBoundingBox);
                }
            }
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 11, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 11, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 11, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 11, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 12, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 12, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 12, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 12, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150465_bP, this.func_151555_a(Blocks.field_150465_bP, 1), 0, 13, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150465_bP, this.func_151555_a(Blocks.field_150465_bP, 1), 0, 13, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150465_bP, this.func_151555_a(Blocks.field_150465_bP, 1), 5, 13, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150465_bP, this.func_151555_a(Blocks.field_150465_bP, 1), 5, 13, 5, structureBoundingBox);
            return true;
        }
    }
}

