/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import diversity.entity.EntityAztec;
import diversity.suppliers.SupplierTribe;
import diversity.suppliers.SupplierVillage;
import diversity.village.VillageTools;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageAztec
extends VillageTools {
    private static VillageAztec instance;

    public VillageAztec(SupplierVillage.EnumVillage ENUM) {
        super(ENUM);
        instance = this;
    }

    @Override
    protected VillageTools.GlobalPath getPath(VillageTools.GlobalStart p_75080_0_, int p_75080_7_, Random p_75080_2_, StructureBoundingBox structureboundingbox, int p_75080_6_) {
        return new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
    }

    @Override
    public VillageTools.GlobalStart getStart(WorldChunkManager worldChunkManager, int i, Random rand, int j, int k, List list, int numberOfVillagers) {
        return new Start(worldChunkManager, i, rand, j, k, list, numberOfVillagers);
    }

    @Override
    protected VillageTools.GlobalTorch getTorch(VillageTools.GlobalStart villagePiece, int par2, Random rand, StructureBoundingBox boundingBox, int coordBaseMode) {
        return new Torch(villagePiece, par2, rand, boundingBox, coordBaseMode);
    }

    private static VillageTools.BlockData getRandomBlock(Random random) {
        return random.nextInt(6) == 0 ? new VillageTools.BlockData(Blocks.field_150417_aV, 2) : new VillageTools.BlockData(Blocks.field_150417_aV, 0);
    }

    public static class Torch
    extends VillageTools.GlobalTorch {
        public Torch() {
        }

        public Torch(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumBasic.AZTEC_TORCH, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 0, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 0, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 2, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 1, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 0, structureBoundingBox);
            return true;
        }
    }

    public static class Field
    extends VillageTools.GlobalField {
        public Field() {
        }

        public Field(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_FIELD, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(8);
        }

        public static Field buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)16, (int)11, (int)15, (int)coordBaseMode);
            return Field.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Field(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        protected Block getCropType(Random random) {
            return random.nextBoolean() ? Blocks.field_150394_bc : Blocks.field_150393_bb;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 12, 0, 0, 12, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 0, 11, 0, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 8, 11, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (i = 1; i <= 7; ++i) {
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 1, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 2, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 4, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 5, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeC, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 7, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeC, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 8, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeD, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 10, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeD, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 11, 1, i, structureBoundingBox);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 13; ++j) {
                    this.func_74871_b(world, j, 4, i, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150346_d, 0, j, -1, i, structureBoundingBox);
                }
            }
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_FARMER);
        }
    }

    public static class Palace
    extends VillageTools.GlobalVillage {
        public Palace() {
        }

        public Palace(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_PALACE, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(9);
        }

        public static Palace buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)16, (int)11, (int)15, (int)coordBaseMode);
            return Palace.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Palace(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            int x;
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 15; ++z) {
                    if (x > 4 && x < 11 && z > 4 && z < 13) {
                        this.func_74871_b(world, x, 1, z, structureBoundingBox);
                    }
                    if (x == 0 || z == 0 || x == 15) continue;
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 1, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 2, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 3, 0, 3, 12, 2, 12, Blocks.field_150346_d, Blocks.field_150346_d, false);
            for (x = 3; x < 13; ++x) {
                for (z = 3; z < 13; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 3, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 4, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 5, 0, 5, 10, 2, 12, Blocks.field_150346_d, Blocks.field_150346_d, false);
            for (x = 5; x < 11; ++x) {
                for (z = 5; z < 13; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 5, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 6, z, structureBoundingBox);
                }
            }
            for (x = 6; x < 10; ++x) {
                for (int y = 3; y < 7; ++y) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 13, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 13, structureBoundingBox);
                    if (x != 7 && x != 8) continue;
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 14, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 14, structureBoundingBox);
                }
            }
            for (int k = 6; k < 10; ++k) {
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 1, 0, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, k, 0, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 3, 2, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 5, 4, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, 1, k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, 0, 0, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 2, 3, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 4, 5, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 15, 1, k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, 15, 0, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 13, 3, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 11, 5, k, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 2, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 4, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 2, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 4, 6, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 15, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 13, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 11, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 15, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 13, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 11, 6, 9, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 5, 3, 13, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 10, 3, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 4, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 4, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 7, 6, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 8, 6, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 5, 8, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 5, 7, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 5, 8, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 5, 7, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 8, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 9, 8, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 9, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 10, 8, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 10, 7, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 10, 8, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 10, 7, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 7, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 8, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 7, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 8, 11, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 5, 7, 12, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 5, 8, 12, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 7, 13, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 8, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 7, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 8, 10, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 7, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 8, 11, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 10, 7, 12, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 10, 8, 12, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 9, 7, 13, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 9, 8, 13, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 7, 9, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 8, 9, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 9, 7, 9, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 9, 8, 9, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 7, 7, 13, 8, 8, 13, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            for (x = 6; x < 10; ++x) {
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 9, 5, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 9, 13, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 9, 9, structureBoundingBox);
                for (z = 6; z < 13; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 10, z, structureBoundingBox);
                }
            }
            for (int z2 = 6; z2 < 13; ++z2) {
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 5, 9, z2, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 10, 9, z2, structureBoundingBox);
            }
            this.func_74881_a(world, structureBoundingBox, random, 7, 7, 9, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_74881_a(world, structureBoundingBox, random, 8, 7, 9, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 9, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 9, 9, 11, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 8, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 10, 8, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 7, 7, 11, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_CHIEF);
        }
    }

    public static class Livestock
    extends VillageTools.GlobalVillage {
        public Livestock() {
        }

        public Livestock(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_LIVESTOCK, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(1);
        }

        public static Livestock buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)3, (int)5, (int)coordBaseMode);
            return Livestock.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Livestock(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 5; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -2, z, structureBoundingBox);
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                    if (x == 0 || x == 6 || z == 0 || z == 4) {
                        this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, z, structureBoundingBox);
                        continue;
                    }
                    this.func_151550_a(world, Blocks.field_150346_d, 0, x, 0, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, -1, z, structureBoundingBox);
                }
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 1, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 2, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 3, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 1, 4, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 2, 4, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 3, 4, structureBoundingBox);
            }
            for (int z = 1; z < 4; ++z) {
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, 1, z, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 1, z, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 2, z, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 3, z, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 0, 2, 1, 0, 3, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 0, 5, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 0, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 0, 3, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 3, 3, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 3, 4, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 2, 1);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_BREEDER);
                }
                case 1: {
                    return new EntityChicken(world);
                }
            }
            return null;
        }
    }

    public static class Temple
    extends VillageTools.GlobalVillage {
        public Temple() {
        }

        public Temple(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_TEMPLE, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(9);
        }

        public static Temple buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)16, (int)11, (int)15, (int)coordBaseMode);
            return Temple.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Temple(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int k;
            int z;
            int x;
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 15; ++z) {
                    if (x > 4 && x < 11 && z > 4 && z < 13) {
                        this.func_74871_b(world, x, 1, z, structureBoundingBox);
                    }
                    if (x == 0 || z == 0 || x == 15) continue;
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 1, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 2, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 3, 0, 3, 12, 2, 12, Blocks.field_150346_d, Blocks.field_150346_d, false);
            for (x = 3; x < 13; ++x) {
                for (z = 3; z < 13; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 3, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 4, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 5, 0, 5, 10, 2, 12, Blocks.field_150346_d, Blocks.field_150346_d, false);
            for (x = 5; x < 11; ++x) {
                for (z = 5; z < 13; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 5, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 6, z, structureBoundingBox);
                }
            }
            for (x = 6; x < 10; ++x) {
                for (int y = 3; y < 7; ++y) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 13, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 13, structureBoundingBox);
                    if (x != 7 && x != 8) continue;
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 14, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, y, 14, structureBoundingBox);
                }
            }
            for (k = 6; k < 10; ++k) {
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 1, 0, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, k, 0, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 3, 2, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 5, 4, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, 1, k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, 0, 0, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 2, 3, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 4, 5, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 15, 1, k, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150417_aV, 0, 15, 0, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 13, 3, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 11, 5, k, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 6, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 9, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 2, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 4, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 2, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 4, 6, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 15, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 13, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 11, 6, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 15, 2, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 13, 4, 9, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 11, 6, 9, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 5, 3, 13, structureBoundingBox);
            this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 10, 3, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 5, 4, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 10, 4, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 7, 6, 14, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 8, 6, 14, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 5, 7, 9, 5, 8, 12, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 6, 7, 13, 9, 8, 13, Blocks.field_150325_L, Blocks.field_150325_L, false);
            this.func_151549_a(world, structureBoundingBox, 7, 7, 13, 8, 7, 13, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 10, 7, 9, 10, 8, 12, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 6, 7, 9, 9, 8, 9, Blocks.field_150325_L, Blocks.field_150325_L, false);
            for (k = 0; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150344_f, 3, 6 + k, 9, 9, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 3, 6 + k, 9, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 3, 5, 9, 9 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 3, 10, 9, 9 + k, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 6, 9, 10, 9, 9, 12, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            for (x = 6; x < 10; ++x) {
                for (z = 10; z < 13; ++z) {
                    this.func_151550_a(world, this.func_151558_b((Block)Blocks.field_150376_bx, 3), 3, x, 10, z, structureBoundingBox);
                }
            }
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 7, 7, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 8, 7, 6, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 7, 7, 9, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_74881_a(world, structureBoundingBox, random, 8, 7, 9, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 7, 8, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 8, 8, 13, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 10, 7, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 8, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 10, 8, 5, structureBoundingBox);
            this.func_74893_a(world, structureBoundingBox, 7, 7, 11, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_HIGHPRIEST);
        }
    }

    public static class House2
    extends VillageTools.GlobalVillage {
        public House2() {
        }

        public House2(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_HOUSE2, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static House2 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)6, (int)7, (int)coordBaseMode);
            return House2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House2(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int k;
            int z;
            int x;
            for (x = 0; x < 7; ++x) {
                for (z = 1; z < 6; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    if (x == 0 || x == 6) {
                        this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, z, structureBoundingBox);
                    } else {
                        this.func_151550_a(world, Blocks.field_150344_f, 3, x, 0, z, structureBoundingBox);
                    }
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            for (x = 1; x < 6; ++x) {
                this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, 0, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, 6, structureBoundingBox);
                this.func_74871_b(world, x, 1, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 0, 6, structureBoundingBox);
                this.func_74871_b(world, x, 1, 6, structureBoundingBox);
            }
            for (k = 1; k < 6; ++k) {
                if (k == 3) continue;
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, 1, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, 2, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 1, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 6, 2, k, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 1, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 2, 0, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 1, 6, structureBoundingBox);
                this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), k, 2, 6, structureBoundingBox);
            }
            for (x = 1; x < 6; ++x) {
                for (z = 1; z < 6; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 3, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 2, 3, 2, 4, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (x = 2; x < 5; ++x) {
                for (z = 2; z < 5; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x, 4, z, structureBoundingBox);
                }
            }
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 0, 3, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 1, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 1, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 6, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 6, 3, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 5, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 5, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 2, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 4, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 2, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), 4, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 2, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 4, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 2, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), 4, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 6, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 5, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 6, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 6, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 5, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 4, 6, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 6, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 5, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 6, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 5, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 6, 3, structureBoundingBox);
            for (k = 2; k < 4; ++k) {
                this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 7, k, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 4, 7, k + 1, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, k + 1, 7, 2, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, k, 7, 4, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 7, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 1, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 1, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 5, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 5, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 3, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150463_bK, 0, 3, 2, 5, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 3, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 5, 3, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_DYER);
        }
    }

    public static class House1
    extends VillageTools.GlobalVillage {
        public House1() {
        }

        public House1(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.AZTEC_HOUSE1, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static House1 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)6, (int)7, (int)coordBaseMode);
            return House1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House1(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            int x;
            for (x = 0; x < 9; ++x) {
                for (z = 1; z < 6; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            for (x = 1; x < 8; ++x) {
                this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, 0, structureBoundingBox);
                this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, 6, structureBoundingBox);
                this.func_74871_b(world, x, 1, 0, structureBoundingBox);
                this.func_74871_b(world, x, 1, 6, structureBoundingBox);
            }
            for (int y = 0; y < 4; ++y) {
                for (int x2 = 1; x2 < 8; ++x2) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x2, y, 0, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), x2, y, 6, structureBoundingBox);
                }
                for (z = 1; z < 6; ++z) {
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 0, y, z, structureBoundingBox);
                    this.placeBlockAtCurrentPosition(world, VillageAztec.getRandomBlock(random), 8, y, z, structureBoundingBox);
                }
            }
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 0, 1, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 0, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 0, 1, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 0, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 8, 1, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 8, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 8, 1, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 8, 2, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 1, 0, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 2, 0, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 1, 0, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 2, 0, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 2, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 2, 6, structureBoundingBox);
            for (x = 1; x < 8; ++x) {
                for (z = 1; z < 6; ++z) {
                    this.func_151550_a(world, Blocks.field_150344_f, 3, x, 0, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 1, 4, 1, 7, 4, 5, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 6, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 5, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 6, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 6, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 5, 5, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 5, 6, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 6, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 5, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 6, 6, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 6, 6, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 5, 5, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 5, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 6, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 5, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 2, 6, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 5, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 6, 3, structureBoundingBox);
            for (x = 2; x < 7; ++x) {
                for (z = 2; z < 5; ++z) {
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, x, 7, z, structureBoundingBox);
                }
            }
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 7, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 4, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 5, 3, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityAztec(world, SupplierTribe.EnumVillager.AZTEC_HUNTER);
        }
    }

    public static class Path
    extends VillageTools.GlobalPath {
        public Path() {
        }

        public Path(VillageTools.GlobalStart p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(instance, p_i2105_1_, p_i2105_2_, p_i2105_3_, p_i2105_4_, p_i2105_5_);
        }

        @Override
        protected VillageTools.BlockData getPathBlock(Random random) {
            return random.nextInt(3) == 1 ? new VillageTools.BlockData((Block)Blocks.field_150349_c, 0) : (random.nextInt(2) == 1 ? new VillageTools.BlockData(Blocks.field_150417_aV, 1) : new VillageTools.BlockData(Blocks.field_150417_aV, 0));
        }

        @Override
        protected VillageTools.BlockData getPathBridge(Random random) {
            return new VillageTools.BlockData((Block)Blocks.field_150376_bx, 0);
        }

        @Override
        protected VillageTools.BlockData getUnderPathBlock(Random random) {
            return random.nextInt(2) == 1 ? new VillageTools.BlockData(Blocks.field_150347_e, 0) : new VillageTools.BlockData(Blocks.field_150341_Y, 0);
        }
    }

    public static class Start
    extends VillageTools.GlobalStart {
        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(instance, p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
            if (super.addComponentParts(world, rand, structureBoundingBox, 3)) {
                return true;
            }
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 5, 9, 5, Blocks.field_150346_d, Blocks.field_150346_d, false);
            for (int x = 0; x < 6; ++x) {
                for (int z = 0; z < 6; ++z) {
                    this.func_74871_b(world, x, 11, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 0, 8, 0, 5, 9, 5, Blocks.field_150348_b, Blocks.field_150348_b, false);
            this.func_151549_a(world, structureBoundingBox, 0, 10, 0, 5, 10, 5, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_151549_a(world, structureBoundingBox, 2, 9, 2, 3, 10, 3, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 1, 11, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 1, 11, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 11, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 11, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 1, 12, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 1, 12, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 12, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 3, 4, 12, 4, structureBoundingBox);
            for (int k = 1; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 3), k, 13, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 0), 1, 13, k + 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 2), k + 1, 13, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150390_bg, 1), 4, 13, k, structureBoundingBox);
            }
            return true;
        }
    }
}

