/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import diversity.entity.EntityInuit;
import diversity.suppliers.SupplierTribe;
import diversity.suppliers.SupplierVillage;
import diversity.village.VillageTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public final class VillageInuit
extends VillageTools {
    private static VillageInuit instance;

    public VillageInuit(SupplierVillage.EnumVillage village) {
        super(village);
        instance = this;
    }

    @Override
    protected VillageTools.GlobalPath getPath(VillageTools.GlobalStart p_75080_0_, int p_75080_7_, Random p_75080_2_, StructureBoundingBox structureboundingbox, int p_75080_6_) {
        return new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
    }

    @Override
    public VillageTools.GlobalStart getStart(WorldChunkManager worldChunkManager, int i, Random rand, int j, int k, List list, int numberOfVillagers) {
        return new Start(worldChunkManager, i, rand, j, k, list, numberOfVillagers);
    }

    @Override
    protected VillageTools.GlobalTorch getTorch(VillageTools.GlobalStart villagePiece, int par2, Random rand, StructureBoundingBox boundingBox, int coordBaseMode) {
        return new Torch(villagePiece, par2, rand, boundingBox, coordBaseMode);
    }

    public static class Torch
    extends VillageTools.GlobalTorch {
        public Torch() {
        }

        public Torch(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumBasic.ESKIMO_TORCH, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150403_cj, 0, 1, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 0, structureBoundingBox);
            return true;
        }
    }

    public static class Kennel
    extends VillageTools.GlobalVillage {
        private int averageGroundLevel = -1;

        public Kennel() {
        }

        public Kennel(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.INUIT_KENNEL, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static Kennel buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)4, (int)6, (int)coordBaseMode);
            return Kennel.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Kennel(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 6; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 6, 0, 5, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 5, 0, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150396_be, this.func_151555_a(Blocks.field_150396_be, 0), 2, 0, 0, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 1);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 1);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 1);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntityInuit(world, SupplierTribe.EnumVillager.INUIT_KENNELMASTER);
                }
                case 1: {
                    return new EntityWolf(world);
                }
            }
            return null;
        }
    }

    public static class ChiefIgloo
    extends GlobalEskimoVillage {
        public ChiefIgloo() {
        }

        public ChiefIgloo(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.INUIT_CHIEFIGLOO, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(2);
        }

        public static ChiefIgloo buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)8, (int)4, (int)9, (int)coordBaseMode);
            return ChiefIgloo.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new ChiefIgloo(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int radius = 5;
            int baseX = 4;
            int baseZ = 5;
            double offset = 0.7;
            this.generateSphere(world, random, structureBoundingBox, baseX, baseZ, radius, offset, 10, 20);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 6, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 3, -1, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 4, -1, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 5, -1, 0, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 0, 5, 3, 0, Blocks.field_150403_cj, Blocks.field_150403_cj, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150433_aE, 0, 4, 0, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150433_aE, 0, 4, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 3, 0, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150403_cj, 0, 3, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 7, 2, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 5, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityInuit(world, SupplierTribe.EnumVillager.INUIT_CHIEF);
        }
    }

    public static class Igloo2
    extends GlobalEskimoVillage {
        public Igloo2() {
        }

        public Igloo2(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.INUIT_IGLOO2, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(2);
        }

        public static Igloo2 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)8, (int)4, (int)8, (int)coordBaseMode);
            return Igloo2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Igloo2(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int radius = 4;
            int baseX = 3;
            int baseZ = 3;
            double offset = 0.7;
            this.generateSphere(world, random, structureBoundingBox, baseX, baseZ, radius, offset, 18, 30);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150433_aE, 0, 3, 0, 0, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 3, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150403_cj, 0, 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 2, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 2, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityInuit(world, SupplierTribe.EnumVillager.INUIT_HUNTER);
        }
    }

    public static class Igloo1
    extends GlobalEskimoVillage {
        private StructureBoundingBox structureBoundingBox;
        private World world;

        public Igloo1() {
        }

        public Igloo1(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.INUIT_IGLOO1, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static Igloo1 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)5, (int)10, (int)coordBaseMode);
            return Igloo1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Igloo1(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int radius = 5;
            int baseX = 4;
            int baseZ = 5;
            double offset = 0.5;
            this.generateSphere(world, random, structureBoundingBox, baseX, baseZ, radius, offset, 15, 20);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 3, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 3, 7, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 3, -1, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 4, -1, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150403_cj, 0, 5, -1, 0, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 0, 5, 3, 0, Blocks.field_150403_cj, Blocks.field_150403_cj, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150433_aE, 0, 4, 0, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150433_aE, 0, 4, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 3, 0, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150364_r, 3, 4, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 7, 2, 5, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 5, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 5, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityInuit(world, SupplierTribe.EnumVillager.INUIT_FISHERMAN);
        }
    }

    public static abstract class GlobalEskimoVillage
    extends VillageTools.GlobalVillage {
        public GlobalEskimoVillage() {
        }

        public GlobalEskimoVillage(SupplierVillage.EnumPiece enumPiece, StructureVillagePieces.Start startPiece, int componentType, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(enumPiece, startPiece, componentType, structureBoundingBox, coordBaseMode);
        }

        protected void generateSphere(World world, Random random, StructureBoundingBox structureBoundingBox, int baseX, int baseZ, int radius, double offset, int baseIncrement, int topIncrement) {
            ArrayList basePoints = new ArrayList();
            ArrayList topPoints = new ArrayList();
            for (int baseDegree = 0; baseDegree < 360; baseDegree += baseIncrement) {
                for (int topDegree = 0; topDegree < 180; topDegree += topIncrement) {
                    VillageTools.Point point = VillageTools.getSpherePoint(radius, baseDegree, topDegree, offset);
                    point.set(baseX + point.x, baseZ + point.z);
                    VillageTools.Point sidePoint = VillageInuit.getSpherePoint(radius, baseDegree, 180, offset);
                    sidePoint.set(baseX + sidePoint.x, baseZ + sidePoint.z);
                    this.func_151554_b(world, Blocks.field_150403_cj, 0, point.x, -1, point.z, structureBoundingBox);
                    if (!(Math.abs(point.x - baseX) != radius - 1 && sidePoint.x != point.x || Math.abs(point.z - baseZ) != radius - 1 && sidePoint.z != point.z)) {
                        this.func_151550_a(world, Blocks.field_150403_cj, 0, point.x, 0, point.z, structureBoundingBox);
                    } else if (random.nextInt(4) == 0 && point.x != 0 && point.x != 2 * baseX && point.z != 0 && point.z != 2 * baseZ) {
                        this.func_151550_a(world, Blocks.field_150364_r, 3, point.x, 0, point.z, structureBoundingBox);
                    } else {
                        this.func_151550_a(world, Blocks.field_150433_aE, 0, point.x, 0, point.z, structureBoundingBox);
                    }
                    this.func_74871_b(world, point.x, 1, point.z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150403_cj, 0, point.x, point.y, point.z, structureBoundingBox);
                }
            }
        }
    }

    public static class Path
    extends VillageTools.GlobalPath {
        public Path() {
        }

        public Path(VillageTools.GlobalStart p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(instance, p_i2105_1_, p_i2105_2_, p_i2105_3_, p_i2105_4_, p_i2105_5_);
        }

        @Override
        protected VillageTools.BlockData getPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150433_aE, 0);
        }

        @Override
        protected VillageTools.BlockData getPathBridge(Random random) {
            return new VillageTools.BlockData((Block)Blocks.field_150376_bx, 1);
        }

        @Override
        protected VillageTools.BlockData getUnderPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150347_e, 0);
        }
    }

    public static class Start
    extends VillageTools.GlobalStart {
        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(instance, p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (super.addComponentParts(p_74875_1_, p_74875_2_, p_74875_3_, 3)) {
                return true;
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 5, 10, 5, Blocks.field_150432_aD, (Block)Blocks.field_150358_i, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 10, 0, 5, 10, 5, Blocks.field_150433_aE, Blocks.field_150433_aE, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 10, 2, 3, 10, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    this.func_74871_b(p_74875_1_, j, 11, i, p_74875_3_);
                }
            }
            this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 11, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 12, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 11, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 12, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 2, 11, 1, p_74875_3_);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 13, 3, 4, 13, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            return true;
        }
    }
}

