/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import diversity.entity.EntityLakeside;
import diversity.suppliers.SupplierTribe;
import diversity.suppliers.SupplierVillage;
import diversity.utils.DirectionTools;
import diversity.village.VillageTools;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageLakeside
extends VillageTools {
    private static VillageLakeside instance;

    public VillageLakeside(SupplierVillage.EnumVillage ENUM) {
        super(ENUM);
        instance = this;
    }

    @Override
    public VillageTools.GlobalStart getStart(WorldChunkManager worldChunkManager, int i, Random rand, int j, int k, List list, int numberOfVillagers) {
        return new Start(worldChunkManager, i, rand, j, k, list, numberOfVillagers);
    }

    @Override
    protected VillageTools.GlobalTorch getTorch(VillageTools.GlobalStart villagePiece, int par2, Random rand, StructureBoundingBox boundingBox, int coordBaseMode) {
        return new Torch(villagePiece, par2, rand, boundingBox, coordBaseMode);
    }

    @Override
    protected VillageTools.GlobalPath getPath(VillageTools.GlobalStart p_75080_0_, int p_75080_7_, Random p_75080_2_, StructureBoundingBox structureboundingbox, int p_75080_6_) {
        return new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
    }

    static class Planks
    extends StructureComponent.BlockSelector {
        private Planks() {
        }

        public void func_75062_a(Random p_75062_1_, int p_75062_2_, int p_75062_3_, int p_75062_4_, boolean p_75062_5_) {
            this.field_151562_a = Blocks.field_150344_f;
            this.field_75065_b = p_75062_1_.nextFloat() < 0.4f ? 0 : 1;
        }

        Planks(Object p_i2063_1_) {
            this();
        }
    }

    public static class Field
    extends VillageTools.GlobalField {
        private static Planks randomSwampPlanks = new Planks(null);

        public Field() {
        }

        public Field(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.LAKESIDE_FIELD, villagePiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(1);
        }

        public static Field buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)8, (int)4, (int)7, (int)coordBaseMode);
            return Field.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Field(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        protected Block getCropType(Random random) {
            return random.nextBoolean() ? Blocks.field_150459_bM : Blocks.field_150469_bN;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            int x;
            for (x = 0; x < 8; ++x) {
                for (z = 0; z < 8; ++z) {
                    this.func_74871_b(world, x, 1, z, structureBoundingBox);
                }
            }
            this.func_74882_a(world, structureBoundingBox, 0, -3, 2, 0, 0, 6, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 7, -3, 2, 7, 0, 6, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 1, -3, 1, 6, 0, 1, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 1, -3, 7, 6, 0, 7, false, random, randomSwampPlanks);
            for (x = 1; x < 7; ++x) {
                for (z = 2; z < 7; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150458_ak, 0, x, 0, z, structureBoundingBox);
                }
            }
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 2, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 1, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 1, 7, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 7, 2, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 7, 1, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 7, 1, 7, structureBoundingBox);
            for (x = 0; x < 8; ++x) {
                for (z = 1; z < 8; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -4, z, structureBoundingBox);
                }
            }
            for (x = 1; x < 7; ++x) {
                this.func_74871_b(world, x, 1, 0, structureBoundingBox);
            }
            this.func_74882_a(world, structureBoundingBox, 1, -3, 0, 6, 0, 0, false, random, randomSwampPlanks);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 2, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 1, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 6, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 6, 1, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 1, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 1, 1, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 0, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 7, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], 0, 1, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], 7, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 0, 1, 4, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 7, 1, 4, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 4, 7, 0, 4, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (x = 1; x < 7; ++x) {
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), x, 1, 2, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), x, 1, 3, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), x, 1, 5, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), x, 1, 6, structureBoundingBox);
            }
            this.spawnEntity(world, structureBoundingBox, 3, 1, 1, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 1, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityLakeside(world, SupplierTribe.EnumVillager.LAKESIDE_FARMER);
        }
    }

    public static class Breeding
    extends VillageTools.GlobalVillage {
        private static Planks randomSwampPlanks = new Planks(null);

        public Breeding() {
        }

        public Breeding(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.LAKESIDE_BREEDING, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static Breeding buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)10, (int)4, (int)8, (int)coordBaseMode);
            return Breeding.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Breeding(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            int x;
            for (x = 0; x < 10; ++x) {
                for (z = 0; z < 9; ++z) {
                    this.func_74871_b(world, x, -2, z, structureBoundingBox);
                }
            }
            this.func_74882_a(world, structureBoundingBox, 0, -6, 2, 0, -3, 7, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 8, -6, 2, 8, -3, 7, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 1, -6, 1, 7, -3, 1, false, random, randomSwampPlanks);
            this.func_74882_a(world, structureBoundingBox, 1, -6, 8, 7, -3, 8, false, random, randomSwampPlanks);
            for (x = 1; x < 8; ++x) {
                for (z = 2; z < 8; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -4, z, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150349_c, 0, x, -3, z, structureBoundingBox);
                }
            }
            for (x = 0; x < 9; ++x) {
                for (z = 1; z < 9; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -7, z, structureBoundingBox);
                }
            }
            this.func_74878_a(world, structureBoundingBox, 4, -6, 1, 4, -3, 1);
            this.func_74878_a(world, structureBoundingBox, 8, -6, 4, 8, -3, 4);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, -2, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, -2, 8, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 8, -2, 8, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 8, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 8, 3, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 3, 4, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 1, -2, 1, 3, -2, 1, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 0, -2, 2, 0, -2, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 1, -2, 8, 7, -2, 8, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 8, -2, 5, 8, -2, 7, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 8, -2, 2, 8, -1, 3, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 5, -2, 1, 7, -1, 1, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            for (int k = 0; k < 3; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5 + k, 0, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5 + k, 0, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5 + k, 3, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5 + k, 3, 4, structureBoundingBox);
                if (k == 2) continue;
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 8, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 3, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 8, 3, 2 + k, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 5, 1, 1, 7, 2, 1, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 5, 1, 4, 7, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 4, 1, 2, 4, 2, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 8, 1, 2, 8, 2, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 5, 0, 2, 7, 0, 3, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 4, -1, 0, 8, -1, 0, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 5, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][3], 6, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 7, 0, 0, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 3, 0, 1, 3, 0, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 9, 0, 1, 9, 0, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 6, 0, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 7, 0, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 5, 0, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 4, -1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 3, -2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 2, 5, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 3, 3, 0, 3, 3, 4, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 3, 3, 5, 8, 3, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 9, 3, 1, 9, 3, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 4, 3, 0, 9, 3, 0, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 4, 4, 1, 8, 4, 4, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            this.func_151556_a(world, structureBoundingBox, 5, 4, 2, 7, 4, 3, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 8, 2, 2, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 6, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_74881_a(world, structureBoundingBox, random, 6, 1, 4, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 2, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 2, -2, 1, 0);
            this.spawnEntity(world, structureBoundingBox, 2, -2, 1, 1);
            this.spawnEntity(world, structureBoundingBox, 2, -2, 1, 1);
            this.spawnEntity(world, structureBoundingBox, 2, -2, 1, 1);
            this.spawnEntity(world, structureBoundingBox, 2, -2, 1, 1);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntityLakeside(world, SupplierTribe.EnumVillager.LAKESIDE_BREEDER);
                }
                case 1: {
                    return new EntityPig(world);
                }
            }
            return null;
        }
    }

    public static class Tower
    extends VillageTools.GlobalVillage {
        public Tower() {
        }

        public Tower(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.LAKESIDE_TOWER, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(7);
        }

        public static Tower buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)6, (int)7, (int)5, (int)coordBaseMode);
            return Tower.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Tower(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int k;
            for (int x = 0; x < 6; ++x) {
                for (int z = 0; z < 6; ++z) {
                    this.func_74871_b(world, x, -2, z, structureBoundingBox);
                }
            }
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 6, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 6, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 6, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 6, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, 0, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, -2, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 3, -3, 5, structureBoundingBox);
            for (k = 0; k < 2; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 6, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 6, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 3, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 3, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 6, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 6, 2 + k, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 2, 1, 1, 3, 2, 1, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 1, 4, 3, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 1, 1, 2, 1, 2, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 4, 1, 2, 4, 2, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 4, 1, 3, 5, 1, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 4, 4, 3, 5, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 1, 4, 2, 1, 5, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 4, 4, 2, 4, 5, 3, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 0, 2, 3, 0, 3, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 1, -1, 0, 4, -1, 0, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 1, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][3], 2, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 3, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 1, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 9, 5, 0, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][2], 5, 0, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][2], 5, -1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 4, -2, 5, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 2, 3, 2, 3, 3, 3, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 1, 3, 0, 4, 3, 0, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 0, 3, 1, 0, 3, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 1, 3, 5, 4, 3, 5, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 5, 3, 1, 5, 3, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 4, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 4, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 5, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 5, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 0, 6, 0, 0, 6, 4, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 0, 6, 5, 4, 6, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 5, 6, 1, 5, 6, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 1, 6, 0, 5, 6, 0, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 1, 7, 1, 4, 7, 4, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            this.func_151556_a(world, structureBoundingBox, 2, 7, 2, 3, 7, 3, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 4, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 5, 4, structureBoundingBox);
            for (k = 1; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 3, k, 3, structureBoundingBox);
            }
            this.func_74881_a(world, structureBoundingBox, random, 2, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 2, this.func_151555_a(Blocks.field_150466_ao, 2));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 5, 2, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 4, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityLakeside(world, SupplierTribe.EnumVillager.LAKESIDE_GUARD);
        }
    }

    public static class House2
    extends VillageTools.GlobalVillage {
        public House2() {
        }

        public House2(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.LAKESIDE_HOUSE2, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static House2 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)8, (int)4, (int)6, (int)coordBaseMode);
            return House2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House2(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 7; ++z) {
                    this.func_74871_b(world, x, -1, z, structureBoundingBox);
                }
            }
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 6, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 3, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 6, 3, 5, structureBoundingBox);
            for (int k = 0; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 5, structureBoundingBox);
                if (k == 3) continue;
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 6, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 3, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 6, 3, 2 + k, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 2, 1, 1, 5, 2, 1, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 1, 5, 5, 2, 5, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 1, 1, 2, 1, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 6, 1, 2, 6, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 0, 2, 5, 0, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 1, -1, 0, 6, -1, 0, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][0], 3, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][3], 4, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150485_bF, DirectionTools.stair[this.field_74885_f][1], 5, 0, 0, structureBoundingBox);
            this.func_151556_a(world, structureBoundingBox, 0, 3, 0, 0, 3, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 0, 3, 6, 6, 3, 6, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 7, 3, 1, 7, 3, 6, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 1, 3, 0, 7, 3, 0, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 1, 4, 1, 6, 4, 5, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            this.func_151556_a(world, structureBoundingBox, 2, 4, 2, 5, 4, 4, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 4, 2, 5, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 4, 3, 2, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityLakeside(world, SupplierTribe.EnumVillager.LAKESIDE_CHIEF);
        }
    }

    public static class House1
    extends VillageTools.GlobalVillage {
        public House1() {
        }

        public House1(StructureVillagePieces.Start villagePiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.LAKESIDE_HOUSE1, villagePiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static House1 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)4, (int)6, (int)coordBaseMode);
            return House1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House1(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    this.func_74871_b(world, x, -1, z, structureBoundingBox);
                }
            }
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, 3, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 3, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, 3, 5, structureBoundingBox);
            for (int k = 0; k < 3; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 0, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 2 + k, 3, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 5, 0, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 3, 2 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 5, 3, 2 + k, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 2, 1, 1, 4, 2, 1, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 1, 5, 4, 2, 5, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 1, 1, 2, 1, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 5, 1, 2, 5, 2, 4, Blocks.field_150344_f, 1, Blocks.field_150344_f, 1, false);
            this.func_151556_a(world, structureBoundingBox, 2, 0, 2, 4, 0, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 1, 0, 0, 5, 0, 0, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 0, 3, 0, 0, 3, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 0, 3, 6, 5, 3, 6, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 6, 3, 1, 6, 3, 6, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 1, 3, 0, 6, 3, 0, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 1, 4, 1, 5, 4, 5, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            this.func_151556_a(world, structureBoundingBox, 2, 4, 2, 4, 4, 4, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 1, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 5, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 2, 5, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 3, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 3, 2, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 3, 0);
            this.spawnEntity(world, structureBoundingBox, 3, 1, 3, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntityLakeside(world, SupplierTribe.EnumVillager.LAKESIDE_FISHERMAN);
        }
    }

    public static class Torch
    extends VillageTools.GlobalTorch {
        public Torch() {
        }

        public Torch(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumBasic.LAKE_TORCH, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.func_151556_a(world, structureBoundingBox, 0, -2, 0, 2, -2, 1, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151550_a(world, Blocks.field_150350_a, 1, 1, -2, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 1, 0, structureBoundingBox);
            for (int k = -1; k < 2; ++k) {
                this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 0, k, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 2), 2, k, 1, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 2, 1, structureBoundingBox);
            return true;
        }
    }

    public static class Path
    extends VillageTools.GlobalPath {
        public Path() {
        }

        public Path(VillageTools.GlobalStart p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(instance, p_i2105_1_, p_i2105_2_, p_i2105_3_, p_i2105_4_, p_i2105_5_);
        }

        @Override
        protected VillageTools.BlockData getPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150351_n, 0);
        }

        @Override
        protected VillageTools.BlockData getPathBridge(Random random) {
            return new VillageTools.BlockData((Block)Blocks.field_150376_bx, 1);
        }

        @Override
        protected VillageTools.BlockData getUnderPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150346_d, 0);
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
                    if (!structureBoundingBox.func_78890_b(x, 64, z)) continue;
                    int y = world.func_72825_h(x, z) - 1;
                    if (y < 64) {
                        boolean isSupport = false;
                        switch (this.field_74885_f) {
                            case 1: 
                            case 3: {
                                isSupport = x % 4 == 0 && (z == this.field_74887_e.field_78896_c || z == this.field_74887_e.field_78892_f) && random.nextBoolean();
                                break;
                            }
                            case 0: 
                            case 2: {
                                boolean bl = isSupport = z % 4 == 0 && (x == this.field_74887_e.field_78897_a || x == this.field_74887_e.field_78893_d) && random.nextBoolean();
                            }
                        }
                        if (isSupport) {
                            y = 64;
                            while (isSupport) {
                                if (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
                                    world.func_147465_d(x, y, z, Blocks.field_150364_r, 0, 2);
                                } else {
                                    isSupport = false;
                                }
                                if (--y != 50) continue;
                                isSupport = false;
                            }
                            continue;
                        }
                        world.func_147465_d(x, 64, z, (Block)Blocks.field_150376_bx, 9, 2);
                        continue;
                    }
                    VillageTools.BlockData blockData = this.getPathBlock(random);
                    world.func_147465_d(x, y, z, blockData.block, blockData.metaData, 2);
                }
            }
            return true;
        }
    }

    public static class Start
    extends VillageTools.GlobalStart {
        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(instance, p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
            this.field_74885_f = 2;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
            if (super.addComponentParts(world, rand, structureBoundingBox, 2)) {
                return true;
            }
            for (int x = 0; x <= 5; ++x) {
                for (int z = 0; z <= 5; ++z) {
                    this.func_74871_b(world, x, 11, z, structureBoundingBox);
                }
            }
            this.func_151556_a(world, structureBoundingBox, 1, 12, 2, 4, 12, 3, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151556_a(world, structureBoundingBox, 2, 12, 1, 3, 12, 4, (Block)Blocks.field_150376_bx, 9, (Block)Blocks.field_150376_bx, 9, false);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 13, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 0, 13, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, 13, 0, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 5, 13, 5, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 15, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 1, 15, 4, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 15, 1, structureBoundingBox);
            this.func_151554_b(world, Blocks.field_150364_r, 0, 4, 15, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 14, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 14, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 14, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 5, 14, 5, structureBoundingBox);
            for (int k = 1; k < 5; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 0, 12, k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 5, 12, k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], k, 12, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], k, 12, 5, structureBoundingBox);
                if (k != 2 && k != 3) continue;
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], k, 15, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], k, 15, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 15, k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 15, k, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 0, 15, 0, 0, 15, 4, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], false);
            this.func_151556_a(world, structureBoundingBox, 0, 15, 5, 4, 15, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], false);
            this.func_151556_a(world, structureBoundingBox, 5, 15, 1, 5, 15, 5, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], false);
            this.func_151556_a(world, structureBoundingBox, 1, 15, 0, 5, 15, 0, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], false);
            this.func_151556_a(world, structureBoundingBox, 1, 16, 1, 4, 16, 4, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            this.func_151556_a(world, structureBoundingBox, 2, 16, 2, 3, 16, 3, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            return true;
        }
    }
}

