/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import diversity.entity.EntitySettled;
import diversity.suppliers.SupplierTribe;
import diversity.suppliers.SupplierVillage;
import diversity.utils.DirectionTools;
import diversity.village.VillageTools;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;

public class VillageSettled
extends VillageTools {
    private static VillageSettled instance;

    public VillageSettled(SupplierVillage.EnumVillage ENUM) {
        super(ENUM);
        instance = this;
    }

    @Override
    public VillageTools.GlobalStart getStart(WorldChunkManager worldChunkManager, int i, Random rand, int j, int k, List list, int numberOfVillagers) {
        return new Start(worldChunkManager, i, rand, j, k, list, numberOfVillagers);
    }

    @Override
    protected VillageTools.GlobalTorch getTorch(VillageTools.GlobalStart villagePiece, int par2, Random rand, StructureBoundingBox boundingBox, int coordBaseMode) {
        return new Torch(villagePiece, par2, rand, boundingBox, coordBaseMode);
    }

    @Override
    protected VillageTools.GlobalPath getPath(VillageTools.GlobalStart p_75080_0_, int p_75080_7_, Random p_75080_2_, StructureBoundingBox structureboundingbox, int p_75080_6_) {
        return new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
    }

    public static class Torch
    extends VillageTools.GlobalTorch {
        public Torch() {
        }

        public Torch(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumBasic.SETTLED_TORCH, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150325_L, 15, 1, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 0, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 1, 3, -1, structureBoundingBox);
            return true;
        }
    }

    public static class House4Garden
    extends VillageTools.GlobalVillage {
        public House4Garden() {
        }

        public House4Garden(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_HOUSE4GARDEN, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(4);
        }

        public static House4Garden buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (int)coordBaseMode);
            return House4Garden.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House4Garden(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(world, j, 0, i, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, j, -1, i, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 4, 0, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 3, 0, 3, Blocks.field_150348_b, Blocks.field_150348_b, false);
            this.func_151550_a(world, Blocks.field_150348_b, 0, 2, 0, 0, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 1, 4, 1, 3, 4, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            for (int k = 0; k < 5; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, 0, 0, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 4, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 0, k, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 4, k, 4, structureBoundingBox);
                if (k >= 3) continue;
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 1 + k, 4, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 1 + k, 4, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 0, 4, 1 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 4, 4, 1 + k, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 4, 3, 3, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 2, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 3, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 1, 0, structureBoundingBox);
            if (this.func_151548_a(world, 2, 0, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(world, 2, -1, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 0, 5, 3, structureBoundingBox);
            i = this.func_151555_a(Blocks.field_150468_ap, 3);
            this.func_151550_a(world, Blocks.field_150468_ap, i, 3, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150468_ap, i, 3, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150468_ap, i, 3, 3, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150468_ap, i, 3, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 1, structureBoundingBox);
            this.spawnEntity(world, structureBoundingBox, 1, 1, 2, 0);
            this.spawnEntity(world, structureBoundingBox, 1, 1, 2, 0);
            this.spawnEntity(world, structureBoundingBox, 1, 1, 2, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_GUARD);
        }
    }

    public static class House3
    extends VillageTools.GlobalVillage {
        public House3() {
        }

        public House3(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_HOUSE3, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(6);
        }

        public static House3 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)7, (int)7, (int)coordBaseMode);
            return House3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new House3(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int k;
            for (int x = 1; x < 8; ++x) {
                for (int z = 0; z < 7; ++z) {
                    if ((x == 1 || x == 7) && (z == 0 || z == 6)) continue;
                    this.func_74871_b(world, x, 0, z, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, x, -1, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 2, 0, 0, 2, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 0, 6, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 1, 4, 1, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 1, 7, 4, 1, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 2, 0, 6, 2, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 6, 6, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 5, 1, 4, 5, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 5, 7, 4, 5, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 0, 5, 5, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 6, 5, 5, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 2, 1, 2, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 2, 7, 2, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            for (k = 0; k < 5; ++k) {
                if (k < 1) {
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4 + k, 6, 0, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4 + k, 6, 6, structureBoundingBox);
                }
                if (k < 3) {
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 3 + k, 3, 0, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 3 + k, 3, 6, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 3, 2 + k, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 7, 3, 2 + k, structureBoundingBox);
                }
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 2, 4, 1 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 6, 4, 1 + k, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 2, 0, 1, 6, 0, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151556_a(world, structureBoundingBox, 2, 3, 1, 6, 3, 5, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            for (int z = 0; z < 7; ++z) {
                if (z != 0 && z != 6) {
                    this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 0, 3, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 8, 3, z, structureBoundingBox);
                }
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 1, 4, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 2, 5, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 3, 6, z, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 4, 7, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 5, 6, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 6, 5, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 7, 4, z, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 4, 4, 0, 4, 5, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(world, structureBoundingBox, 4, 4, 6, 4, 5, 6, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 6, structureBoundingBox);
            for (k = 1; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 3), 3, k, 5, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 3, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 2, 5, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(world, 4, 0, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(world, 2, -1, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 4, 0, -1, structureBoundingBox);
            }
            this.spawnEntity(world, structureBoundingBox, 4, 1, 2, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 1, 2, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_VILLAGER);
        }
    }

    public static class Forge
    extends VillageTools.GlobalVillage {
        private boolean hasMadeChest;

        public Forge() {
        }

        public Forge(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_FORGE, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(5);
        }

        public static Forge buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (int)coordBaseMode);
            return Forge.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Forge(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int j;
            int i;
            for (i = 0; i < 7; ++i) {
                for (j = 0; j < 10; ++j) {
                    this.func_74871_b(world, j, 0, i, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, j, -1, i, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 9, 0, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 0, 4, 0, 9, 4, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 4, 1, 8, 4, 5, Blocks.field_150348_b, Blocks.field_150348_b, false);
            this.func_151549_a(world, structureBoundingBox, 0, 5, 0, 9, 5, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 0, 2, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 0, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 0, 3, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 0, 1, 6, 0, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 3, 1, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 2, 3, 3, 2, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 3, 5, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 0, 1, 1, 0, 3, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 6, 5, 3, 6, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 0, 5, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 0, 9, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 4, 9, 4, 6, Blocks.field_150348_b, Blocks.field_150348_b, false);
            this.func_151550_a(world, (Block)Blocks.field_150356_k, 0, 7, 1, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150356_k, 0, 8, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 9, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 9, 2, 4, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 6, 6, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 6, 9, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 7, 1, 6, 8, 4, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 9, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 9, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150348_b, 0, 6, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150460_al, 0, 6, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150460_al, 0, 6, 3, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 8, 1, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 2, 2, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 3), 2, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 1), 1, 1, 4, structureBoundingBox);
            if (!this.hasMadeChest) {
                int k;
                i = this.func_74862_a(1);
                j = this.func_74865_a(5, 5);
                if (structureBoundingBox.func_78890_b(j, i, k = this.func_74873_b(5, 5))) {
                    this.hasMadeChest = true;
                    this.func_74879_a(world, structureBoundingBox, random, 5, 1, 5, ChestGenHooks.getItems((String)"villageBlacksmith", (Random)random), ChestGenHooks.getCount((String)"villageBlacksmith", (Random)random));
                }
            }
            for (i = 6; i <= 8; ++i) {
                if (this.func_151548_a(world, i, 0, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a || this.func_151548_a(world, i, -1, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a) continue;
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), i, 0, -1, structureBoundingBox);
            }
            this.spawnEntity(world, structureBoundingBox, 7, 1, 1, 0);
            return true;
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.hasMadeChest = p_143011_1_.func_74767_n("Chest");
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_SMITH);
        }
    }

    public static class Library
    extends VillageTools.GlobalVillage {
        public Library() {
        }

        public Library(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_LIBRARY, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(7);
        }

        public static Library buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)9, (int)7, (int)coordBaseMode);
            return Library.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Library(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int z;
            for (int x = 2; x < 7; ++x) {
                for (int z2 = 0; z2 < 5; ++z2) {
                    this.func_74871_b(world, x, 1, z2, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, x, -1, z2, structureBoundingBox);
                }
            }
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 2; ++l) {
                    this.func_74871_b(world, l, 1, k + 1, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, l, -1, k + 1, structureBoundingBox);
                    this.func_74871_b(world, 8 - l, 1, k + 1, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, 8 - l, -1, k + 1, structureBoundingBox);
                    this.func_74871_b(world, k + 3, 1, l + 5, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, k + 3, -1, l + 5, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 2, 0, 0, 2, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 0, 6, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 2, 0, 4, 2, 4, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 4, 6, 4, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 1, 0, 3, 1, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 3, 0, 3, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 8, 0, 1, 8, 3, 1, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 8, 0, 3, 8, 3, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 6, 3, 3, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 5, 0, 6, 5, 3, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 1, 3, 1, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 3, 1, 3, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 1, 7, 3, 1, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 3, 7, 3, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 5, 3, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 5, 0, 5, 5, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 0, 5, 3, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 0, 0, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 0, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 1, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 7, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 8, 4, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][1], 8, 0, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 0, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 3, 4, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 4, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5, 4, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 3, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 5, 4, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 4, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 4, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 0, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 3, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 4, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 5, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 3, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 4, 5, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 5, 4, structureBoundingBox);
            for (z = 0; z < 5; ++z) {
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 2, 5, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 3, 6, z, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 4, 7, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, DirectionTools.log[this.field_74885_f][0], 4, 6, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 5, 6, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 6, 5, z, structureBoundingBox);
                if (z != 2) {
                    this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 1, 4, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 7, 4, z, structureBoundingBox);
                } else {
                    this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 1, 5, z, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 7, 5, z, structureBoundingBox);
                }
                if (z == 0 || z == 4) continue;
                this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 5, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 0, 5, 5, z, structureBoundingBox);
            }
            while (z < 7) {
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 2, 3, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 3, 4, z, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 4, 5, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 5, 4, z, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 6, 3, z, structureBoundingBox);
                ++z;
            }
            for (int x = 0; x < 2; ++x) {
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], x, 3, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], x, 4, 1, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, x, 5, 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], x, 4, 3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], x, 3, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], 8 - x, 3, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][3], 8 - x, 4, 1, structureBoundingBox);
                this.func_151550_a(world, (Block)Blocks.field_150376_bx, 0, 8 - x, 5, 2, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 8 - x, 4, 3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 8 - x, 3, 4, structureBoundingBox);
            }
            this.func_151549_a(world, structureBoundingBox, 2, 0, 1, 6, 0, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 4, 5, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 0, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 7, 0, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 4, 0, 5, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 1, 2, 3, 1, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 1, 6, 3, 1, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 3, 2, 3, 3, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 6, 1, 3, 6, 3, 3, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 4, 3, 3, 4, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 4, 5, 3, 4, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 2, 4, 1, 2, 4, 3, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 6, 4, 1, 6, 4, 3, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(world, structureBoundingBox, 0, 1, 2, 0, 3, 2, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 2, 8, 3, 2, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 6, 4, 3, 6, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151550_a(world, Blocks.field_150478_aa, DirectionTools.torch[this.field_74885_f][2], 4, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, DirectionTools.torch[this.field_74885_f][3], 4, 5, 3, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 4, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(world, 4, 0, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(world, 2, -1, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 4, 0, -1, structureBoundingBox);
            }
            this.spawnEntity(world, structureBoundingBox, 4, 1, 2, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_LIBRARIAN);
        }
    }

    public static class Butchery
    extends VillageTools.GlobalVillage {
        public Butchery() {
        }

        public Butchery(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_BUTCHERY, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(5);
        }

        public static Butchery buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (int)coordBaseMode);
            return Butchery.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Butchery(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int l;
            int k;
            this.func_151549_a(world, structureBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int x = 2; x < 9; ++x) {
                for (int z = 6; z < 11; ++z) {
                    this.func_151554_b(world, Blocks.field_150346_d, 0, x, -1, z, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 2, 0, 6, 8, 0, 10, (Block)Blocks.field_150349_c, (Block)Blocks.field_150349_c, false);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 6, 0, 6, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 2, 1, 6, 2, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 8, 1, 6, 8, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 10, 7, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 0, 7, 1, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 5, 7, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 2, 0, 7, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 2, 5, 7, 3, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 4, 1, 7, 4, 1, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 4, 4, 7, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 1, 5, 2, 7, 5, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(world, structureBoundingBox, 0, 4, 1, 0, 5, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 8, 4, 1, 8, 5, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            int i = this.func_151555_a(Blocks.field_150476_ad, 3);
            int j = this.func_151555_a(Blocks.field_150476_ad, 2);
            for (k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    if (k == -1 && (l == 0 || l == 8)) continue;
                    this.func_151550_a(world, Blocks.field_150476_ad, i, l, 4 + k, k, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150476_ad, j, l, 4 + k, 5 - k, structureBoundingBox);
                }
            }
            for (k = 0; k < 5; ++k) {
                this.func_151550_a(world, Blocks.field_150364_r, 0, 0, k, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 0, k, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 8, k, 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 8, k, 4, structureBoundingBox);
                if (k >= 4) continue;
                this.func_151550_a(world, Blocks.field_150364_r, 0, 1, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 1, k, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 7, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150364_r, 0, 7, k, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150350_a, 0, 0, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150350_a, 0, 0, k, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150350_a, 0, 8, k, 0, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150350_a, 0, 8, k, 5, structureBoundingBox);
            }
            this.func_151550_a(world, (Block)Blocks.field_150349_c, 0, 8, 0, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 3, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 5, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 1, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 2, 2, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150344_f, 0, 1, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 3), 2, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 1), 1, 1, 3, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 5, 0, 1, 7, 0, 3, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 6, 1, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 6, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 1, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(world, 2, 0, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(world, 2, -1, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 1, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 2, 5, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 4, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 6, 1, 5, this.func_151555_a(Blocks.field_150466_ao, 1));
            for (k = 0; k < 5; ++k) {
                for (l = 0; l < 9; ++l) {
                    this.func_74871_b(world, l, 7, k, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, l, -1, k, structureBoundingBox);
                }
            }
            this.spawnEntity(world, structureBoundingBox, 5, 1, 8, 0);
            this.spawnEntity(world, structureBoundingBox, 5, 1, 8, 1);
            this.spawnEntity(world, structureBoundingBox, 5, 1, 8, 1);
            this.spawnEntity(world, structureBoundingBox, 5, 1, 8, 1);
            this.spawnEntity(world, structureBoundingBox, 5, 1, 8, 1);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            switch (choice) {
                case 0: {
                    return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_BUTCHER);
                }
                case 1: {
                    return new EntityPig(world);
                }
            }
            return null;
        }
    }

    public static class Field2
    extends VillageTools.GlobalField {
        public Field2() {
        }

        public Field2(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_FIELD2, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static Field2 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (int)coordBaseMode);
            return Field2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Field2(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        protected Block getCropType(Random random) {
            switch (random.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 0, 5, 0, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 8, 5, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (i = 1; i <= 7; ++i) {
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 1, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 2, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 4, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 5, 1, i, structureBoundingBox);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.func_74871_b(world, j, 4, i, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150346_d, 0, j, -1, i, structureBoundingBox);
                }
            }
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_FARMER);
        }
    }

    public static class Field1
    extends VillageTools.GlobalField {
        public Field1() {
        }

        public Field1(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_FIELD1, startPiece, componentType, random, structureBoundingBox, coordBaseMode);
            this.setOffset(3);
        }

        public static Field1 buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (int)coordBaseMode);
            return Field1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Field1(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        protected Block getCropType(Random random) {
            switch (random.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            this.func_151549_a(world, structureBoundingBox, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 12, 0, 0, 12, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 0, 11, 0, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 8, 11, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(world, structureBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(world, structureBoundingBox, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (i = 1; i <= 7; ++i) {
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 1, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeA, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 2, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 4, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeB, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 5, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeC, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 7, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeC, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 8, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeD, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 10, 1, i, structureBoundingBox);
                this.func_151550_a(world, this.cropTypeD, MathHelper.func_76136_a((Random)random, (int)2, (int)7), 11, 1, i, structureBoundingBox);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 13; ++j) {
                    this.func_74871_b(world, j, 4, i, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150346_d, 0, j, -1, i, structureBoundingBox);
                }
            }
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 0);
            this.spawnEntity(world, structureBoundingBox, 4, 2, 4, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_FARMER);
        }
    }

    public static class Church
    extends VillageTools.GlobalVillage {
        public Church() {
        }

        public Church(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(SupplierVillage.EnumPiece.SETTLED_CHURCH, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.setOffset(10);
        }

        public static Church buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (int)coordBaseMode);
            return Church.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new Church(villagePiece, p5, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean build(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int k;
            int j;
            for (j = 0; j < 9; ++j) {
                for (k = 0; k < 5; ++k) {
                    this.func_74871_b(world, k, 0, j, structureBoundingBox);
                    this.func_151554_b(world, Blocks.field_150347_e, 0, k, -1, j, structureBoundingBox);
                }
            }
            this.func_151549_a(world, structureBoundingBox, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 0, 3, 0, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 0, 3, 10, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 1, 0, 10, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 1, 4, 10, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 0, 0, 4, 0, 4, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 4, 0, 4, 4, 4, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 8, 3, 4, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 5, 4, 3, 10, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 5, 5, 3, 5, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(world, structureBoundingBox, 1, 9, 1, 3, 9, 3, Blocks.field_150348_b, Blocks.field_150348_b, false);
            this.func_151556_a(world, structureBoundingBox, 1, 4, 1, 3, 4, 3, (Block)Blocks.field_150376_bx, 8, (Block)Blocks.field_150376_bx, 8, false);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 0, 11, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 4, 11, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 2, 11, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150347_e, 0, 2, 11, 4, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 3, 0, 7, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 6, 3, 1, 7, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 2, 1, 6, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 2, 2, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 6, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 7, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 6, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 7, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 6, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 7, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 6, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 7, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 3, 6, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 3, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, DirectionTools.torch[this.field_74885_f][3], 1, 3, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, DirectionTools.torch[this.field_74885_f][3], 3, 3, 7, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, DirectionTools.torch[this.field_74885_f][2], 2, 3, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 8, 1, 5, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150478_aa, 5, 1, 6, 1, structureBoundingBox);
            int i = this.func_151555_a(Blocks.field_150468_ap, 4);
            for (j = 1; j <= 9; ++j) {
                this.func_151550_a(world, Blocks.field_150468_ap, i, 3, j, 1, structureBoundingBox);
            }
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 1, 0, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 0, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 2, 0, 0, structureBoundingBox);
            this.func_74881_a(world, structureBoundingBox, random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(world, 2, 0, -1, structureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(world, 2, -1, -1, structureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, structureBoundingBox);
            }
            this.func_151556_a(world, structureBoundingBox, 2, 1, 1, 2, 1, 5, Blocks.field_150404_cg, 14, Blocks.field_150404_cg, 14, false);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 1, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 3, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 1, 1, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 3, 1, 4, structureBoundingBox);
            for (k = 0; k < 4; ++k) {
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][0], 0, 5, 4 + k, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][1], 4, 5, 4 + k, structureBoundingBox);
                if (k >= 3) continue;
                this.func_151550_a(world, Blocks.field_150476_ad, DirectionTools.stair[this.field_74885_f][2], 1 + k, 5, 8, structureBoundingBox);
            }
            this.spawnEntity(world, structureBoundingBox, 2, 1, 2, 0);
            return true;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return new EntitySettled(world, SupplierTribe.EnumVillager.SETTLED_PRIEST);
        }
    }

    public static class Path
    extends VillageTools.GlobalPath {
        public Path() {
        }

        public Path(VillageTools.GlobalStart p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(instance, p_i2105_1_, p_i2105_2_, p_i2105_3_, p_i2105_4_, p_i2105_5_);
        }

        @Override
        protected VillageTools.BlockData getPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150351_n, 0);
        }

        @Override
        protected VillageTools.BlockData getPathBridge(Random random) {
            return new VillageTools.BlockData((Block)Blocks.field_150376_bx, 1);
        }

        @Override
        protected VillageTools.BlockData getUnderPathBlock(Random random) {
            return new VillageTools.BlockData(Blocks.field_150346_d, 0);
        }
    }

    public static class Start
    extends VillageTools.GlobalStart {
        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(instance, p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
            if (super.addComponentParts(world, rand, structureBoundingBox, 3)) {
                return true;
            }
            this.func_151549_a(world, structureBoundingBox, 1, 0, 1, 4, 12, 4, Blocks.field_150347_e, (Block)Blocks.field_150358_i, false);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 12, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 12, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 12, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150350_a, 0, 3, 12, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 13, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 14, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 13, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 14, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 13, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 14, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 13, 4, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 14, 4, structureBoundingBox);
            this.func_151549_a(world, structureBoundingBox, 1, 15, 1, 4, 15, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151556_a(world, structureBoundingBox, 2, 15, 2, 3, 15, 3, (Block)Blocks.field_150376_bx, 0, (Block)Blocks.field_150376_bx, 0, false);
            for (int x = 0; x <= 5; ++x) {
                for (int z = 0; z <= 5; ++z) {
                    if (x != 0 && x != 5 && z != 0 && z != 5) continue;
                    this.func_151550_a(world, Blocks.field_150351_n, 0, x, 11, z, structureBoundingBox);
                    this.func_74871_b(world, x, 12, z, structureBoundingBox);
                }
            }
            return true;
        }
    }
}

