/*
 * Decompiled with CFR 0.152.
 */
package diversity.village;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.common.registry.VillagerRegistry;
import diversity.suppliers.SupplierVillage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public abstract class VillageTools {
    public final SupplierVillage.EnumVillage village;

    VillageTools(SupplierVillage.EnumVillage village) {
        this.village = village;
    }

    private void getStructureList(ArrayList arraylist, Random rand) {
        for (SupplierVillage.EnumPiece piece : this.village.pieces) {
            arraylist.add(piece.handler.getVillagePieceWeight(rand, 1));
        }
    }

    public abstract GlobalStart getStart(WorldChunkManager var1, int var2, Random var3, int var4, int var5, List var6, int var7);

    protected abstract GlobalTorch getTorch(GlobalStart var1, int var2, Random var3, StructureBoundingBox var4, int var5);

    protected abstract GlobalPath getPath(GlobalStart var1, int var2, Random var3, StructureBoundingBox var4, int var5);

    protected static Point getSpherePoint(int radius, int u, int v, double offset) {
        double theta = Math.PI * 2 * (double)u / 360.0;
        double phi = Math.PI * (double)v / 360.0;
        int x = (int)((double)radius * Math.sin(phi) * Math.cos(theta));
        int z = (int)((double)radius * Math.sin(phi) * Math.sin(theta));
        int y = (int)((double)radius * Math.cos(phi) + offset);
        return new Point(x, y, z);
    }

    public static StructureComponent getNextComponentVillagePath(VillageTools villageInstance, GlobalStart startPiece, List componentList, Random random, int x, int y, int z, int coordBaseMode, int componentType) {
        if (componentType > 3 + startPiece.field_74928_c) {
            return null;
        }
        if (Math.abs(x - startPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(z - startPiece.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = GlobalPath.func_74933_a((StructureVillagePieces.Start)startPiece, (List)componentList, (Random)random, (int)x, (int)y, (int)z, (int)coordBaseMode);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                int j2;
                GlobalPath path = villageInstance.getPath(startPiece, componentType, random, structureboundingbox, coordBaseMode);
                int j1 = (path.func_74874_b().field_78897_a + path.func_74874_b().field_78893_d) / 2;
                int k1 = (path.func_74874_b().field_78896_c + path.func_74874_b().field_78892_f) / 2;
                int l1 = path.func_74874_b().field_78893_d - path.func_74874_b().field_78897_a;
                int i2 = path.func_74874_b().field_78892_f - path.func_74874_b().field_78896_c;
                int n = j2 = l1 > i2 ? l1 : i2;
                if (startPiece.func_74925_d().func_76940_a(j1, k1, j2 / 2 + 4, MapGenVillage.field_75055_e)) {
                    componentList.add(path);
                    startPiece.field_74930_j.add(path);
                    return path;
                }
            }
            return null;
        }
        return null;
    }

    private static StructureComponent getNextVillageStructureComponent(VillageTools village, GlobalStart startPiece, List componentList, Random random, int p_75077_3_, int p_75077_4_, int p_75077_5_, int p_75077_6_, int p_75077_7_) {
        if (p_75077_7_ > 50) {
            return null;
        }
        if (Math.abs(p_75077_3_ - startPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(p_75077_5_ - startPiece.func_74874_b().field_78896_c) <= 112) {
            GlobalVillage piece = VillageTools.getNextVillageComponent(village, startPiece, componentList, random, p_75077_3_, p_75077_4_, p_75077_5_, p_75077_6_, p_75077_7_ + 1);
            if (piece != null) {
                componentList.add(piece);
                startPiece.field_74932_i.add(piece);
                return piece;
            }
            return null;
        }
        return null;
    }

    public List getStructureVillageWeightedPieceList(Random rand) {
        ArrayList arraylist = new ArrayList();
        this.getStructureList(arraylist, rand);
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            if (((StructureVillagePieces.PieceWeight)iterator.next()).field_75087_d != 0) continue;
            iterator.remove();
        }
        return arraylist;
    }

    private static GlobalVillage getNextVillageComponent(VillageTools village, GlobalStart startPiece, List p_75081_1_, Random random, int p_75081_3_, int p_75081_4_, int p_75081_5_, int coordBaseMode, int p_75081_7_) {
        int villagePieceWeight = VillageTools.getVillagePieceWeight(startPiece.field_74931_h);
        if (villagePieceWeight <= 0) {
            return null;
        }
        int k1 = 0;
        block0: while (k1 < 5) {
            ++k1;
            int l1 = random.nextInt(villagePieceWeight);
            for (StructureVillagePieces.PieceWeight pieceweight : startPiece.field_74931_h) {
                if ((l1 -= pieceweight.field_75088_b) >= 0) continue;
                if (!pieceweight.func_75085_a(p_75081_7_) || pieceweight == startPiece.field_74926_d && startPiece.field_74931_h.size() > 1) continue block0;
                GlobalVillage piece = VillageTools.getVillageComponent(startPiece, pieceweight, p_75081_1_, random, p_75081_3_, p_75081_4_, p_75081_5_, coordBaseMode, p_75081_7_);
                if (piece == null) continue;
                ++pieceweight.field_75089_c;
                startPiece.field_74926_d = pieceweight;
                if (!pieceweight.func_75086_a()) {
                    startPiece.field_74931_h.remove(pieceweight);
                }
                return piece;
            }
        }
        StructureBoundingBox structureboundingbox = GlobalTorch.getStructureBoundingBox(startPiece, p_75081_1_, random, p_75081_3_, p_75081_4_, p_75081_5_, coordBaseMode);
        if (structureboundingbox != null) {
            return village.getTorch(startPiece, p_75081_7_, random, structureboundingbox, coordBaseMode);
        }
        return null;
    }

    private static int getVillagePieceWeight(List pieceList) {
        boolean flag = false;
        int i = 0;
        for (StructureVillagePieces.PieceWeight pieceweight : pieceList) {
            if (pieceweight.field_75087_d > 0 && pieceweight.field_75089_c < pieceweight.field_75087_d) {
                flag = true;
            }
            i += pieceweight.field_75088_b;
        }
        return flag ? i : -1;
    }

    private static GlobalVillage getVillageComponent(StructureVillagePieces.Start startPiece, StructureVillagePieces.PieceWeight pieceWeight, List p_75083_2_, Random p_75083_3_, int p_75083_4_, int p_75083_5_, int p_75083_6_, int p_75083_7_, int p_75083_8_) {
        return (GlobalVillage)((Object)VillagerRegistry.getVillageComponent((StructureVillagePieces.PieceWeight)pieceWeight, (StructureVillagePieces.Start)startPiece, (List)p_75083_2_, (Random)p_75083_3_, (int)p_75083_4_, (int)p_75083_5_, (int)p_75083_6_, (int)p_75083_7_, (int)p_75083_8_));
    }

    public static abstract class GlobalField
    extends GlobalVillage {
        protected Block cropTypeA;
        protected Block cropTypeB;
        protected Block cropTypeC;
        protected Block cropTypeD;

        public GlobalField() {
        }

        public GlobalField(SupplierVillage.EnumPiece enumPiece, StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(enumPiece, startPiece, componentType, structureBoundingBox, coordBaseMode);
            this.cropTypeA = this.getCropType(random);
            this.cropTypeB = this.getCropType(random);
            this.cropTypeC = this.getCropType(random);
            this.cropTypeD = this.getCropType(random);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            p_143012_1_.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            p_143012_1_.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            p_143012_1_.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.cropTypeA = Block.func_149729_e((int)p_143011_1_.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)p_143011_1_.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)p_143011_1_.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)p_143011_1_.func_74762_e("CD"));
        }

        protected abstract Block getCropType(Random var1);
    }

    protected static class Point {
        public boolean submarine = false;
        private Point leftPoint;
        private Point rightPoint;
        private Point parentPoint;
        int x;
        int y;
        int z;

        Point(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Point(int x, int z) {
            this.x = x;
            this.z = z;
        }

        Point(int x, int z, Point parentPoint) {
            this.x = x;
            this.z = z;
            this.parentPoint = parentPoint;
        }

        int getPointDiff(Point point) {
            return point.y - this.y;
        }

        int getPointDiff(int y) {
            return y - this.y;
        }

        boolean equals(Point point) {
            return this.x == point.x && this.z == point.z;
        }

        public void set(int x, int z) {
            this.x = x;
            this.z = z;
        }

        static /* synthetic */ Point access$002(Point x0, Point x1) {
            x0.leftPoint = x1;
            return x0.leftPoint;
        }

        static /* synthetic */ Point access$102(Point x0, Point x1) {
            x0.rightPoint = x1;
            return x0.rightPoint;
        }

        static /* synthetic */ Point access$202(Point x0, Point x1) {
            x0.parentPoint = x1;
            return x0.parentPoint;
        }
    }

    public static abstract class GlobalVillage
    extends StructureVillagePieces.Village {
        private int villagersSpawned;
        protected SupplierVillage.IEnumPiece piece;
        private int offset;
        protected int darkOakStair0;
        protected int darkOakStair1;
        protected int darkOakStair2;
        protected int darkOakStair3;

        public GlobalVillage() {
        }

        protected GlobalVillage(SupplierVillage.IEnumPiece piece, StructureVillagePieces.Start startPiece, int componentType, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(startPiece, componentType);
            this.field_74885_f = coordBaseMode;
            this.field_74887_e = structureBoundingBox;
            this.piece = piece;
            int n = coordBaseMode == 0 ? 0 : (coordBaseMode == 1 ? 2 : (this.darkOakStair0 = coordBaseMode == 2 ? 0 : 2));
            int n2 = coordBaseMode == 0 ? 1 : (coordBaseMode == 1 ? 3 : (this.darkOakStair1 = coordBaseMode == 2 ? 1 : 3));
            int n3 = coordBaseMode == 0 ? 3 : (coordBaseMode == 1 ? 0 : (this.darkOakStair2 = coordBaseMode == 2 ? 2 : 1));
            this.darkOakStair3 = coordBaseMode == 0 ? 2 : (coordBaseMode == 1 ? 1 : (coordBaseMode == 2 ? 3 : 0));
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
        }

        protected void func_143011_b(NBTTagCompound tagCompound) {
            super.func_143011_b(tagCompound);
            this.villagersSpawned = tagCompound.func_74762_e("VCount");
        }

        protected void setOffset(int offset) {
            this.offset = offset;
        }

        protected void spawnEntity(World world, StructureBoundingBox structureBoundingBox, int spawnX, int spawnY, int spawnZ, int choice) {
            int z;
            int y;
            int x = this.func_74865_a(spawnX, spawnZ);
            if (!structureBoundingBox.func_78890_b(x, y = this.func_74862_a(spawnY), z = this.func_74873_b(spawnX, spawnZ))) {
                return;
            }
            EntityLiving entity = this.getNewEntity(world, choice);
            entity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entity);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(world, structureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + this.offset, 0);
            }
            this.build(world, random, structureBoundingBox);
            return true;
        }

        protected void placeBlockAtCurrentPosition(World p_151550_1_, BlockData blockData, int p_151550_4_, int p_151550_5_, int p_151550_6_, StructureBoundingBox p_151550_7_) {
            this.func_151550_a(p_151550_1_, blockData.block, blockData.metaData, p_151550_4_, p_151550_5_, p_151550_6_, p_151550_7_);
        }

        protected abstract boolean build(World var1, Random var2, StructureBoundingBox var3);

        protected abstract EntityLiving getNewEntity(World var1, int var2);
    }

    public static abstract class GlobalTorch
    extends GlobalVillage {
        public GlobalTorch() {
        }

        public GlobalTorch(SupplierVillage.EnumBasic enumPiece, StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super(enumPiece, startPiece, componentType, structureBoundingBox, coordBaseMode);
        }

        public static StructureBoundingBox getStructureBoundingBox(StructureVillagePieces.Start startPiece, List list, Random random, int coordX, int coordY, int coordZ, int p_74904_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)coordX, (int)coordY, (int)coordZ, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (int)p_74904_6_);
            return StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        protected EntityLiving getNewEntity(World world, int choice) {
            return null;
        }
    }

    public static abstract class GlobalPath
    extends StructureVillagePieces.Path {
        private int averageGroundLevel;
        private StructureVillagePieces.Start startPiece;
        private VillageTools village;
        Table<Integer, Integer, Integer> points = HashBasedTable.create();
        private int recursiveCounter;

        public GlobalPath() {
        }

        public GlobalPath(VillageTools village, GlobalStart startPiece, int p_i2105_2_, Random random, StructureBoundingBox structureBoundingBox, int coordBaseMode) {
            super((StructureVillagePieces.Start)startPiece, p_i2105_2_, random, structureBoundingBox, coordBaseMode);
            this.startPiece = startPiece;
            this.averageGroundLevel = Math.max(structureBoundingBox.func_78883_b(), structureBoundingBox.func_78880_d());
            this.village = village;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
                    if (!structureBoundingBox.func_78890_b(x, 64, z)) continue;
                    int y = world.func_72825_h(x, z) - 1;
                    this.points.put((Object)x, (Object)z, (Object)y);
                    BlockData blockData = this.getPathBlock(random);
                    world.func_147465_d(x, y, z, blockData.block, blockData.metaData, 2);
                }
            }
            return true;
        }

        private void buildBridge(World world, Random random, StructureBoundingBox structureBoundingBox, Point point, int counter, int bridgeSize) {
            this.func_74871_b(world, point.x, 65, point.z, structureBoundingBox);
            this.func_74871_b(world, ((Point)point).leftPoint.x, 65, ((Point)point).leftPoint.z, structureBoundingBox);
            this.func_74871_b(world, ((Point)point).rightPoint.x, 65, ((Point)point).rightPoint.z, structureBoundingBox);
            if (counter == 0 || counter == bridgeSize) {
                world.func_147465_d(((Point)point).leftPoint.x, 65, ((Point)point).leftPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 65, ((Point)point).rightPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(point.x, 65, point.z, (Block)Blocks.field_150376_bx, 0, 2);
            } else if ((counter == 2 || counter == bridgeSize - 1) && bridgeSize - 1 > 2) {
                world.func_147465_d(((Point)point).leftPoint.x, 65, ((Point)point).leftPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 65, ((Point)point).rightPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).leftPoint.x, 66, ((Point)point).leftPoint.z, (Block)Blocks.field_150333_U, 3, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 66, ((Point)point).rightPoint.z, (Block)Blocks.field_150333_U, 3, 2);
                world.func_147465_d(point.x, 65, point.z, Blocks.field_150344_f, 0, 2);
            } else if ((counter == 3 || counter == bridgeSize - 2) && bridgeSize - 2 > 3) {
                world.func_147465_d(((Point)point).leftPoint.x, 66, ((Point)point).leftPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 66, ((Point)point).rightPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(point.x, 66, point.z, (Block)Blocks.field_150376_bx, 0, 2);
            } else {
                world.func_147465_d(((Point)point).leftPoint.x, 66, ((Point)point).leftPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 66, ((Point)point).rightPoint.z, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(((Point)point).leftPoint.x, 67, ((Point)point).leftPoint.z, (Block)Blocks.field_150333_U, 3, 2);
                world.func_147465_d(((Point)point).rightPoint.x, 67, ((Point)point).rightPoint.z, (Block)Blocks.field_150333_U, 3, 2);
                world.func_147465_d(point.x, 66, point.z, (Block)Blocks.field_150376_bx, 0, 2);
            }
        }

        private void placePoint(World world, Random random, StructureBoundingBox structureBoundingBox, Point point) {
            if (point.y > 63) {
                BlockData blockData = this.getUnderPathBlock(random);
                this.func_151554_b(world, blockData.block, blockData.metaData, point.x, point.y - 1, point.z, structureBoundingBox);
                blockData = this.getPathBlock(random);
                world.func_147465_d(point.x, point.y, point.z, blockData.block, blockData.metaData, 2);
                this.func_74871_b(world, point.x, point.y + 1, point.z, structureBoundingBox);
            } else {
                point.submarine = true;
            }
        }

        private void evaluatePointHeight(Point point) {
            int maxHeight = ((Point)point).parentPoint.y + 1;
            int minHeight = ((Point)point).parentPoint.y - 1;
            if (point.leftPoint != null) {
                if (((Point)point).leftPoint.y <= minHeight) {
                    maxHeight = ((Point)point).parentPoint.y;
                } else if (((Point)point).leftPoint.y >= maxHeight) {
                    minHeight = ((Point)point).parentPoint.y;
                }
            }
            if (point.rightPoint != null) {
                if (((Point)point).rightPoint.y <= minHeight) {
                    maxHeight = ((Point)point).parentPoint.y;
                } else if (((Point)point).rightPoint.y >= maxHeight) {
                    minHeight = ((Point)point).parentPoint.y;
                }
            }
            int totalMaxHeigh = (point.y == maxHeight ? 1 : 0) + (point.leftPoint != null ? (((Point)point).leftPoint.y == maxHeight ? 1 : 0) : 0) + (point.rightPoint != null ? (((Point)point).rightPoint.y == maxHeight ? 1 : 0) : 0);
            int totalMinHeight = (point.y == minHeight ? 1 : 0) + (point.leftPoint != null ? (((Point)point).leftPoint.y == minHeight ? 1 : 0) : 0) + (point.rightPoint != null ? (((Point)point).rightPoint.y == minHeight ? 1 : 0) : 0);
            point.y = totalMaxHeigh >= 2 ? maxHeight : (totalMinHeight >= 2 ? minHeight : ((Point)point).parentPoint.y);
        }

        protected abstract BlockData getPathBridge(Random var1);

        protected abstract BlockData getPathBlock(Random var1);

        protected abstract BlockData getUnderPathBlock(Random var1);

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("Length", this.averageGroundLevel);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.averageGroundLevel = p_143011_1_.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent startPiece, List componentList, Random random) {
            StructureComponent piece;
            int i;
            boolean flag = false;
            for (i = random.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + random.nextInt(5)) {
                piece = this.getNextComponentNN((GlobalStart)startPiece, componentList, random, 0, i);
                if (piece == null) continue;
                i += Math.max(piece.func_74874_b().func_78883_b(), piece.func_74874_b().func_78880_d());
                flag = true;
            }
            for (i = random.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + random.nextInt(5)) {
                piece = this.getNextComponentPP((GlobalStart)startPiece, componentList, random, 0, i);
                if (piece == null) continue;
                i += Math.max(piece.func_74874_b().func_78883_b(), piece.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && random.nextInt(3) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 1, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                    }
                }
            }
            if (flag && random.nextInt(3) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 3, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 3, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                    }
                }
            }
        }

        protected StructureComponent getNextComponentNN(GlobalStart startPiece, List componentList, Random random, int p_74891_4_, int p_74891_5_) {
            switch (this.field_74885_f) {
                case 0: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, 1, this.func_74877_c());
                }
                case 1: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, 1, this.func_74877_c());
                }
                case 3: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(GlobalStart startPiece, List componentList, Random random, int p_74894_4_, int p_74894_5_) {
            switch (this.field_74885_f) {
                case 0: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, 3, this.func_74877_c());
                }
                case 1: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, 3, this.func_74877_c());
                }
                case 3: {
                    return VillageTools.getNextVillageStructureComponent(this.village, startPiece, componentList, random, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }
    }

    public static abstract class GlobalStart
    extends StructureVillagePieces.Start {
        private VillageTools village;

        public GlobalStart() {
        }

        public GlobalStart(VillageTools village, WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(p_i2104_1_, p_i2104_2_, p_i2104_3_, p_i2104_4_, p_i2104_5_, p_i2104_6_, p_i2104_7_);
            this.village = village;
        }

        public void func_74861_a(StructureComponent startPiece, List componentList, Random random) {
            VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 1, this.func_74877_c());
            VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 3, this.func_74877_c());
            VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
            VillageTools.getNextComponentVillagePath(this.village, (GlobalStart)startPiece, componentList, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
        }

        public boolean addComponentParts(World world, Random random, StructureBoundingBox structureBoundingBox, int offset) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(world, structureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + offset, 0);
            }
            return false;
        }
    }

    public static class BlockData {
        protected Block block;
        protected int metaData;

        public BlockData(Block block, int metaData) {
            this.block = block;
            this.metaData = metaData;
        }
    }
}

