/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.svg;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;

public class SVGGlyph
extends Pane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-svg-glyph";
    private final int glyphId;
    private final String name;
    private static final int DEFAULT_PREF_SIZE = 64;
    private double widthHeightRatio = 1.0;
    private ObjectProperty<Paint> fill = new SimpleObjectProperty();

    public SVGGlyph(int glyphId, String name, String svgPathContent, Paint fill) {
        this.glyphId = glyphId;
        this.name = name;
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.fill.addListener((observable, oldValue, newValue) -> this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newValue, null, null)})));
        SVGPath shape = new SVGPath();
        shape.setContent(svgPathContent);
        this.setShape((Shape)shape);
        this.setFill(fill);
        this.widthHeightRatio = shape.prefWidth(-1.0) / shape.prefHeight(-1.0);
        this.setPrefSize(64.0, 64.0);
    }

    public int getGlyphId() {
        return this.glyphId;
    }

    public String getName() {
        return this.name;
    }

    public void setFill(Paint fill) {
        this.fill.setValue((Object)fill);
    }

    public ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public Paint getFill() {
        return (Paint)this.fill.getValue();
    }

    public void setSize(double width, double height) {
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void setSizeRatio(double size) {
        double width = this.widthHeightRatio * size;
        double height = size / this.widthHeightRatio;
        if (width <= size) {
            this.setSize(width, size);
        } else if (height <= size) {
            this.setSize(size, height);
        } else {
            this.setSize(size, size);
        }
    }
}

