/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.SelfDependencyPatcher;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("http.agent", "HMCL/" + Metadata.VERSION);
        System.setProperty("javafx.autoproxy.disable", "true");
        System.setProperty("jdk.gtk.version", "2");
        Main.initLookAndFeel();
        Main.checkDirectoryPath();
        Lang.thread(Main::fixLetsEncrypt, "CA Certificate Check", true);
        Logging.start(Metadata.HMCL_DIRECTORY.resolve("logs"));
        Main.checkJavaFX();
        Launcher.main(args);
    }

    private static void initLookAndFeel() {
        if (System.getProperty("swing.defaultlaf") == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void checkDirectoryPath() {
        String currentDirectory = new File("").getAbsolutePath();
        if (currentDirectory.contains("!")) {
            Main.showErrorAndExit("Exclamation mark(!) is not allowed in the path where HMCL is in.\nThe path is " + currentDirectory);
        }
    }

    private static void checkJavaFX() {
        try {
            SelfDependencyPatcher.patch();
        }
        catch (SelfDependencyPatcher.PatchException e) {
            Logging.LOG.log(Level.SEVERE, "unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.missing"));
        }
        catch (SelfDependencyPatcher.IncompatibleVersionException e) {
            Logging.LOG.log(Level.SEVERE, "unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.incompatible"));
        }
        catch (CancellationException e) {
            Logging.LOG.log(Level.SEVERE, "User cancels downloading JavaFX", e);
            System.exit(0);
        }
    }

    static void showErrorAndExit(String message) {
        System.err.println(message);
        System.err.println("A fatal error has occurred, forcibly exiting.");
        JOptionPane.showMessageDialog(null, message, "Error", 0);
        System.exit(1);
    }

    static void showWarningAndContinue(String message) {
        System.err.println(message);
        System.err.println("Potential issues have been detected.");
        JOptionPane.showMessageDialog(null, message, "Warning", 2);
    }

    static void fixLetsEncrypt() {
        try {
            KeyStore defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream ksStream = Files.newInputStream(ksPath, new OpenOption[0]);){
                defaultKeyStore.load(ksStream, "changeit".toCharArray());
            }
            KeyStore letsEncryptKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream letsEncryptFile = Main.class.getResourceAsStream("/assets/lekeystore.jks");
            Iterator<String> iterator = null;
            try {
                letsEncryptKeyStore.load(letsEncryptFile, "supersecretpassword".toCharArray());
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (letsEncryptFile != null) {
                    if (iterator != null) {
                        try {
                            letsEncryptFile.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        letsEncryptFile.close();
                    }
                }
            }
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            merged.load(null, new char[0]);
            for (String alias : Collections.list(letsEncryptKeyStore.aliases())) {
                merged.setCertificateEntry(alias, letsEncryptKeyStore.getCertificate(alias));
            }
            for (String alias : Collections.list(defaultKeyStore.aliases())) {
                merged.setCertificateEntry(alias, defaultKeyStore.getCertificate(alias));
            }
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(merged);
            SSLContext tls = SSLContext.getInstance("TLS");
            tls.init(null, instance.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
            Logging.LOG.info("Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logging.LOG.log(Level.SEVERE, "Failed to load lets encrypt certificate. Expect problems", e);
        }
    }
}

