/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.yggdrasil;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.ClassicAccount;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.NoCharacterException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilSession;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class YggdrasilAccount
extends ClassicAccount {
    protected final YggdrasilService service;
    protected final UUID characterUUID;
    protected final String username;
    private boolean authenticated = false;
    private YggdrasilSession session;
    private ObjectBinding<Optional<CompleteGameProfile>> profilePropertiesBinding;

    protected YggdrasilAccount(YggdrasilService service, String username, YggdrasilSession session) {
        this.service = Objects.requireNonNull(service);
        this.username = Objects.requireNonNull(username);
        this.characterUUID = Objects.requireNonNull(session.getSelectedProfile().getId());
        this.session = Objects.requireNonNull(session);
        this.addProfilePropertiesListener();
    }

    protected YggdrasilAccount(YggdrasilService service, String username, String password, CharacterSelector selector) throws AuthenticationException {
        this.service = Objects.requireNonNull(service);
        this.username = Objects.requireNonNull(username);
        YggdrasilSession acquiredSession = service.authenticate(username, password, YggdrasilAccount.randomClientToken());
        if (acquiredSession.getSelectedProfile() == null) {
            if (acquiredSession.getAvailableProfiles() == null || acquiredSession.getAvailableProfiles().isEmpty()) {
                throw new NoCharacterException();
            }
            GameProfile characterToSelect = selector.select(service, acquiredSession.getAvailableProfiles());
            this.session = service.refresh(acquiredSession.getAccessToken(), acquiredSession.getClientToken(), characterToSelect);
        } else {
            this.session = acquiredSession;
        }
        this.characterUUID = this.session.getSelectedProfile().getId();
        this.authenticated = true;
        this.addProfilePropertiesListener();
    }

    private void addProfilePropertiesListener() {
        this.profilePropertiesBinding = this.service.getProfileRepository().binding(this.characterUUID, true);
        this.profilePropertiesBinding.addListener((a, b, c) -> this.invalidate());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getCharacter() {
        return this.session.getSelectedProfile().getName();
    }

    @Override
    public UUID getUUID() {
        return this.session.getSelectedProfile().getId();
    }

    @Override
    public synchronized AuthInfo logIn() throws AuthenticationException {
        if (!this.authenticated) {
            if (this.service.validate(this.session.getAccessToken(), this.session.getClientToken())) {
                this.authenticated = true;
            } else {
                YggdrasilSession acquiredSession;
                try {
                    acquiredSession = this.service.refresh(this.session.getAccessToken(), this.session.getClientToken(), null);
                }
                catch (RemoteAuthenticationException e) {
                    if ("ForbiddenOperationException".equals(e.getRemoteName())) {
                        throw new CredentialExpiredException(e);
                    }
                    throw e;
                }
                if (acquiredSession.getSelectedProfile() == null || !acquiredSession.getSelectedProfile().getId().equals(this.characterUUID)) {
                    throw new ServerResponseMalformedException("Selected profile changed");
                }
                this.session = acquiredSession;
                this.authenticated = true;
                this.invalidate();
            }
        }
        return this.session.toAuthInfo();
    }

    @Override
    public synchronized AuthInfo logInWithPassword(String password) throws AuthenticationException {
        YggdrasilSession acquiredSession = this.service.authenticate(this.username, password, YggdrasilAccount.randomClientToken());
        if (acquiredSession.getSelectedProfile() == null) {
            if (acquiredSession.getAvailableProfiles() == null || acquiredSession.getAvailableProfiles().isEmpty()) {
                throw new CharacterDeletedException();
            }
            GameProfile characterToSelect = acquiredSession.getAvailableProfiles().stream().filter(charatcer -> charatcer.getId().equals(this.characterUUID)).findFirst().orElseThrow(CharacterDeletedException::new);
            this.session = this.service.refresh(acquiredSession.getAccessToken(), acquiredSession.getClientToken(), characterToSelect);
        } else {
            if (!acquiredSession.getSelectedProfile().getId().equals(this.characterUUID)) {
                throw new CharacterDeletedException();
            }
            this.session = acquiredSession;
        }
        this.authenticated = true;
        this.invalidate();
        return this.session.toAuthInfo();
    }

    @Override
    public Optional<AuthInfo> playOffline() {
        return Optional.of(this.session.toAuthInfo());
    }

    @Override
    public Map<Object, Object> toStorage() {
        HashMap<Object, Object> storage = new HashMap<Object, Object>();
        storage.put("username", this.username);
        storage.putAll(this.session.toStorage());
        this.service.getProfileRepository().getImmediately(this.characterUUID).ifPresent(profile -> storage.put("profileProperties", profile.getProperties()));
        return storage;
    }

    public YggdrasilService getYggdrasilService() {
        return this.service;
    }

    @Override
    public void clearCache() {
        this.authenticated = false;
        this.service.getProfileRepository().invalidate(this.characterUUID);
    }

    @Override
    public ObjectBinding<Optional<Map<TextureType, Texture>>> getTextures() {
        return BindingMapping.of(this.service.getProfileRepository().binding(this.getUUID())).map(profile -> profile.flatMap(it -> {
            try {
                return YggdrasilService.getTextures(it);
            }
            catch (ServerResponseMalformedException e) {
                Logging.LOG.log(Level.WARNING, "Failed to parse texture payload", e);
                return Optional.empty();
            }
        }));
    }

    public void uploadSkin(String model, Path file) throws AuthenticationException, UnsupportedOperationException {
        this.service.uploadSkin(this.characterUUID, this.session.getAccessToken(), model, file);
    }

    private static String randomClientToken() {
        return UUIDTypeAdapter.fromUUID(UUID.randomUUID());
    }

    @Override
    public String toString() {
        return "YggdrasilAccount[uuid=" + this.characterUUID + ", username=" + this.username + "]";
    }

    public int hashCode() {
        return this.characterUUID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != YggdrasilAccount.class) {
            return false;
        }
        YggdrasilAccount another = (YggdrasilAccount)obj;
        return this.characterUUID.equals(another.characterUUID);
    }
}

