/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.countly;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class CrashReport {
    private final Thread thread;
    private final Throwable throwable;
    private final String stackTrace;
    private boolean nonFatal;
    private static final Long BYTES_IN_MB = 0x100000L;

    public CrashReport(Thread thread, Throwable throwable) {
        this.thread = thread;
        this.throwable = throwable;
        this.stackTrace = StringUtils.getStackTrace(throwable);
        this.nonFatal = false;
    }

    public CrashReport setNonFatal() {
        this.nonFatal = true;
        return this;
    }

    public boolean shouldBeReport() {
        return this.stackTrace.contains("org.jackhuang");
    }

    public Map<String, Object> getMetrics(long runningTime) {
        return Lang.mapOf(Pair.pair("_run", runningTime), Pair.pair("_app_version", Metadata.VERSION), Pair.pair("_os", OperatingSystem.SYSTEM_NAME), Pair.pair("_os_version", OperatingSystem.SYSTEM_VERSION), Pair.pair("_disk_current", CrashReport.getDiskAvailable()), Pair.pair("_disk_total", CrashReport.getDiskTotal()), Pair.pair("_ram_current", CrashReport.getMemoryAvailable()), Pair.pair("_ram_total", Runtime.getRuntime().maxMemory() / BYTES_IN_MB), Pair.pair("_error", this.stackTrace), Pair.pair("_logs", Logging.getLogs()), Pair.pair("_name", this.throwable.getLocalizedMessage()), Pair.pair("_nonfatal", this.nonFatal));
    }

    public String getDisplayText() {
        return "---- Hello Minecraft! Crash Report ----\n  Version: " + Metadata.VERSION + "\n  Time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\n  Thread: " + this.thread + "\n\n  Content: \n    " + this.stackTrace + "\n\n-- System Details --\n  Operating System: " + OperatingSystem.SYSTEM_NAME + ' ' + OperatingSystem.SYSTEM_VERSION + "\n  System Architecture: " + Architecture.SYSTEM_ARCH_NAME + "\n  Java Architecture: " + Architecture.CURRENT_ARCH_NAME + "\n  Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "\n  Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor") + "\n  JVM Max Memory: " + Runtime.getRuntime().maxMemory() + "\n  JVM Total Memory: " + Runtime.getRuntime().totalMemory() + "\n  JVM Free Memory: " + Runtime.getRuntime().freeMemory() + "\n";
    }

    private static long getMemoryAvailable() {
        Long total = Runtime.getRuntime().totalMemory();
        Long availMem = Runtime.getRuntime().freeMemory();
        return (total - availMem) / BYTES_IN_MB;
    }

    private static long getDiskAvailable() {
        long total = 0L;
        long free = 0L;
        for (File f : File.listRoots()) {
            total += f.getTotalSpace();
            free += f.getUsableSpace();
        }
        return (total - free) / BYTES_IN_MB;
    }

    private static long getDiskTotal() {
        long total = 0L;
        for (File f : File.listRoots()) {
            total += f.getTotalSpace();
        }
        return total / BYTES_IN_MB;
    }
}

