/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.DefaultCacheRepository;
import org.jackhuang.hmcl.download.DefaultGameBuilder;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.forge.ForgeInstallTask;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.download.game.GameDownloadTask;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.download.optifine.OptiFineInstallTask;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;

public class DefaultDependencyManager
extends AbstractDependencyManager {
    private final DefaultGameRepository repository;
    private final DownloadProvider downloadProvider;
    private final DefaultCacheRepository cacheRepository;

    public DefaultDependencyManager(DefaultGameRepository repository, DownloadProvider downloadProvider, DefaultCacheRepository cacheRepository) {
        this.repository = repository;
        this.downloadProvider = downloadProvider;
        this.cacheRepository = cacheRepository;
    }

    @Override
    public DefaultGameRepository getGameRepository() {
        return this.repository;
    }

    @Override
    public DownloadProvider getDownloadProvider() {
        return this.downloadProvider;
    }

    @Override
    public DefaultCacheRepository getCacheRepository() {
        return this.cacheRepository;
    }

    @Override
    public GameBuilder gameBuilder() {
        return new DefaultGameBuilder(this);
    }

    @Override
    public Task<?> checkGameCompletionAsync(Version original, boolean integrityCheck) {
        Version version = original.resolve(this.repository);
        return Task.allOf(Task.composeAsync(() -> {
            File versionJar = this.repository.getVersionJar(version);
            if (!versionJar.exists() || versionJar.length() == 0L) {
                return new GameDownloadTask(this, null, version);
            }
            return null;
        }), new GameAssetDownloadTask(this, version, false, integrityCheck), new GameLibrariesTask(this, version, integrityCheck));
    }

    @Override
    public Task<?> checkLibraryCompletionAsync(Version version, boolean integrityCheck) {
        return new GameLibrariesTask(this, version, integrityCheck, version.getLibraries());
    }

    @Override
    public Task<?> checkPatchCompletionAsync(Version version, boolean integrityCheck) {
        return Task.composeAsync(() -> {
            ArrayList tasks = new ArrayList();
            Optional<String> gameVersion = this.repository.getGameVersion(version);
            if (!gameVersion.isPresent()) {
                return null;
            }
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(version.resolvePreservingPatches(this.getGameRepository()));
            for (LibraryAnalyzer.LibraryType type : LibraryAnalyzer.LibraryType.values()) {
                Optional<Library> library = analyzer.getLibrary(type);
                if (!library.isPresent() || !GameLibrariesTask.shouldDownloadLibrary(this.repository, version, library.get(), integrityCheck)) continue;
                tasks.add(this.downloadMissingLibraryAsync(gameVersion.get(), version, type, library.get()));
            }
            return Task.allOf(tasks);
        });
    }

    private Task<?> downloadMissingLibraryAsync(String gameVersion, Version version, LibraryAnalyzer.LibraryType libraryType, Library library) {
        switch (libraryType) {
            case OPTIFINE: {
                if (library.hasDownloadURL()) break;
                return this.installLibraryAsync(gameVersion, version, libraryType.getPatchId(), library.getVersion());
            }
        }
        return Task.completed(null);
    }

    public Task<Version> installLibraryAsync(String gameVersion, Version baseVersion, String libraryId, String libraryVersion) {
        if (baseVersion.isResolved()) {
            throw new IllegalArgumentException("Version should not be resolved");
        }
        VersionList<?> versionList = this.getVersionList(libraryId);
        return Task.fromCompletableFuture(versionList.loadAsync(gameVersion)).thenComposeAsync(() -> this.installLibraryAsync(baseVersion, (RemoteVersion)versionList.getVersion(gameVersion, libraryVersion).orElseThrow(() -> new IOException("Remote library " + libraryId + " has no version " + libraryVersion)))).withStage(String.format("hmcl.install.%s:%s", libraryId, libraryVersion));
    }

    public Task<Version> installLibraryAsync(Version baseVersion, RemoteVersion libraryVersion) {
        if (baseVersion.isResolved()) {
            throw new IllegalArgumentException("Version should not be resolved");
        }
        AtomicReference removedLibraryVersion = new AtomicReference();
        return this.removeLibraryAsync(baseVersion.resolvePreservingPatches(this.repository), libraryVersion.getLibraryId()).thenComposeAsync(version -> {
            removedLibraryVersion.set(version);
            return libraryVersion.getInstallTask(this, (Version)version);
        }).thenApplyAsync(patch -> {
            if (patch == null) {
                return (Version)removedLibraryVersion.get();
            }
            return ((Version)removedLibraryVersion.get()).addPatch((Version)patch);
        }).withStage(String.format("hmcl.install.%s:%s", libraryVersion.getLibraryId(), libraryVersion.getSelfVersion()));
    }

    public Task<Version> installLibraryAsync(Version oldVersion, Path installer) {
        if (oldVersion.isResolved()) {
            throw new IllegalArgumentException("Version should not be resolved");
        }
        return Task.composeAsync(() -> {
            try {
                return ForgeInstallTask.install(this, oldVersion, installer);
            }
            catch (IOException iOException) {
                try {
                    return OptiFineInstallTask.install(this, oldVersion, installer);
                }
                catch (IOException iOException2) {
                    throw new UnsupportedLibraryInstallerException();
                }
            }
        }).thenApplyAsync(xva$0 -> oldVersion.addPatch((Version)xva$0));
    }

    public Task<Version> removeLibraryAsync(Version version, String libraryId) {
        if (version.isResolved()) {
            throw new IllegalArgumentException("removeLibraryWithoutSavingAsync requires non-resolved version");
        }
        Version independentVersion = version.resolvePreservingPatches(this.repository);
        return Task.supplyAsync(() -> LibraryAnalyzer.analyze(independentVersion).removeLibrary(libraryId).build());
    }

    public static class UnsupportedLibraryInstallerException
    extends Exception {
    }
}

