/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderBranch;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderGameVersions;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRepository;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersionsRoot;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LiteLoaderVersionList
extends VersionList<LiteLoaderRemoteVersion> {
    private final DownloadProvider downloadProvider;
    public static final String LITELOADER_LIST = "http://dl.liteloader.com/versions/versions.json";

    public LiteLoaderVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    private void doBranch(String key, String gameVersion, LiteLoaderRepository repository, LiteLoaderBranch branch, boolean snapshot) {
        if (branch == null || repository == null) {
            return;
        }
        for (Map.Entry<String, LiteLoaderVersion> entry : branch.getLiteLoader().entrySet()) {
            String branchName = entry.getKey();
            LiteLoaderVersion v = entry.getValue();
            if ("latest".equals(branchName)) continue;
            String version = v.getVersion();
            String url = repository.getUrl() + "com/mumfrey/liteloader/" + gameVersion + "/" + v.getFile();
            if (snapshot) {
                try {
                    version = version.replace("SNAPSHOT", LiteLoaderVersionList.getLatestSnapshotVersion(repository.getUrl() + "com/mumfrey/liteloader/" + v.getVersion() + "/"));
                    url = repository.getUrl() + "com/mumfrey/liteloader/" + v.getVersion() + "/liteloader-" + version + "-release.jar";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.versions.put(key, new LiteLoaderRemoteVersion(gameVersion, version, Collections.singletonList(url), v.getTweakClass(), v.getLibraries()));
        }
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        return HttpRequest.GET(this.downloadProvider.injectURL(LITELOADER_LIST)).getJsonAsync(LiteLoaderVersionsRoot.class).thenAcceptAsync(root -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                for (Map.Entry<String, LiteLoaderGameVersions> entry : root.getVersions().entrySet()) {
                    String gameVersion = entry.getKey();
                    LiteLoaderGameVersions liteLoader = entry.getValue();
                    String gg = VersionNumber.normalize(gameVersion);
                    this.doBranch(gg, gameVersion, liteLoader.getRepoitory(), liteLoader.getArtifacts(), false);
                    this.doBranch(gg, gameVersion, liteLoader.getRepoitory(), liteLoader.getSnapshots(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static String getLatestSnapshotVersion(String repo) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(repo + "maven-metadata.xml");
        Element r = doc.getDocumentElement();
        Element snapshot = (Element)r.getElementsByTagName("snapshot").item(0);
        Node timestamp = snapshot.getElementsByTagName("timestamp").item(0);
        Node buildNumber = snapshot.getElementsByTagName("buildNumber").item(0);
        return timestamp.getTextContent() + "-" + buildNumber.getTextContent();
    }
}

