/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

@Immutable
public final class ForgeNewModMetadata {
    private final String modLoader;
    private final String loaderVersion;
    private final String logoFile;
    private final String license;
    private final List<Mod> mods;

    public ForgeNewModMetadata() {
        this("", "", "", "", Collections.emptyList());
    }

    public ForgeNewModMetadata(String modLoader, String loaderVersion, String logoFile, String license, List<Mod> mods) {
        this.modLoader = modLoader;
        this.loaderVersion = loaderVersion;
        this.logoFile = logoFile;
        this.license = license;
        this.mods = mods;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public String getLoaderVersion() {
        return this.loaderVersion;
    }

    public String getLogoFile() {
        return this.logoFile;
    }

    public String getLicense() {
        return this.license;
    }

    public List<Mod> getMods() {
        return this.mods;
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile) throws IOException, JsonParseException {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modFile);){
            Path modstoml = fs.getPath("META-INF/mods.toml", new String[0]);
            if (Files.notExists(modstoml, new LinkOption[0])) {
                throw new IOException("File " + modFile + " is not a Forge 1.13+ mod.");
            }
            ForgeNewModMetadata metadata = new Toml().read(FileUtils.readText(modstoml)).to(ForgeNewModMetadata.class);
            if (metadata == null || metadata.getMods().isEmpty()) {
                throw new IOException("Mod " + modFile + " `mods.toml` is malformed..");
            }
            Mod mod = metadata.getMods().get(0);
            Path manifestMF = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            String jarVersion = "";
            if (Files.exists(manifestMF, new LinkOption[0])) {
                try {
                    Manifest manifest = new Manifest(Files.newInputStream(manifestMF, new OpenOption[0]));
                    jarVersion = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to parse MANIFEST.MF in file " + modFile);
                }
            }
            LocalModFile localModFile = new LocalModFile(modManager, modManager.getLocalMod(mod.getModId(), ModLoaderType.FORGE), modFile, mod.getDisplayName(), new LocalModFile.Description(mod.getDescription()), mod.getAuthors(), mod.getVersion().replace("${file.jarVersion}", jarVersion), "", mod.getDisplayURL(), metadata.getLogoFile());
            return localModFile;
        }
    }

    public static class Mod {
        private final String modId;
        private final String version;
        private final String displayName;
        private final String side;
        private final String displayURL;
        private final String authors;
        private final String description;

        public Mod() {
            this("", "", "", "", "", "", "");
        }

        public Mod(String modId, String version, String displayName, String side, String displayURL, String authors, String description) {
            this.modId = modId;
            this.version = version;
            this.displayName = displayName;
            this.side = side;
            this.displayURL = displayURL;
            this.authors = authors;
            this.description = description;
        }

        public String getModId() {
            return this.modId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSide() {
            return this.side;
        }

        public String getDisplayURL() {
            return this.displayURL;
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

