/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.util.Immutable;

@Immutable
public class CurseAddon
implements RemoteMod.IMod {
    private final int id;
    private final String name;
    private final List<Author> authors;
    private final List<Attachment> attachments;
    private final String websiteUrl;
    private final int gameId;
    private final String summary;
    private final int defaultFileId;
    private final LatestFile file;
    private final List<LatestFile> latestFiles;
    private final List<Category> categories;
    private final int status;
    private final int primaryCategoryId;
    private final String slug;
    private final List<GameVersionLatestFile> gameVersionLatestFiles;
    private final boolean isFeatured;
    private final double popularityScore;
    private final int gamePopularityRank;
    private final String primaryLanguage;
    private final List<String> modLoaders;
    private final boolean isAvailable;
    private final boolean isExperimental;

    public CurseAddon(int id, String name, List<Author> authors, List<Attachment> attachments, String websiteUrl, int gameId, String summary, int defaultFileId, LatestFile file, List<LatestFile> latestFiles, List<Category> categories, int status, int primaryCategoryId, String slug, List<GameVersionLatestFile> gameVersionLatestFiles, boolean isFeatured, double popularityScore, int gamePopularityRank, String primaryLanguage, List<String> modLoaders, boolean isAvailable, boolean isExperimental) {
        this.id = id;
        this.name = name;
        this.authors = authors;
        this.attachments = attachments;
        this.websiteUrl = websiteUrl;
        this.gameId = gameId;
        this.summary = summary;
        this.defaultFileId = defaultFileId;
        this.file = file;
        this.latestFiles = latestFiles;
        this.categories = categories;
        this.status = status;
        this.primaryCategoryId = primaryCategoryId;
        this.slug = slug;
        this.gameVersionLatestFiles = gameVersionLatestFiles;
        this.isFeatured = isFeatured;
        this.popularityScore = popularityScore;
        this.gamePopularityRank = gamePopularityRank;
        this.primaryLanguage = primaryLanguage;
        this.modLoaders = modLoaders;
        this.isAvailable = isAvailable;
        this.isExperimental = isExperimental;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public int getGameId() {
        return this.gameId;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getDefaultFileId() {
        return this.defaultFileId;
    }

    public LatestFile getFile() {
        return this.file;
    }

    public List<LatestFile> getLatestFiles() {
        return this.latestFiles;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public int getStatus() {
        return this.status;
    }

    public int getPrimaryCategoryId() {
        return this.primaryCategoryId;
    }

    public String getSlug() {
        return this.slug;
    }

    public List<GameVersionLatestFile> getGameVersionLatestFiles() {
        return this.gameVersionLatestFiles;
    }

    public boolean isFeatured() {
        return this.isFeatured;
    }

    public double getPopularityScore() {
        return this.popularityScore;
    }

    public int getGamePopularityRank() {
        return this.gamePopularityRank;
    }

    public String getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    public List<String> getModLoaders() {
        return this.modLoaders;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isExperimental() {
        return this.isExperimental;
    }

    @Override
    public List<RemoteMod> loadDependencies() throws IOException {
        Set dependencies = this.latestFiles.stream().flatMap(latestFile -> latestFile.getDependencies().stream()).filter(dep -> dep.getType() == 3).map(Dependency::getAddonId).collect(Collectors.toSet());
        ArrayList<RemoteMod> mods = new ArrayList<RemoteMod>();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            int dependencyId = (Integer)iterator.next();
            mods.add(CurseForgeRemoteModRepository.MODS.getModById(Integer.toString(dependencyId)));
        }
        return mods;
    }

    @Override
    public Stream<RemoteMod.Version> loadVersions() throws IOException {
        return CurseForgeRemoteModRepository.MODS.getRemoteVersionsById(Integer.toString(this.id));
    }

    public RemoteMod toMod() {
        String iconUrl = null;
        for (Attachment attachment : this.attachments) {
            if (!attachment.isDefault()) continue;
            iconUrl = attachment.getThumbnailUrl();
        }
        return new RemoteMod(this.slug, "", this.name, this.summary, this.categories.stream().map(category -> Integer.toString(category.getCategoryId())).collect(Collectors.toList()), this.websiteUrl, iconUrl, this);
    }

    @Immutable
    public static class Attachment {
        private final int id;
        private final int projectId;
        private final String description;
        private final boolean isDefault;
        private final String thumbnailUrl;
        private final String title;
        private final String url;
        private final int status;

        public Attachment(int id, int projectId, String description, boolean isDefault, String thumbnailUrl, String title, String url, int status) {
            this.id = id;
            this.projectId = projectId;
            this.description = description;
            this.isDefault = isDefault;
            this.thumbnailUrl = thumbnailUrl;
            this.title = title;
            this.url = url;
            this.status = status;
        }

        public int getId() {
            return this.id;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public int getStatus() {
            return this.status;
        }
    }

    @Immutable
    public static class Author {
        private final String name;
        private final String url;
        private final int projectId;
        private final int id;
        private final int userId;
        private final int twitchId;

        public Author(String name, String url, int projectId, int id, int userId, int twitchId) {
            this.name = name;
            this.url = url;
            this.projectId = projectId;
            this.id = id;
            this.userId = userId;
            this.twitchId = twitchId;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public int getId() {
            return this.id;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getTwitchId() {
            return this.twitchId;
        }
    }

    @Immutable
    public static class Category {
        private final int categoryId;
        private final String name;
        private final String url;
        private final String avatarUrl;
        private final int parentId;
        private final int rootId;
        private final int projectId;
        private final int avatarId;
        private final int gameId;

        public Category(int categoryId, String name, String url, String avatarUrl, int parentId, int rootId, int projectId, int avatarId, int gameId) {
            this.categoryId = categoryId;
            this.name = name;
            this.url = url;
            this.avatarUrl = avatarUrl;
            this.parentId = parentId;
            this.rootId = rootId;
            this.projectId = projectId;
            this.avatarId = avatarId;
            this.gameId = gameId;
        }

        public int getCategoryId() {
            return this.categoryId;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public int getParentId() {
            return this.parentId;
        }

        public int getRootId() {
            return this.rootId;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public int getAvatarId() {
            return this.avatarId;
        }

        public int getGameId() {
            return this.gameId;
        }
    }

    @Immutable
    public static class Dependency {
        private final int id;
        private final int addonId;
        private final int type;
        private final int fileId;

        public Dependency() {
            this(0, 0, 0, 0);
        }

        public Dependency(int id, int addonId, int type, int fileId) {
            this.id = id;
            this.addonId = addonId;
            this.type = type;
            this.fileId = fileId;
        }

        public int getId() {
            return this.id;
        }

        public int getAddonId() {
            return this.addonId;
        }

        public int getType() {
            return this.type;
        }

        public int getFileId() {
            return this.fileId;
        }
    }

    @Immutable
    public static class GameVersionLatestFile {
        private final String gameVersion;
        private final String projectFileId;
        private final String projectFileName;
        private final int fileType;
        private final Integer modLoader;

        public GameVersionLatestFile(String gameVersion, String projectFileId, String projectFileName, int fileType, Integer modLoader) {
            this.gameVersion = gameVersion;
            this.projectFileId = projectFileId;
            this.projectFileName = projectFileName;
            this.fileType = fileType;
            this.modLoader = modLoader;
        }

        public String getGameVersion() {
            return this.gameVersion;
        }

        public String getProjectFileId() {
            return this.projectFileId;
        }

        public String getProjectFileName() {
            return this.projectFileName;
        }

        public int getFileType() {
            return this.fileType;
        }

        public Integer getModLoader() {
            return this.modLoader;
        }
    }

    @Immutable
    public static class LatestFile
    implements RemoteMod.IVersion {
        private final int id;
        private final String displayName;
        private final String fileName;
        private final String fileDate;
        private final int fileLength;
        private final int releaseType;
        private final int fileStatus;
        private final String downloadUrl;
        private final boolean isAlternate;
        private final int alternateFileId;
        private final List<Dependency> dependencies;
        private final boolean isAvailable;
        private final List<String> gameVersion;
        private final boolean hasInstallScript;
        private final boolean isCompatibleWIthClient;
        private final int categorySectionPackageType;
        private final int restrictProjectFileAccess;
        private final int projectStatus;
        private final int projectId;
        private final boolean isServerPack;
        private final int serverPackFileId;
        private transient Instant fileDataInstant;

        public LatestFile(int id, String displayName, String fileName, String fileDate, int fileLength, int releaseType, int fileStatus, String downloadUrl, boolean isAlternate, int alternateFileId, List<Dependency> dependencies, boolean isAvailable, List<String> gameVersion, boolean hasInstallScript, boolean isCompatibleWIthClient, int categorySectionPackageType, int restrictProjectFileAccess, int projectStatus, int projectId, boolean isServerPack, int serverPackFileId) {
            this.id = id;
            this.displayName = displayName;
            this.fileName = fileName;
            this.fileDate = fileDate;
            this.fileLength = fileLength;
            this.releaseType = releaseType;
            this.fileStatus = fileStatus;
            this.downloadUrl = downloadUrl;
            this.isAlternate = isAlternate;
            this.alternateFileId = alternateFileId;
            this.dependencies = dependencies;
            this.isAvailable = isAvailable;
            this.gameVersion = gameVersion;
            this.hasInstallScript = hasInstallScript;
            this.isCompatibleWIthClient = isCompatibleWIthClient;
            this.categorySectionPackageType = categorySectionPackageType;
            this.restrictProjectFileAccess = restrictProjectFileAccess;
            this.projectStatus = projectStatus;
            this.projectId = projectId;
            this.isServerPack = isServerPack;
            this.serverPackFileId = serverPackFileId;
        }

        public int getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileDate() {
            return this.fileDate;
        }

        public int getFileLength() {
            return this.fileLength;
        }

        public int getReleaseType() {
            return this.releaseType;
        }

        public int getFileStatus() {
            return this.fileStatus;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public boolean isAlternate() {
            return this.isAlternate;
        }

        public int getAlternateFileId() {
            return this.alternateFileId;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public List<String> getGameVersion() {
            return this.gameVersion;
        }

        public boolean isHasInstallScript() {
            return this.hasInstallScript;
        }

        public boolean isCompatibleWIthClient() {
            return this.isCompatibleWIthClient;
        }

        public int getCategorySectionPackageType() {
            return this.categorySectionPackageType;
        }

        public int getRestrictProjectFileAccess() {
            return this.restrictProjectFileAccess;
        }

        public int getProjectStatus() {
            return this.projectStatus;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public boolean isServerPack() {
            return this.isServerPack;
        }

        public int getServerPackFileId() {
            return this.serverPackFileId;
        }

        public Instant getParsedFileDate() {
            if (this.fileDataInstant == null) {
                this.fileDataInstant = Instant.parse(this.fileDate);
            }
            return this.fileDataInstant;
        }

        @Override
        public RemoteMod.Type getType() {
            return RemoteMod.Type.CURSEFORGE;
        }

        public RemoteMod.Version toVersion() {
            RemoteMod.VersionType versionType;
            switch (this.getReleaseType()) {
                case 1: {
                    versionType = RemoteMod.VersionType.Release;
                    break;
                }
                case 2: {
                    versionType = RemoteMod.VersionType.Beta;
                    break;
                }
                case 3: {
                    versionType = RemoteMod.VersionType.Alpha;
                    break;
                }
                default: {
                    versionType = RemoteMod.VersionType.Release;
                }
            }
            ModLoaderType modLoaderType = this.gameVersion.contains("Forge") ? ModLoaderType.FORGE : (this.gameVersion.contains("Fabric") ? ModLoaderType.FABRIC : ModLoaderType.UNKNOWN);
            return new RemoteMod.Version(this, Integer.toString(this.projectId), this.getDisplayName(), this.getFileName(), null, this.getParsedFileDate(), versionType, new RemoteMod.File(Collections.emptyMap(), this.getDownloadUrl(), this.getFileName()), Collections.emptyList(), this.gameVersion.stream().filter(ver -> ver.startsWith("1.") || ver.contains("w")).collect(Collectors.toList()), Collections.singletonList(modLoaderType));
        }
    }
}

