/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;

public final class ModrinthRemoteModRepository
implements RemoteModRepository {
    public static final ModrinthRemoteModRepository INSTANCE = new ModrinthRemoteModRepository();
    private static final String PREFIX = "https://api.modrinth.com";

    private ModrinthRemoteModRepository() {
    }

    private static String convertSortType(RemoteModRepository.SortType sortType) {
        switch (sortType) {
            case DATE_CREATED: {
                return "newest";
            }
            case POPULARITY: 
            case NAME: 
            case AUTHOR: {
                return "relevance";
            }
            case LAST_UPDATED: {
                return "updated";
            }
            case TOTAL_DOWNLOADS: {
                return "downloads";
            }
        }
        throw new IllegalArgumentException("Unsupported sort type " + (Object)((Object)sortType));
    }

    public List<ModResult> searchPaginated(String gameVersion, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort) throws IOException {
        Map<String, String> query = Lang.mapOf(Pair.pair("query", searchFilter), Pair.pair("offset", Integer.toString(pageOffset)), Pair.pair("limit", Integer.toString(pageSize)), Pair.pair("index", ModrinthRemoteModRepository.convertSortType(sort)));
        if (StringUtils.isNotBlank(gameVersion)) {
            query.put("version", "versions=" + gameVersion);
        }
        Response response = (Response)HttpRequest.GET(NetworkUtils.withQuery("https://api.modrinth.com/api/v1/mod", query)).getJson(new TypeToken<Response<ModResult>>(){}.getType());
        return response.getHits();
    }

    @Override
    public Stream<RemoteMod> search(String gameVersion, RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort) throws IOException {
        return this.searchPaginated(gameVersion, pageOffset, pageSize, searchFilter, sort).stream().map(ModResult::toMod);
    }

    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        String sha1 = Hex.encodeHex(DigestUtils.digest("SHA-1", file));
        try {
            ModVersion mod = HttpRequest.GET("https://api.modrinth.com/api/v1/version_file/" + sha1, Pair.pair("algorithm", "sha1")).getJson(ModVersion.class);
            return mod.toVersion();
        }
        catch (ResponseCodeException e) {
            if (e.getResponseCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public RemoteMod getModById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        id = StringUtils.removePrefix(id, "local-");
        List versions = (List)HttpRequest.GET("https://api.modrinth.com/api/v1/mod/" + id + "/version").getJson(new TypeToken<List<ModVersion>>(){}.getType());
        return versions.stream().map(ModVersion::toVersion).flatMap(Lang::toStream);
    }

    public List<String> getCategoriesImpl() throws IOException {
        return (List)HttpRequest.GET("https://api.modrinth.com/api/v1/tag/category").getJson(new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        return this.getCategoriesImpl().stream().map(name -> new RemoteModRepository.Category(null, (String)name, Collections.emptyList()));
    }

    public static class Mod {
        private final String id;
        private final String slug;
        private final String team;
        private final String title;
        private final String description;
        private final Instant published;
        private final Instant updated;
        private final List<String> categories;
        private final List<String> versions;
        private final int downloads;
        @SerializedName(value="icon_url")
        private final String iconUrl;

        public Mod(String id, String slug, String team, String title, String description, Instant published, Instant updated, List<String> categories, List<String> versions, int downloads, String iconUrl) {
            this.id = id;
            this.slug = slug;
            this.team = team;
            this.title = title;
            this.description = description;
            this.published = published;
            this.updated = updated;
            this.categories = categories;
            this.versions = versions;
            this.downloads = downloads;
            this.iconUrl = iconUrl;
        }

        public String getId() {
            return this.id;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getTeam() {
            return this.team;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public Instant getPublished() {
            return this.published;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }
    }

    public static class ModResult
    implements RemoteMod.IMod {
        @SerializedName(value="mod_id")
        private final String modId;
        private final String slug;
        private final String author;
        private final String title;
        private final String description;
        private final List<String> categories;
        private final List<String> versions;
        private final int downloads;
        @SerializedName(value="page_url")
        private final String pageUrl;
        @SerializedName(value="icon_url")
        private final String iconUrl;
        @SerializedName(value="author_url")
        private final String authorUrl;
        @SerializedName(value="date_created")
        private final Instant dateCreated;
        @SerializedName(value="date_modified")
        private final Instant dateModified;
        @SerializedName(value="latest_version")
        private final String latestVersion;

        public ModResult(String modId, String slug, String author, String title, String description, List<String> categories, List<String> versions, int downloads, String pageUrl, String iconUrl, String authorUrl, Instant dateCreated, Instant dateModified, String latestVersion) {
            this.modId = modId;
            this.slug = slug;
            this.author = author;
            this.title = title;
            this.description = description;
            this.categories = categories;
            this.versions = versions;
            this.downloads = downloads;
            this.pageUrl = pageUrl;
            this.iconUrl = iconUrl;
            this.authorUrl = authorUrl;
            this.dateCreated = dateCreated;
            this.dateModified = dateModified;
            this.latestVersion = latestVersion;
        }

        public String getModId() {
            return this.modId;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getPageUrl() {
            return this.pageUrl;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getAuthorUrl() {
            return this.authorUrl;
        }

        public Instant getDateCreated() {
            return this.dateCreated;
        }

        public Instant getDateModified() {
            return this.dateModified;
        }

        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public List<RemoteMod> loadDependencies() throws IOException {
            return Collections.emptyList();
        }

        @Override
        public Stream<RemoteMod.Version> loadVersions() throws IOException {
            return INSTANCE.getRemoteVersionsById(this.getModId());
        }

        public RemoteMod toMod() {
            return new RemoteMod(this.slug, this.author, this.title, this.description, this.categories, this.pageUrl, this.iconUrl, this);
        }
    }

    public static class ModVersion
    implements RemoteMod.IVersion {
        private final String id;
        @SerializedName(value="mod_id")
        private final String modId;
        @SerializedName(value="author_id")
        private final String authorId;
        private final String name;
        @SerializedName(value="version_number")
        private final String versionNumber;
        private final String changelog;
        @SerializedName(value="date_published")
        private final Instant datePublished;
        private final int downloads;
        @SerializedName(value="version_type")
        private final String versionType;
        private final List<ModVersionFile> files;
        private final List<String> dependencies;
        @SerializedName(value="game_versions")
        private final List<String> gameVersions;
        private final List<String> loaders;

        public ModVersion(String id, String modId, String authorId, String name, String versionNumber, String changelog, Instant datePublished, int downloads, String versionType, List<ModVersionFile> files, List<String> dependencies, List<String> gameVersions, List<String> loaders) {
            this.id = id;
            this.modId = modId;
            this.authorId = authorId;
            this.name = name;
            this.versionNumber = versionNumber;
            this.changelog = changelog;
            this.datePublished = datePublished;
            this.downloads = downloads;
            this.versionType = versionType;
            this.files = files;
            this.dependencies = dependencies;
            this.gameVersions = gameVersions;
            this.loaders = loaders;
        }

        public String getId() {
            return this.id;
        }

        public String getModId() {
            return this.modId;
        }

        public String getAuthorId() {
            return this.authorId;
        }

        public String getName() {
            return this.name;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public Instant getDatePublished() {
            return this.datePublished;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getVersionType() {
            return this.versionType;
        }

        public List<ModVersionFile> getFiles() {
            return this.files;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        public List<String> getLoaders() {
            return this.loaders;
        }

        @Override
        public RemoteMod.Type getType() {
            return RemoteMod.Type.MODRINTH;
        }

        public Optional<RemoteMod.Version> toVersion() {
            RemoteMod.VersionType type = "release".equals(this.versionType) ? RemoteMod.VersionType.Release : ("beta".equals(this.versionType) ? RemoteMod.VersionType.Beta : ("alpha".equals(this.versionType) ? RemoteMod.VersionType.Alpha : RemoteMod.VersionType.Release));
            if (this.files.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(new RemoteMod.Version(this, this.modId, this.name, this.versionNumber, this.changelog, this.datePublished, type, this.files.get(0).toFile(), this.dependencies, this.gameVersions, this.loaders.stream().flatMap(loader -> {
                if ("fabric".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.FABRIC);
                }
                if ("forge".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.FORGE);
                }
                return Stream.empty();
            }).collect(Collectors.toList())));
        }
    }

    public static class ModVersionFile {
        private final Map<String, String> hashes;
        private final String url;
        private final String filename;

        public ModVersionFile(Map<String, String> hashes, String url, String filename) {
            this.hashes = hashes;
            this.url = url;
            this.filename = filename;
        }

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public RemoteMod.File toFile() {
            return new RemoteMod.File(this.hashes, this.url, this.filename);
        }
    }

    public static class Response<T> {
        private final int offset;
        private final int limit;
        @SerializedName(value="total_hits")
        private final int totalHits;
        private final List<T> hits;

        public Response() {
            this(0, 0, Collections.emptyList());
        }

        public Response(int offset, int limit, List<T> hits) {
            this.offset = offset;
            this.limit = limit;
            this.totalHits = hits.size();
            this.hits = hits;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getTotalHits() {
            return this.totalHits;
        }

        public List<T> getHits() {
            return this.hits;
        }
    }
}

