/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.server;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.server.ServerModpackLocalInstallTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public class ServerModpackManifest
implements Validation {
    private final String name;
    private final String author;
    private final String version;
    private final String description;
    private final String fileApi;
    private final List<ModpackConfiguration.FileInformation> files;
    private final List<Addon> addons;

    public ServerModpackManifest() {
        this("", "", "", "", "", Collections.emptyList(), Collections.emptyList());
    }

    public ServerModpackManifest(String name, String author, String version, String description, String fileApi, List<ModpackConfiguration.FileInformation> files, List<Addon> addons) {
        this.name = name;
        this.author = author;
        this.version = version;
        this.description = description;
        this.fileApi = fileApi;
        this.files = files;
        this.addons = addons;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileApi() {
        return this.fileApi;
    }

    public List<ModpackConfiguration.FileInformation> getFiles() {
        return this.files;
    }

    public List<Addon> getAddons() {
        return this.addons;
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (this.fileApi == null) {
            throw new JsonParseException("ServerModpackManifest.fileApi cannot be blank");
        }
        if (this.files == null) {
            throw new JsonParseException("ServerModpackManifest.files cannot be null");
        }
    }

    public Modpack toModpack(Charset encoding) throws IOException {
        String gameVersion = this.addons.stream().filter(x -> LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId().equals(((Addon)x).id)).findAny().orElseThrow(() -> new IOException("Cannot find game version")).getVersion();
        return new Modpack(this.name, this.author, this.version, gameVersion, this.description, encoding, this){

            @Override
            public Task<?> getInstallTask(DefaultDependencyManager dependencyManager, File zipFile, String name) {
                return new ServerModpackLocalInstallTask(dependencyManager, zipFile, this, ServerModpackManifest.this, name);
            }
        };
    }

    public static Modpack readManifest(Path zip, Charset encoding) throws IOException, JsonParseException {
        String json = CompressingUtils.readTextZipEntry(zip, "server-manifest.json", encoding);
        ServerModpackManifest manifest = JsonUtils.fromNonNullJson(json, ServerModpackManifest.class);
        return manifest.toModpack(encoding);
    }

    public static final class Addon {
        private final String id;
        private final String version;

        public Addon() {
            this("", "");
        }

        public Addon(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

