/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.util.HashMap;
import java.util.Map;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;

final class ConfigUpgrader {
    private static final int VERSION = 0;

    private ConfigUpgrader() {
    }

    static boolean upgradeConfig(Config deserialized, Map<?, ?> rawJson) {
        boolean upgraded;
        if (deserialized.getConfigVersion() < 0) {
            deserialized.setConfigVersion(0);
            upgraded = true;
        } else {
            upgraded = false;
        }
        ConfigUpgrader.upgradeV2(deserialized, rawJson);
        ConfigUpgrader.upgradeV3(deserialized, rawJson);
        return upgraded;
    }

    private static void upgradeV2(Config deserialized, Map<?, ?> rawJson) {
        Lang.tryCast(rawJson.get("auth"), Map.class).ifPresent(auth -> Lang.tryCast(auth.get("offline"), Map.class).ifPresent(offline -> {
            String selected = rawJson.containsKey("selectedAccount") ? null : (String)Lang.tryCast(offline.get("IAuthenticator_UserName"), String.class).orElse(null);
            Lang.tryCast(offline.get("uuidMap"), Map.class).ifPresent(uuidMap -> uuidMap.forEach((key, value) -> {
                HashMap<String, Object> storage = new HashMap<String, Object>();
                storage.put("type", "offline");
                storage.put("username", key);
                storage.put("uuid", value);
                if (key.equals(selected)) {
                    storage.put("selected", true);
                }
                deserialized.getAccountStorages().add(storage);
            }));
        }));
    }

    private static void upgradeV3(Config deserialized, Map<?, ?> rawJson) {
        if (!rawJson.containsKey("commonDirType")) {
            deserialized.setCommonDirType(deserialized.getCommonDirectory().equals(Settings.getDefaultCommonDirectory()) ? EnumCommonDirectory.DEFAULT : EnumCommonDirectory.CUSTOM);
        }
        if (!rawJson.containsKey("backgroundType")) {
            deserialized.setBackgroundImageType(StringUtils.isNotBlank(deserialized.getBackgroundImage()) ? EnumBackgroundImage.CUSTOM : EnumBackgroundImage.DEFAULT);
        }
        if (!rawJson.containsKey("hasProxy")) {
            deserialized.setHasProxy(StringUtils.isNotBlank(deserialized.getProxyHost()));
        }
        if (!rawJson.containsKey("hasProxyAuth")) {
            deserialized.setHasProxyAuth(StringUtils.isNotBlank(deserialized.getProxyUser()));
        }
        if (!rawJson.containsKey("downloadType")) {
            Lang.tryCast(rawJson.get("downloadtype"), Number.class).map(Number::intValue).ifPresent(id -> {
                if (id == 0) {
                    deserialized.setDownloadType("mojang");
                } else if (id == 1) {
                    deserialized.setDownloadType("bmclapi");
                }
            });
        }
        Lang.tryCast(rawJson.get("selectedAccount"), String.class).ifPresent(selected -> deserialized.getAccountStorages().stream().filter(storage -> {
            Object type = storage.get("type");
            if ("offline".equals(type)) {
                return selected.equals(storage.get("username") + ":" + storage.get("username"));
            }
            if ("yggdrasil".equals(type) || "authlibInjector".equals(type)) {
                return selected.equals(storage.get("username") + ":" + storage.get("displayName"));
            }
            return false;
        }).findFirst().ifPresent(storage -> storage.put("selected", true)));
    }
}

