/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class Profiles {
    public static final String DEFAULT_PROFILE = "Default";
    public static final String HOME_PROFILE = "Home";
    private static final ObservableList<Profile> profiles;
    private static final ReadOnlyListWrapper<Profile> profilesWrapper;
    private static ObjectProperty<Profile> selectedProfile;
    private static boolean initialized;
    private static final ReadOnlyStringWrapper selectedVersion;
    private static final List<Consumer<Profile>> versionsListeners;

    private Profiles() {
    }

    public static String getProfileDisplayName(Profile profile) {
        switch (profile.getName()) {
            case "Default": {
                return I18n.i18n("profile.default");
            }
            case "Home": {
                return I18n.i18n("profile.home");
            }
        }
        return profile.getName();
    }

    private static void checkProfiles() {
        if (profiles.isEmpty()) {
            Profile current = new Profile(DEFAULT_PROFILE, new File(".minecraft"), new VersionSetting(), null, true);
            Profile home = new Profile(HOME_PROFILE, Metadata.MINECRAFT_DIRECTORY.toFile());
            Platform.runLater(() -> profiles.addAll((Object[])new Profile[]{current, home}));
        }
    }

    private static void updateProfileStorages() {
        if (!initialized) {
            return;
        }
        ConfigHolder.config().getConfigurations().clear();
        ConfigHolder.config().getConfigurations().putAll(profiles.stream().collect(Collectors.toMap(Profile::getName, it -> it)));
    }

    static void init() {
        if (initialized) {
            throw new IllegalStateException("Already initialized");
        }
        HashSet names = new HashSet();
        ConfigHolder.config().getConfigurations().forEach((name, profile) -> {
            if (!names.add(name)) {
                return;
            }
            profiles.add(profile);
            profile.setName((String)name);
        });
        Profiles.checkProfiles();
        Platform.runLater(() -> {
            initialized = true;
            selectedProfile.set((Object)profiles.stream().filter(it -> it.getName().equals(ConfigHolder.config().getSelectedProfile())).findFirst().orElse((Profile)profiles.get(0)));
        });
        EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).registerWeak(event -> FXUtils.runInFX(() -> {
            Profile profile = (Profile)selectedProfile.get();
            if (profile != null && profile.getRepository() == event.getSource()) {
                selectedVersion.bind((ObservableValue)profile.selectedVersionProperty());
                for (Consumer<Profile> listener : versionsListeners) {
                    listener.accept(profile);
                }
            }
        }));
    }

    public static ObservableList<Profile> getProfiles() {
        return profiles;
    }

    public static ReadOnlyListProperty<Profile> profilesProperty() {
        return profilesWrapper.getReadOnlyProperty();
    }

    public static Profile getSelectedProfile() {
        return (Profile)selectedProfile.get();
    }

    public static void setSelectedProfile(Profile profile) {
        selectedProfile.set((Object)profile);
    }

    public static ObjectProperty<Profile> selectedProfileProperty() {
        return selectedProfile;
    }

    public static ReadOnlyStringProperty selectedVersionProperty() {
        return selectedVersion.getReadOnlyProperty();
    }

    public static String getSelectedVersion() {
        return selectedVersion.get();
    }

    public static void registerVersionsListener(Consumer<Profile> listener) {
        Profile profile = Profiles.getSelectedProfile();
        if (profile != null && profile.getRepository().isLoaded()) {
            listener.accept(profile);
        }
        versionsListeners.add(listener);
    }

    private static /* synthetic */ void lambda$static$2(ObservableValue a, Profile b, Profile newValue) {
        if (newValue != null) {
            newValue.getRepository().refreshVersionsAsync().start();
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

