/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.jfoenix.concurrency.JFXUtilities;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.JavaVersionConstraint;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.ProcessPriority;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

@JsonAdapter(value=Serializer.class)
public final class VersionSetting
implements Cloneable {
    private boolean global = false;
    private final BooleanProperty usesGlobalProperty = new SimpleBooleanProperty((Object)this, "usesGlobal", true);
    private final StringProperty javaProperty = new SimpleStringProperty((Object)this, "java", "");
    private final StringProperty defaultJavaPathProperty = new SimpleStringProperty((Object)this, "defaultJavaPath", "");
    private final ObjectProperty<NativesDirectoryType> nativesDirTypeProperty = new SimpleObjectProperty((Object)this, "nativesDirType", (Object)NativesDirectoryType.VERSION_FOLDER);
    private final StringProperty nativesDirProperty = new SimpleStringProperty((Object)this, "nativesDirProperty", "");
    private final StringProperty javaDirProperty = new SimpleStringProperty((Object)this, "javaDir", "");
    private final StringProperty wrapperProperty = new SimpleStringProperty((Object)this, "wrapper", "");
    private final StringProperty permSizeProperty = new SimpleStringProperty((Object)this, "permSize", "");
    private final IntegerProperty maxMemoryProperty = new SimpleIntegerProperty((Object)this, "maxMemory", OperatingSystem.SUGGESTED_MEMORY);
    private final ObjectProperty<Integer> minMemoryProperty = new SimpleObjectProperty((Object)this, "minMemory", null);
    private final BooleanProperty autoMemory = new SimpleBooleanProperty((Object)this, "autoMemory", true);
    private final StringProperty preLaunchCommandProperty = new SimpleStringProperty((Object)this, "precalledCommand", "");
    private final StringProperty postExitCommand = new SimpleStringProperty((Object)this, "postExitCommand", "");
    private final StringProperty javaArgsProperty = new SimpleStringProperty((Object)this, "javaArgs", "");
    private final StringProperty minecraftArgsProperty = new SimpleStringProperty((Object)this, "minecraftArgs", "");
    private final BooleanProperty noJVMArgsProperty = new SimpleBooleanProperty((Object)this, "noJVMArgs", false);
    private final BooleanProperty notCheckJVMProperty = new SimpleBooleanProperty((Object)this, "notCheckJVM", false);
    private final BooleanProperty notCheckGameProperty = new SimpleBooleanProperty((Object)this, "notCheckGame", false);
    private final BooleanProperty showLogsProperty = new SimpleBooleanProperty((Object)this, "showLogs", false);
    private final StringProperty serverIpProperty = new SimpleStringProperty((Object)this, "serverIp", "");
    private final BooleanProperty fullscreenProperty = new SimpleBooleanProperty((Object)this, "fullscreen", false);
    private final IntegerProperty widthProperty = new SimpleIntegerProperty((Object)this, "width", 854);
    private final IntegerProperty heightProperty = new SimpleIntegerProperty((Object)this, "height", 480);
    private final ObjectProperty<GameDirectoryType> gameDirTypeProperty = new SimpleObjectProperty((Object)this, "gameDirType", (Object)GameDirectoryType.ROOT_FOLDER);
    private final StringProperty gameDirProperty = new SimpleStringProperty((Object)this, "gameDir", "");
    private final ObjectProperty<ProcessPriority> processPriorityProperty = new SimpleObjectProperty((Object)this, "processPriority", (Object)ProcessPriority.NORMAL);
    private final BooleanProperty useNativeGLFW = new SimpleBooleanProperty((Object)this, "nativeGLFW", false);
    private final BooleanProperty useNativeOpenAL = new SimpleBooleanProperty((Object)this, "nativeOpenAL", false);
    private final ObjectProperty<VersionIconType> versionIcon = new SimpleObjectProperty((Object)this, "versionIcon", (Object)VersionIconType.DEFAULT);
    private final ObjectProperty<LauncherVisibility> launcherVisibilityProperty = new SimpleObjectProperty((Object)this, "launcherVisibility", (Object)LauncherVisibility.HIDE);

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public BooleanProperty usesGlobalProperty() {
        return this.usesGlobalProperty;
    }

    public boolean isUsesGlobal() {
        return this.usesGlobalProperty.get();
    }

    public void setUsesGlobal(boolean usesGlobal) {
        this.usesGlobalProperty.set(usesGlobal);
    }

    public StringProperty javaProperty() {
        return this.javaProperty;
    }

    public String getJava() {
        return (String)this.javaProperty.get();
    }

    public void setJava(String java) {
        this.javaProperty.set((Object)java);
    }

    public boolean isUsesCustomJavaDir() {
        return "Custom".equals(this.getJava());
    }

    public void setUsesCustomJavaDir() {
        this.setJava("Custom");
        this.setDefaultJavaPath(null);
    }

    public boolean isJavaAutoSelected() {
        return "Auto".equals(this.getJava());
    }

    public void setJavaAutoSelected() {
        this.setJava("Auto");
        this.setDefaultJavaPath(null);
    }

    public String getDefaultJavaPath() {
        return (String)this.defaultJavaPathProperty.get();
    }

    public StringProperty defaultJavaPathPropertyProperty() {
        return this.defaultJavaPathProperty;
    }

    public void setDefaultJavaPath(String defaultJavaPath) {
        this.defaultJavaPathProperty.set((Object)defaultJavaPath);
    }

    public ObjectProperty<NativesDirectoryType> nativesDirTypeProperty() {
        return this.nativesDirTypeProperty;
    }

    public NativesDirectoryType getNativesDirType() {
        return (NativesDirectoryType)((Object)this.nativesDirTypeProperty.get());
    }

    public void setNativesDirType(NativesDirectoryType nativesDirType) {
        this.nativesDirTypeProperty.set((Object)nativesDirType);
    }

    public StringProperty nativesDirProperty() {
        return this.nativesDirProperty;
    }

    public String getNativesDir() {
        return (String)this.nativesDirProperty.get();
    }

    public void setNativesDir(String nativesDir) {
        this.nativesDirProperty.set((Object)nativesDir);
    }

    public StringProperty javaDirProperty() {
        return this.javaDirProperty;
    }

    public String getJavaDir() {
        return (String)this.javaDirProperty.get();
    }

    public void setJavaDir(String javaDir) {
        this.javaDirProperty.set((Object)javaDir);
    }

    public StringProperty wrapperProperty() {
        return this.wrapperProperty;
    }

    public String getWrapper() {
        return (String)this.wrapperProperty.get();
    }

    public void setWrapper(String wrapper) {
        this.wrapperProperty.set((Object)wrapper);
    }

    public StringProperty permSizeProperty() {
        return this.permSizeProperty;
    }

    public String getPermSize() {
        return (String)this.permSizeProperty.get();
    }

    public void setPermSize(String permSize) {
        this.permSizeProperty.set((Object)permSize);
    }

    public IntegerProperty maxMemoryProperty() {
        return this.maxMemoryProperty;
    }

    public int getMaxMemory() {
        return this.maxMemoryProperty.get();
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemoryProperty.set(maxMemory);
    }

    public ObjectProperty<Integer> minMemoryProperty() {
        return this.minMemoryProperty;
    }

    public Integer getMinMemory() {
        return (Integer)this.minMemoryProperty.get();
    }

    public void setMinMemory(Integer minMemory) {
        this.minMemoryProperty.set((Object)minMemory);
    }

    public boolean isAutoMemory() {
        return this.autoMemory.get();
    }

    public BooleanProperty autoMemoryProperty() {
        return this.autoMemory;
    }

    public void setAutoMemory(boolean autoMemory) {
        this.autoMemory.set(autoMemory);
    }

    public StringProperty preLaunchCommandProperty() {
        return this.preLaunchCommandProperty;
    }

    public String getPreLaunchCommand() {
        return (String)this.preLaunchCommandProperty.get();
    }

    public void setPreLaunchCommand(String preLaunchCommand) {
        this.preLaunchCommandProperty.set((Object)preLaunchCommand);
    }

    public StringProperty postExitCommandProperty() {
        return this.postExitCommand;
    }

    public String getPostExitCommand() {
        return (String)this.postExitCommand.get();
    }

    public void setPostExitCommand(String postExitCommand) {
        this.postExitCommand.set((Object)postExitCommand);
    }

    public StringProperty javaArgsProperty() {
        return this.javaArgsProperty;
    }

    public String getJavaArgs() {
        return (String)this.javaArgsProperty.get();
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgsProperty.set((Object)javaArgs);
    }

    public StringProperty minecraftArgsProperty() {
        return this.minecraftArgsProperty;
    }

    public String getMinecraftArgs() {
        return (String)this.minecraftArgsProperty.get();
    }

    public void setMinecraftArgs(String minecraftArgs) {
        this.minecraftArgsProperty.set((Object)minecraftArgs);
    }

    public BooleanProperty noJVMArgsProperty() {
        return this.noJVMArgsProperty;
    }

    public boolean isNoJVMArgs() {
        return this.noJVMArgsProperty.get();
    }

    public void setNoJVMArgs(boolean noJVMArgs) {
        this.noJVMArgsProperty.set(noJVMArgs);
    }

    public BooleanProperty notCheckJVMProperty() {
        return this.notCheckJVMProperty;
    }

    public boolean isNotCheckJVM() {
        return this.notCheckJVMProperty.get();
    }

    public void setNotCheckJVM(boolean notCheckJVM) {
        this.notCheckJVMProperty.set(notCheckJVM);
    }

    public BooleanProperty notCheckGameProperty() {
        return this.notCheckGameProperty;
    }

    public boolean isNotCheckGame() {
        return this.notCheckGameProperty.get();
    }

    public void setNotCheckGame(boolean notCheckGame) {
        this.notCheckGameProperty.set(notCheckGame);
    }

    public BooleanProperty showLogsProperty() {
        return this.showLogsProperty;
    }

    public boolean isShowLogs() {
        return this.showLogsProperty.get();
    }

    public void setShowLogs(boolean showLogs) {
        this.showLogsProperty.set(showLogs);
    }

    public StringProperty serverIpProperty() {
        return this.serverIpProperty;
    }

    public String getServerIp() {
        return (String)this.serverIpProperty.get();
    }

    public void setServerIp(String serverIp) {
        this.serverIpProperty.set((Object)serverIp);
    }

    public BooleanProperty fullscreenProperty() {
        return this.fullscreenProperty;
    }

    public boolean isFullscreen() {
        return this.fullscreenProperty.get();
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreenProperty.set(fullscreen);
    }

    public IntegerProperty widthProperty() {
        return this.widthProperty;
    }

    public int getWidth() {
        return this.widthProperty.get();
    }

    public void setWidth(int width) {
        this.widthProperty.set(width);
    }

    public IntegerProperty heightProperty() {
        return this.heightProperty;
    }

    public int getHeight() {
        return this.heightProperty.get();
    }

    public void setHeight(int height) {
        this.heightProperty.set(height);
    }

    public ObjectProperty<GameDirectoryType> gameDirTypeProperty() {
        return this.gameDirTypeProperty;
    }

    public GameDirectoryType getGameDirType() {
        return (GameDirectoryType)((Object)this.gameDirTypeProperty.get());
    }

    public void setGameDirType(GameDirectoryType gameDirType) {
        this.gameDirTypeProperty.set((Object)gameDirType);
    }

    public StringProperty gameDirProperty() {
        return this.gameDirProperty;
    }

    public String getGameDir() {
        return (String)this.gameDirProperty.get();
    }

    public void setGameDir(String gameDir) {
        this.gameDirProperty.set((Object)gameDir);
    }

    public ObjectProperty<ProcessPriority> processPriorityProperty() {
        return this.processPriorityProperty;
    }

    public ProcessPriority getProcessPriority() {
        return (ProcessPriority)((Object)this.processPriorityProperty.get());
    }

    public void setProcessPriority(ProcessPriority processPriority) {
        this.processPriorityProperty.set((Object)processPriority);
    }

    public boolean isUseNativeGLFW() {
        return this.useNativeGLFW.get();
    }

    public BooleanProperty useNativeGLFWProperty() {
        return this.useNativeGLFW;
    }

    public void setUseNativeGLFW(boolean useNativeGLFW) {
        this.useNativeGLFW.set(useNativeGLFW);
    }

    public boolean isUseNativeOpenAL() {
        return this.useNativeOpenAL.get();
    }

    public BooleanProperty useNativeOpenALProperty() {
        return this.useNativeOpenAL;
    }

    public void setUseNativeOpenAL(boolean useNativeOpenAL) {
        this.useNativeOpenAL.set(useNativeOpenAL);
    }

    public VersionIconType getVersionIcon() {
        return (VersionIconType)((Object)this.versionIcon.get());
    }

    public ObjectProperty<VersionIconType> versionIconProperty() {
        return this.versionIcon;
    }

    public void setVersionIcon(VersionIconType versionIcon) {
        this.versionIcon.set((Object)versionIcon);
    }

    public ObjectProperty<LauncherVisibility> launcherVisibilityProperty() {
        return this.launcherVisibilityProperty;
    }

    public LauncherVisibility getLauncherVisibility() {
        return (LauncherVisibility)((Object)this.launcherVisibilityProperty.get());
    }

    public void setLauncherVisibility(LauncherVisibility launcherVisibility) {
        this.launcherVisibilityProperty.set((Object)launcherVisibility);
    }

    public Task<JavaVersion> getJavaVersion(VersionNumber gameVersion, Version version) {
        return this.getJavaVersion(gameVersion, version, true);
    }

    public Task<JavaVersion> getJavaVersion(VersionNumber gameVersion, Version version, boolean checkJava) {
        return Task.runAsync(Schedulers.javafx(), () -> {
            if (StringUtils.isBlank(this.getJava())) {
                this.setJava(StringUtils.isBlank(this.getJavaDir()) ? "Default" : "Custom");
            }
        }).thenSupplyAsync(() -> {
            try {
                if ("Default".equals(this.getJava())) {
                    return JavaVersion.fromCurrentEnvironment();
                }
                if (this.isJavaAutoSelected()) {
                    return JavaVersionConstraint.findSuitableJavaVersion(gameVersion, version);
                }
                if (this.isUsesCustomJavaDir()) {
                    try {
                        if (checkJava) {
                            return JavaVersion.fromExecutable(Paths.get(this.getJavaDir(), new String[0]));
                        }
                        return new JavaVersion(Paths.get(this.getJavaDir(), new String[0]), "", Platform.getPlatform(OperatingSystem.CURRENT_OS, Architecture.UNKNOWN));
                    }
                    catch (IOException | InvalidPathException e) {
                        return null;
                    }
                }
                if (StringUtils.isNotBlank(this.getJava())) {
                    List matchedJava = JavaVersion.getJavas().stream().filter(java -> java.getVersion().equals(this.getJava())).collect(Collectors.toList());
                    if (matchedJava.isEmpty()) {
                        JFXUtilities.runInFX(() -> this.setJava("Default"));
                        return JavaVersion.fromCurrentEnvironment();
                    }
                    return matchedJava.stream().filter(java -> java.getBinary().toString().equals(this.getDefaultJavaPath())).findFirst().orElse((JavaVersion)matchedJava.get(0));
                }
                throw new Error();
            }
            catch (InterruptedException e) {
                throw new CancellationException();
            }
        });
    }

    public void setJavaVersion(JavaVersion java) {
        this.setJava(java.getVersion());
        this.setDefaultJavaPath(java.getBinary().toString());
    }

    public void addPropertyChangedListener(InvalidationListener listener) {
        this.usesGlobalProperty.addListener(listener);
        this.javaProperty.addListener(listener);
        this.javaDirProperty.addListener(listener);
        this.wrapperProperty.addListener(listener);
        this.permSizeProperty.addListener(listener);
        this.maxMemoryProperty.addListener(listener);
        this.minMemoryProperty.addListener(listener);
        this.autoMemory.addListener(listener);
        this.preLaunchCommandProperty.addListener(listener);
        this.postExitCommand.addListener(listener);
        this.javaArgsProperty.addListener(listener);
        this.minecraftArgsProperty.addListener(listener);
        this.noJVMArgsProperty.addListener(listener);
        this.notCheckGameProperty.addListener(listener);
        this.notCheckJVMProperty.addListener(listener);
        this.showLogsProperty.addListener(listener);
        this.serverIpProperty.addListener(listener);
        this.fullscreenProperty.addListener(listener);
        this.widthProperty.addListener(listener);
        this.heightProperty.addListener(listener);
        this.gameDirTypeProperty.addListener(listener);
        this.gameDirProperty.addListener(listener);
        this.processPriorityProperty.addListener(listener);
        this.useNativeGLFW.addListener(listener);
        this.useNativeOpenAL.addListener(listener);
        this.launcherVisibilityProperty.addListener(listener);
        this.defaultJavaPathProperty.addListener(listener);
        this.nativesDirProperty.addListener(listener);
        this.nativesDirTypeProperty.addListener(listener);
        this.versionIcon.addListener(listener);
    }

    public VersionSetting clone() {
        VersionSetting versionSetting = new VersionSetting();
        versionSetting.setUsesGlobal(this.isUsesGlobal());
        versionSetting.setJava(this.getJava());
        versionSetting.setDefaultJavaPath(this.getDefaultJavaPath());
        versionSetting.setJavaDir(this.getJavaDir());
        versionSetting.setWrapper(this.getWrapper());
        versionSetting.setPermSize(this.getPermSize());
        versionSetting.setMaxMemory(this.getMaxMemory());
        versionSetting.setMinMemory(this.getMinMemory());
        versionSetting.setAutoMemory(this.isAutoMemory());
        versionSetting.setPreLaunchCommand(this.getPreLaunchCommand());
        versionSetting.setPostExitCommand(this.getPostExitCommand());
        versionSetting.setJavaArgs(this.getJavaArgs());
        versionSetting.setMinecraftArgs(this.getMinecraftArgs());
        versionSetting.setNoJVMArgs(this.isNoJVMArgs());
        versionSetting.setNotCheckGame(this.isNotCheckGame());
        versionSetting.setNotCheckJVM(this.isNotCheckJVM());
        versionSetting.setShowLogs(this.isShowLogs());
        versionSetting.setServerIp(this.getServerIp());
        versionSetting.setFullscreen(this.isFullscreen());
        versionSetting.setWidth(this.getWidth());
        versionSetting.setHeight(this.getHeight());
        versionSetting.setGameDirType(this.getGameDirType());
        versionSetting.setGameDir(this.getGameDir());
        versionSetting.setProcessPriority(this.getProcessPriority());
        versionSetting.setUseNativeGLFW(this.isUseNativeGLFW());
        versionSetting.setUseNativeOpenAL(this.isUseNativeOpenAL());
        versionSetting.setLauncherVisibility(this.getLauncherVisibility());
        versionSetting.setNativesDir(this.getNativesDir());
        versionSetting.setVersionIcon(this.getVersionIcon());
        return versionSetting;
    }

    public static class Serializer
    implements JsonSerializer<VersionSetting>,
    JsonDeserializer<VersionSetting> {
        @Override
        public JsonElement serialize(VersionSetting src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return JsonNull.INSTANCE;
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("usesGlobal", src.isUsesGlobal());
            obj.addProperty("javaArgs", src.getJavaArgs());
            obj.addProperty("minecraftArgs", src.getMinecraftArgs());
            obj.addProperty("maxMemory", src.getMaxMemory() <= 0 ? OperatingSystem.SUGGESTED_MEMORY : src.getMaxMemory());
            obj.addProperty("minMemory", src.getMinMemory());
            obj.addProperty("autoMemory", src.isAutoMemory());
            obj.addProperty("permSize", src.getPermSize());
            obj.addProperty("width", src.getWidth());
            obj.addProperty("height", src.getHeight());
            obj.addProperty("javaDir", src.getJavaDir());
            obj.addProperty("precalledCommand", src.getPreLaunchCommand());
            obj.addProperty("postExitCommand", src.getPostExitCommand());
            obj.addProperty("serverIp", src.getServerIp());
            obj.addProperty("java", src.getJava());
            obj.addProperty("wrapper", src.getWrapper());
            obj.addProperty("fullscreen", src.isFullscreen());
            obj.addProperty("noJVMArgs", src.isNoJVMArgs());
            obj.addProperty("notCheckGame", src.isNotCheckGame());
            obj.addProperty("notCheckJVM", src.isNotCheckJVM());
            obj.addProperty("showLogs", src.isShowLogs());
            obj.addProperty("gameDir", src.getGameDir());
            obj.addProperty("launcherVisibility", src.getLauncherVisibility().ordinal());
            obj.addProperty("processPriority", src.getProcessPriority().ordinal());
            obj.addProperty("useNativeGLFW", src.isUseNativeGLFW());
            obj.addProperty("useNativeOpenAL", src.isUseNativeOpenAL());
            obj.addProperty("gameDirType", src.getGameDirType().ordinal());
            obj.addProperty("defaultJavaPath", src.getDefaultJavaPath());
            obj.addProperty("nativesDir", src.getNativesDir());
            obj.addProperty("nativesDirType", src.getNativesDirType().ordinal());
            obj.addProperty("versionIcon", src.getVersionIcon().ordinal());
            return obj;
        }

        @Override
        public VersionSetting deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json == JsonNull.INSTANCE || !(json instanceof JsonObject)) {
                return null;
            }
            JsonObject obj = (JsonObject)json;
            int maxMemoryN = this.parseJsonPrimitive(Optional.ofNullable(obj.get("maxMemory")).map(JsonElement::getAsJsonPrimitive).orElse(null), OperatingSystem.SUGGESTED_MEMORY);
            if (maxMemoryN <= 0) {
                maxMemoryN = OperatingSystem.SUGGESTED_MEMORY;
            }
            VersionSetting vs = new VersionSetting();
            vs.setUsesGlobal(Optional.ofNullable(obj.get("usesGlobal")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setJavaArgs(Optional.ofNullable(obj.get("javaArgs")).map(JsonElement::getAsString).orElse(""));
            vs.setMinecraftArgs(Optional.ofNullable(obj.get("minecraftArgs")).map(JsonElement::getAsString).orElse(""));
            vs.setMaxMemory(maxMemoryN);
            vs.setMinMemory(Optional.ofNullable(obj.get("minMemory")).map(JsonElement::getAsInt).orElse(null));
            vs.setAutoMemory(Optional.ofNullable(obj.get("autoMemory")).map(JsonElement::getAsBoolean).orElse(true));
            vs.setPermSize(Optional.ofNullable(obj.get("permSize")).map(JsonElement::getAsString).orElse(""));
            vs.setWidth(Optional.ofNullable(obj.get("width")).map(JsonElement::getAsJsonPrimitive).map(this::parseJsonPrimitive).orElse(0));
            vs.setHeight(Optional.ofNullable(obj.get("height")).map(JsonElement::getAsJsonPrimitive).map(this::parseJsonPrimitive).orElse(0));
            vs.setJavaDir(Optional.ofNullable(obj.get("javaDir")).map(JsonElement::getAsString).orElse(""));
            vs.setPreLaunchCommand(Optional.ofNullable(obj.get("precalledCommand")).map(JsonElement::getAsString).orElse(""));
            vs.setServerIp(Optional.ofNullable(obj.get("serverIp")).map(JsonElement::getAsString).orElse(""));
            vs.setJava(Optional.ofNullable(obj.get("java")).map(JsonElement::getAsString).orElse(""));
            vs.setWrapper(Optional.ofNullable(obj.get("wrapper")).map(JsonElement::getAsString).orElse(""));
            vs.setGameDir(Optional.ofNullable(obj.get("gameDir")).map(JsonElement::getAsString).orElse(""));
            vs.setNativesDir(Optional.ofNullable(obj.get("nativesDir")).map(JsonElement::getAsString).orElse(""));
            vs.setFullscreen(Optional.ofNullable(obj.get("fullscreen")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setNoJVMArgs(Optional.ofNullable(obj.get("noJVMArgs")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setNotCheckGame(Optional.ofNullable(obj.get("notCheckGame")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setNotCheckJVM(Optional.ofNullable(obj.get("notCheckJVM")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setShowLogs(Optional.ofNullable(obj.get("showLogs")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setLauncherVisibility(LauncherVisibility.values()[Optional.ofNullable(obj.get("launcherVisibility")).map(JsonElement::getAsInt).orElse(LauncherVisibility.HIDE.ordinal())]);
            vs.setProcessPriority(ProcessPriority.values()[Optional.ofNullable(obj.get("processPriority")).map(JsonElement::getAsInt).orElse(ProcessPriority.NORMAL.ordinal())]);
            vs.setUseNativeGLFW(Optional.ofNullable(obj.get("useNativeGLFW")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setUseNativeOpenAL(Optional.ofNullable(obj.get("useNativeOpenAL")).map(JsonElement::getAsBoolean).orElse(false));
            vs.setGameDirType(GameDirectoryType.values()[Optional.ofNullable(obj.get("gameDirType")).map(JsonElement::getAsInt).orElse(GameDirectoryType.ROOT_FOLDER.ordinal())]);
            vs.setDefaultJavaPath(Optional.ofNullable(obj.get("defaultJavaPath")).map(JsonElement::getAsString).orElse(null));
            vs.setNativesDirType(NativesDirectoryType.values()[Optional.ofNullable(obj.get("nativesDirType")).map(JsonElement::getAsInt).orElse(0)]);
            vs.setVersionIcon(VersionIconType.values()[Optional.ofNullable(obj.get("versionIcon")).map(JsonElement::getAsInt).orElse(0)]);
            return vs;
        }

        private int parseJsonPrimitive(JsonPrimitive primitive) {
            return this.parseJsonPrimitive(primitive, 0);
        }

        private int parseJsonPrimitive(JsonPrimitive primitive, int defaultValue) {
            if (primitive == null) {
                return defaultValue;
            }
            if (primitive.isNumber()) {
                return primitive.getAsInt();
            }
            return Lang.parseInt(primitive.getAsString(), defaultValue);
        }
    }
}

