/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class GetTask
extends FetchTask<String> {
    private final Charset charset;

    public GetTask(URL url) {
        this(url, StandardCharsets.UTF_8);
    }

    public GetTask(URL url, Charset charset) {
        this(url, charset, 3);
    }

    public GetTask(URL url, Charset charset, int retry) {
        this(Collections.singletonList(url), charset, retry);
    }

    public GetTask(List<URL> url) {
        this(url, StandardCharsets.UTF_8, 3);
    }

    public GetTask(List<URL> urls, Charset charset, int retry) {
        super(urls, retry);
        this.charset = charset;
        this.setName(urls.get(0).toString());
    }

    @Override
    protected FetchTask.EnumCheckETag shouldCheckETag() {
        return FetchTask.EnumCheckETag.CHECK_E_TAG;
    }

    @Override
    protected void useCachedResult(Path cachedFile) throws IOException {
        this.setResult(FileUtils.readText(cachedFile));
    }

    @Override
    protected FetchTask.Context getContext(final URLConnection conn, final boolean checkETag) {
        return new FetchTask.Context(){
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();

            @Override
            public void write(byte[] buffer, int offset, int len) {
                this.baos.write(buffer, offset, len);
            }

            @Override
            public void close() throws IOException {
                if (!this.isSuccess()) {
                    return;
                }
                String result = this.baos.toString(GetTask.this.charset.name());
                GetTask.this.setResult(result);
                if (checkETag) {
                    GetTask.this.repository.cacheText(result, conn);
                }
            }
        };
    }
}

