/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.CrashReportAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.LogExporter;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class GameCrashWindow
extends Stage {
    private final Version version;
    private final String memory;
    private final String java;
    private final LibraryAnalyzer analyzer;
    private final StringProperty os = new SimpleStringProperty(OperatingSystem.SYSTEM_NAME);
    private final StringProperty arch = new SimpleStringProperty(Architecture.SYSTEM_ARCH.getDisplayName());
    private final TextFlow reasonTextFlow = new TextFlow(new Node[]{new Text(I18n.i18n("game.crash.reason.unknown"))});
    private final BooleanProperty loading = new SimpleBooleanProperty();
    private final Label feedbackLabel = new Label(I18n.i18n("game.crash.feedback"));
    private final ManagedProcess managedProcess;
    private final DefaultGameRepository repository;
    private final ProcessListener.ExitType exitType;
    private final LaunchOptions launchOptions;
    private final View view;
    private final List<Pair<String, Log4jLevel>> logs;
    private static final Pattern FABRIC_MOD_ID = Pattern.compile("\\{(?<modid>.*?) @ (?<version>.*?)}");

    public GameCrashWindow(ManagedProcess managedProcess, ProcessListener.ExitType exitType, DefaultGameRepository repository, Version version, LaunchOptions launchOptions, List<Pair<String, Log4jLevel>> logs) {
        this.managedProcess = managedProcess;
        this.exitType = exitType;
        this.repository = repository;
        this.version = version;
        this.launchOptions = launchOptions;
        this.logs = logs;
        this.analyzer = LibraryAnalyzer.analyze(version);
        this.memory = Optional.ofNullable(launchOptions.getMaxMemory()).map(i -> i + " MB").orElse("-");
        this.java = launchOptions.getJava().getArchitecture() == Architecture.SYSTEM_ARCH ? launchOptions.getJava().getVersion() : launchOptions.getJava().getVersion() + " (" + launchOptions.getJava().getArchitecture().getDisplayName() + ")";
        this.view = new View();
        this.setScene(new Scene((Parent)this.view, 800.0, 480.0));
        this.getScene().getStylesheets().addAll((Object[])ConfigHolder.config().getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        this.setTitle(I18n.i18n("game.crash.title"));
        this.getIcons().add((Object)FXUtils.newImage("/assets/img/icon.png"));
        this.analyzeCrashReport();
    }

    private void analyzeCrashReport() {
        this.loading.set(true);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            String rawLog = this.logs.stream().map(Pair::getKey).collect(Collectors.joining("\n"));
            Set<Object> keywords = Collections.emptySet();
            String crashReport = null;
            try {
                crashReport = CrashReportAnalyzer.findCrashReport(rawLog);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to read crash report", e);
            }
            if (crashReport == null) {
                crashReport = CrashReportAnalyzer.extractCrashReport(rawLog);
            }
            if (crashReport != null) {
                keywords = CrashReportAnalyzer.findKeywordsFromCrashReport(crashReport);
            }
            return Pair.pair(CrashReportAnalyzer.anaylze(rawLog), keywords);
        }).whenCompleteAsync((pair, exception) -> {
            this.loading.set(false);
            if (exception != null) {
                Logging.LOG.log(Level.WARNING, "Failed to analyze crash report", (Throwable)exception);
                this.reasonTextFlow.getChildren().setAll((Object[])new Node[]{new Text(I18n.i18n("game.crash.reason.unknown"))});
            } else {
                List results = (List)pair.getKey();
                Set keywords = (Set)pair.getValue();
                ArrayList<Object> segments = new ArrayList<Object>();
                for (CrashReportAnalyzer.Result result : results) {
                    switch (result.getRule()) {
                        case TOO_OLD_JAVA: {
                            segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason.too_old_java", CrashReportAnalyzer.getJavaVersionFromMajorVersion(Integer.parseInt(result.getMatcher().group("expected")))), Controllers::onHyperlinkAction));
                            break;
                        }
                        case MOD_RESOLUTION_CONFLICT: 
                        case MOD_RESOLUTION_MISSING: 
                        case MOD_RESOLUTION_COLLECTION: {
                            segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), this.translateFabricModId(result.getMatcher().group("sourcemod")), this.parseFabricModId(result.getMatcher().group("destmod")), this.parseFabricModId(result.getMatcher().group("destmod"))), Controllers::onHyperlinkAction));
                            break;
                        }
                        case MOD_RESOLUTION_MISSING_MINECRAFT: {
                            segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), this.translateFabricModId(result.getMatcher().group("mod")), result.getMatcher().group("version")), Controllers::onHyperlinkAction));
                            break;
                        }
                        case TWILIGHT_FOREST_OPTIFINE: {
                            segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason.mod", "OptiFine"), Controllers::onHyperlinkAction));
                            break;
                        }
                        default: {
                            segments.addAll(FXUtils.parseSegment(I18n.i18n("game.crash.reason." + result.getRule().name().toLowerCase(Locale.ROOT), Arrays.stream(result.getRule().getGroupNames()).map(groupName -> result.getMatcher().group((String)groupName)).toArray()), Controllers::onHyperlinkAction));
                        }
                    }
                    segments.add(new Text("\n"));
                }
                if (results.isEmpty()) {
                    if (!keywords.isEmpty()) {
                        this.reasonTextFlow.getChildren().setAll((Object[])new Node[]{new Text(I18n.i18n("game.crash.reason.stacktrace", String.join((CharSequence)", ", keywords)))});
                    } else {
                        this.reasonTextFlow.getChildren().setAll((Object[])new Node[]{new Text(I18n.i18n("game.crash.reason.unknown"))});
                    }
                    this.feedbackLabel.setVisible(true);
                } else {
                    this.feedbackLabel.setVisible(false);
                    this.reasonTextFlow.getChildren().setAll(segments);
                }
            }
        }, Schedulers.javafx())).exceptionally(Lang::handleUncaughtException);
    }

    private String translateFabricModId(String modName) {
        switch (modName) {
            case "fabricloader": {
                return "Fabric";
            }
            case "fabric": {
                return "Fabric API";
            }
            case "minecraft": {
                return "Minecraft";
            }
        }
        return modName;
    }

    private String parseFabricModId(String modName) {
        Matcher matcher = FABRIC_MOD_ID.matcher(modName);
        if (matcher.find()) {
            String modid = matcher.group("modid");
            String version = matcher.group("version");
            if ("[*]".equals(version)) {
                return I18n.i18n("game.crash.reason.mod_resolution_mod_version.any", this.translateFabricModId(modid));
            }
            return I18n.i18n("game.crash.reason.mod_resolution_mod_version", this.translateFabricModId(modid), version);
        }
        return this.translateFabricModId(modName);
    }

    private void showLogWindow() {
        LogWindow logWindow = new LogWindow();
        logWindow.logLine("Command: " + new CommandBuilder().addAll(this.managedProcess.getCommands()).toString(), Log4jLevel.INFO);
        if (this.managedProcess.getClasspath() != null) {
            logWindow.logLine("ClassPath: " + this.managedProcess.getClasspath(), Log4jLevel.INFO);
        }
        for (Map.Entry entry : this.logs) {
            logWindow.logLine((String)entry.getKey(), (Log4jLevel)((Object)entry.getValue()));
        }
        logWindow.showNormal();
    }

    private void exportGameCrashInfo() {
        Path logFile = Paths.get("minecraft-exported-crash-info-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".zip", new String[0]).toAbsolutePath();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.logs.stream().map(Pair::getKey).collect(Collectors.joining(OperatingSystem.LINE_SEPARATOR))).thenComposeAsync(logs -> LogExporter.exportLogs(logFile, this.repository, this.launchOptions.getVersionName(), logs, new CommandBuilder().addAll(this.managedProcess.getCommands()).toString()))).thenRunAsync(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, I18n.i18n("settings.launcher.launcher_log.export.success", logFile), new ButtonType[0]);
            alert.setTitle(I18n.i18n("settings.launcher.launcher_log.export"));
            alert.showAndWait();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(logFile.toFile());
                }
                catch (IOException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }, Schedulers.javafx())).exceptionally(e -> {
            Logging.LOG.log(Level.WARNING, "Failed to export game crash info", (Throwable)e);
            return null;
        });
    }

    private final class View
    extends VBox {
        View() {
            this.setStyle("-fx-background-color: white");
            HBox titlePane = new HBox();
            Label title = new Label();
            HBox.setHgrow((Node)title, (Priority)Priority.ALWAYS);
            switch (GameCrashWindow.this.exitType) {
                case JVM_ERROR: {
                    title.setText(I18n.i18n("launch.failed.cannot_create_jvm"));
                    break;
                }
                case APPLICATION_ERROR: {
                    title.setText(I18n.i18n("launch.failed.exited_abnormally"));
                }
            }
            titlePane.setAlignment(Pos.CENTER);
            titlePane.getStyleClass().addAll((Object[])new String[]{"jfx-tool-bar-second", "depth-1", "padding-8"});
            titlePane.getChildren().setAll((Object[])new Node[]{title});
            HBox infoPane = new HBox(8.0);
            infoPane.setPadding(new Insets(8.0));
            infoPane.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem version = new TwoLineListItem();
            version.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            version.setTitle(I18n.i18n("archive.game_version"));
            version.setSubtitle(GameCrashWindow.this.version.getId());
            LibraryAnalyzer.LibraryType[] memory = new TwoLineListItem();
            memory.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            memory.setTitle(I18n.i18n("settings.memory"));
            memory.setSubtitle(GameCrashWindow.this.memory);
            TwoLineListItem java = new TwoLineListItem();
            java.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            java.setTitle("Java");
            java.setSubtitle(GameCrashWindow.this.java);
            TwoLineListItem os = new TwoLineListItem();
            os.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            os.setTitle(I18n.i18n("system.operating_system"));
            os.subtitleProperty().bind((ObservableValue)GameCrashWindow.this.os);
            TwoLineListItem arch = new TwoLineListItem();
            arch.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            arch.setTitle(I18n.i18n("system.architecture"));
            arch.subtitleProperty().bind((ObservableValue)GameCrashWindow.this.arch);
            infoPane.getChildren().setAll((Object[])new Node[]{version, memory, java, os, arch});
            HBox moddedPane = new HBox(8.0);
            moddedPane.setPadding(new Insets(8.0));
            moddedPane.setAlignment(Pos.CENTER_LEFT);
            for (LibraryAnalyzer.LibraryType type : LibraryAnalyzer.LibraryType.values()) {
                if (type.getPatchId().isEmpty()) continue;
                GameCrashWindow.this.analyzer.getVersion(type).ifPresent(ver -> {
                    TwoLineListItem item = new TwoLineListItem();
                    item.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
                    item.setTitle(I18n.i18n("install.installer." + type.getPatchId()));
                    item.setSubtitle((String)ver);
                    moddedPane.getChildren().add((Object)item);
                });
            }
            VBox gameDirPane = new VBox(8.0);
            TwoLineListItem gameDir = new TwoLineListItem();
            gameDir.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            gameDir.setTitle(I18n.i18n("game.directory"));
            gameDir.setSubtitle(GameCrashWindow.this.launchOptions.getGameDir().getAbsolutePath());
            TwoLineListItem javaDir = new TwoLineListItem();
            javaDir.getStyleClass().setAll((Object[])new String[]{"two-line-item-second-large"});
            javaDir.setTitle(I18n.i18n("settings.game.java_directory"));
            javaDir.setSubtitle(GameCrashWindow.this.launchOptions.getJava().getBinary().toAbsolutePath().toString());
            Label reasonTitle = new Label(I18n.i18n("game.crash.reason"));
            reasonTitle.getStyleClass().add((Object)"two-line-item-second-large-title");
            gameDirPane.setPadding(new Insets(8.0));
            VBox.setVgrow((Node)gameDirPane, (Priority)Priority.ALWAYS);
            gameDirPane.getChildren().setAll((Object[])new Node[]{gameDir, javaDir, new VBox(new Node[]{reasonTitle, GameCrashWindow.this.reasonTextFlow})});
            HBox toolBar = new HBox();
            JFXButton exportGameCrashInfoButton = new JFXButton(I18n.i18n("logwindow.export_game_crash_logs"));
            exportGameCrashInfoButton.setButtonType(JFXButton.ButtonType.RAISED);
            exportGameCrashInfoButton.getStyleClass().add((Object)"jfx-button-raised");
            exportGameCrashInfoButton.setOnMouseClicked(e -> GameCrashWindow.this.exportGameCrashInfo());
            JFXButton logButton = new JFXButton(I18n.i18n("logwindow.title"));
            logButton.setButtonType(JFXButton.ButtonType.RAISED);
            logButton.getStyleClass().add((Object)"jfx-button-raised");
            logButton.setOnMouseClicked(e -> GameCrashWindow.this.showLogWindow());
            toolBar.setPadding(new Insets(8.0));
            toolBar.setSpacing(8.0);
            toolBar.getStyleClass().add((Object)"jfx-tool-bar");
            toolBar.getChildren().setAll((Object[])new Node[]{exportGameCrashInfoButton, logButton, GameCrashWindow.this.feedbackLabel});
            this.getChildren().setAll((Object[])new Node[]{titlePane, infoPane, moddedPane, gameDirPane, toolBar});
        }
    }
}

