/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.TaskListPane;

public class TaskExecutorDialogPane
extends StackPane {
    private TaskExecutor executor;
    private Consumer<Region> onCancel;
    private final Consumer<FetchTask.SpeedEvent> speedEventHandler;
    @FXML
    private Label lblTitle;
    @FXML
    private Label lblProgress;
    @FXML
    private JFXButton btnCancel;
    @FXML
    private TaskListPane taskListPane;

    public TaskExecutorDialogPane(Consumer<Region> cancel) {
        FXUtils.loadFXML((Node)this, "/assets/fxml/task-dialog.fxml");
        this.setCancel(cancel);
        this.btnCancel.setOnAction(e -> {
            Optional.ofNullable(this.executor).ifPresent(TaskExecutor::cancel);
            this.onCancel.accept((Region)this);
        });
        this.speedEventHandler = speedEvent -> {
            String unit = "B/s";
            double speed = speedEvent.getSpeed();
            if (speed > 1024.0) {
                speed /= 1024.0;
                unit = "KB/s";
            }
            if (speed > 1024.0) {
                speed /= 1024.0;
                unit = "MB/s";
            }
            double finalSpeed = speed;
            String finalUnit = unit;
            Platform.runLater(() -> this.lblProgress.setText(String.format("%.1f %s", finalSpeed, finalUnit)));
        };
        FileDownloadTask.speedEvent.channel(FetchTask.SpeedEvent.class).registerWeak(this.speedEventHandler);
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)this.btnCancel).fire());
    }

    public void setExecutor(TaskExecutor executor) {
        this.setExecutor(executor, true);
    }

    public void setExecutor(TaskExecutor executor, boolean autoClose) {
        this.executor = executor;
        if (executor != null) {
            this.taskListPane.setExecutor(executor);
            if (autoClose) {
                executor.addTaskListener(new TaskListener(){

                    @Override
                    public void onStop(boolean success, TaskExecutor executor) {
                        Platform.runLater(() -> TaskExecutorDialogPane.this.fireEvent(new DialogCloseEvent()));
                    }
                });
            }
        }
    }

    public StringProperty titleProperty() {
        return this.lblTitle.textProperty();
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setTitle(String currentState) {
        this.lblTitle.setText(currentState);
    }

    public void setCancel(Consumer<Region> onCancel) {
        this.onCancel = onCancel;
        FXUtils.runInFX(() -> this.btnCancel.setDisable(onCancel == null));
    }
}

