/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.download.InstallersPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;

class AdditionalInstallersPage
extends InstallersPage {
    protected final BooleanProperty compatible = new SimpleBooleanProperty();
    protected final GameRepository repository;
    protected final String gameVersion;
    protected final Version version;

    public AdditionalInstallersPage(String gameVersion, Version version, WizardController controller, HMCLGameRepository repository, DownloadProvider downloadProvider) {
        super(controller, repository, gameVersion, downloadProvider);
        this.gameVersion = gameVersion;
        this.version = version;
        this.repository = repository;
        this.txtName.getValidators().clear();
        this.txtName.setText(version.getId());
        this.txtName.setEditable(false);
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.compatible.get() && this.txtName.validate(), (Observable[])new Observable[]{this.txtName.textProperty(), this.compatible}));
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals("game")) continue;
            library.removeAction.set(e -> {
                controller.getSettings().put(libraryId, new UpdateInstallerWizardProvider.RemoveVersionAction(libraryId));
                this.reload();
            });
        }
    }

    @Override
    protected void onInstall() {
        this.controller.onFinish();
    }

    @Override
    public String getTitle() {
        return I18n.i18n("settings.tabs.installers");
    }

    private String getVersion(String id) {
        return Optional.ofNullable(this.controller.getSettings().get(id)).flatMap(it -> Lang.tryCast(it, RemoteVersion.class)).map(RemoteVersion::getSelfVersion).orElse(null);
    }

    @Override
    protected void reload() {
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.version.resolvePreservingPatches(this.repository));
        String game = analyzer.getVersion(LibraryAnalyzer.LibraryType.MINECRAFT).orElse(null);
        String forge = analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).orElse(null);
        String liteLoader = analyzer.getVersion(LibraryAnalyzer.LibraryType.LITELOADER).orElse(null);
        String optiFine = analyzer.getVersion(LibraryAnalyzer.LibraryType.OPTIFINE).orElse(null);
        String fabric = analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).orElse(null);
        String fabricApi = analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC_API).orElse(null);
        InstallerItem[] libraries = this.group.getLibraries();
        String[] versions = new String[]{game, forge, liteLoader, optiFine, fabric, fabricApi};
        String currentGameVersion = Lang.nonNull(this.getVersion("game"), game);
        boolean compatible = true;
        for (int i = 0; i < libraries.length; ++i) {
            boolean alreadyInstalled;
            String libraryId = libraries[i].getLibraryId();
            String libraryVersion = Lang.nonNull(this.getVersion(libraryId), versions[i]);
            boolean bl = alreadyInstalled = versions[i] != null && !(this.controller.getSettings().get(libraryId) instanceof UpdateInstallerWizardProvider.RemoveVersionAction);
            if (!"game".equals(libraryId) && currentGameVersion != null && !currentGameVersion.equals(game) && this.getVersion(libraryId) == null && alreadyInstalled) {
                libraries[i].setState(libraryVersion, true, true);
                compatible = false;
                continue;
            }
            if (alreadyInstalled || this.getVersion(libraryId) != null) {
                libraries[i].setState(libraryVersion, false, true);
                continue;
            }
            libraries[i].setState(null, false, false);
        }
        this.compatible.set(compatible);
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }
}

