/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.profile;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.io.File;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.FileItem;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ProfilePage
extends StackPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final StringProperty location;
    private final Profile profile;
    @FXML
    private JFXTextField txtProfileName;
    @FXML
    private FileItem gameDir;
    @FXML
    private JFXButton btnSave;
    @FXML
    private JFXCheckBox toggleUseRelativePath;

    public ProfilePage(Profile profile) {
        this.profile = profile;
        String profileDisplayName = Optional.ofNullable(profile).map(Profiles::getProfileDisplayName).orElse("");
        this.state.set((Object)DecoratorPage.State.fromTitle(profile == null ? I18n.i18n("profile.new") : I18n.i18n("profile") + " - " + profileDisplayName));
        this.location = new SimpleStringProperty((Object)this, "location", Optional.ofNullable(profile).map(Profile::getGameDir).map(File::getAbsolutePath).orElse(".minecraft"));
        FXUtils.loadFXML((Node)this, "/assets/fxml/profile.fxml");
        this.txtProfileName.setText(profileDisplayName);
        this.txtProfileName.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage(I18n.i18n("profile.already_exists"));
            }

            @Override
            protected void eval() {
                JFXTextField control = (JFXTextField)this.getSrcControl();
                if (Profiles.getProfiles().stream().anyMatch(profile -> profile.getName().equals(control.getText()))) {
                    this.hasErrors.set(true);
                } else {
                    this.hasErrors.set(false);
                }
            }
        });
        FXUtils.onChangeAndOperate(this.txtProfileName.textProperty(), it -> this.btnSave.setDisable(!this.txtProfileName.validate() || StringUtils.isBlank(this.getLocation())));
        this.gameDir.pathProperty().bindBidirectional((Property)this.location);
        FXUtils.onChangeAndOperate(this.location, it -> this.btnSave.setDisable(!this.txtProfileName.validate() || StringUtils.isBlank(this.getLocation())));
        this.gameDir.convertToRelativePathProperty().bind((ObservableValue)this.toggleUseRelativePath.selectedProperty());
        if (profile != null) {
            this.toggleUseRelativePath.setSelected(profile.isUseRelativePath());
        }
    }

    @FXML
    private void onSave() {
        if (this.profile != null) {
            this.profile.setName(this.txtProfileName.getText());
            this.profile.setUseRelativePath(this.toggleUseRelativePath.isSelected());
            if (StringUtils.isNotBlank(this.getLocation())) {
                this.profile.setGameDir(new File(this.getLocation()));
            }
        } else {
            if (StringUtils.isBlank(this.getLocation())) {
                this.gameDir.onExplore();
            }
            Profile newProfile = new Profile(this.txtProfileName.getText(), new File(this.getLocation()));
            newProfile.setUseRelativePath(this.toggleUseRelativePath.isSelected());
            Profiles.getProfiles().add((Object)newProfile);
        }
        this.fireEvent(new PageCloseEvent());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public String getLocation() {
        return (String)this.location.get();
    }

    public StringProperty locationProperty() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location.set((Object)location);
    }
}

