/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXScrollPane;
import java.io.File;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.SimpleMultimap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public class DownloadPage
extends Control
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final BooleanProperty loaded = new SimpleBooleanProperty(false);
    private final BooleanProperty loading = new SimpleBooleanProperty(false);
    private final BooleanProperty failed = new SimpleBooleanProperty(false);
    private final RemoteMod addon;
    private final ModTranslations.Mod mod;
    private final Profile.ProfileVersion version;
    private final DownloadCallback callback;
    private final DownloadListPage page;
    private List<RemoteMod> dependencies;
    private SimpleMultimap<String, RemoteMod.Version> versions;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());

    public DownloadPage(DownloadListPage page, RemoteMod addon, Profile.ProfileVersion version, @Nullable DownloadCallback callback) {
        this.page = page;
        this.addon = addon;
        this.mod = ModTranslations.getModByCurseForgeId(addon.getSlug());
        this.version = version;
        this.callback = callback;
        this.loadModVersions();
        this.state.set((Object)DecoratorPage.State.fromTitle(addon.getTitle()));
    }

    private void loadModVersions() {
        File versionJar = StringUtils.isNotBlank(this.version.getVersion()) ? this.version.getProfile().getRepository().getVersionJar(this.version.getVersion()) : null;
        this.setLoading(true);
        this.setFailed(false);
        Task.allOf(Task.supplyAsync(() -> this.addon.getData().loadDependencies()), Task.supplyAsync(() -> {
            Stream<RemoteMod.Version> versions = this.addon.getData().loadVersions();
            return this.sortVersions(versions);
        })).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                List dependencies = (List)result.get(0);
                SimpleMultimap versions = (SimpleMultimap)result.get(1);
                this.dependencies = dependencies;
                this.versions = versions;
                this.loaded.set(true);
                this.setFailed(false);
            } else {
                this.setFailed(true);
            }
            this.setLoading(false);
        }).start();
    }

    private SimpleMultimap<String, RemoteMod.Version> sortVersions(Stream<RemoteMod.Version> versions) {
        SimpleMultimap<String, RemoteMod.Version> classifiedVersions = new SimpleMultimap<String, RemoteMod.Version>(HashMap::new, ArrayList::new);
        versions.forEach(version -> {
            for (String gameVersion : version.getGameVersions()) {
                classifiedVersions.put(gameVersion, (RemoteMod.Version)version);
            }
        });
        for (String gameVersion : classifiedVersions.keys()) {
            List versionList = (List)classifiedVersions.get(gameVersion);
            versionList.sort(Comparator.comparing(RemoteMod.Version::getDatePublished).reversed());
        }
        return classifiedVersions;
    }

    public RemoteMod getAddon() {
        return this.addon;
    }

    public Profile.ProfileVersion getVersion() {
        return this.version;
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public BooleanProperty failedProperty() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    public void download(RemoteMod.Version file) {
        if (this.callback == null) {
            this.saveAs(file);
        } else {
            this.callback.download(this.version.getProfile(), this.version.getVersion(), file);
        }
    }

    public void saveAs(RemoteMod.Version file) {
        String extension = StringUtils.substringAfterLast(file.getFile().getFilename(), '.');
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("button.save_as"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("file"), new String[]{"*." + extension}));
        fileChooser.setInitialFileName(file.getFile().getFilename());
        File dest = fileChooser.showSaveDialog((Window)Controllers.getStage());
        if (dest == null) {
            return;
        }
        Controllers.taskDialog(new FileDownloadTask(NetworkUtils.toURL(file.getFile().getUrl()), dest, file.getFile().getIntegrityCheck()).executor(true), I18n.i18n("message.downloading"));
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new ModDownloadPageSkin(this);
    }

    private static final class DependencyModItem
    extends StackPane {
        DependencyModItem(DownloadListPage page, RemoteMod addon, Profile.ProfileVersion version, DownloadCallback callback) {
            HBox pane = new HBox(8.0);
            pane.setPadding(new Insets(8.0));
            pane.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem content = new TwoLineListItem();
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            ImageView imageView = new ImageView();
            pane.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)imageView, 40.0, 40.0), content});
            RipplerContainer container = new RipplerContainer((Node)pane);
            container.setOnMouseClicked(e -> Controllers.navigate((Node)new DownloadPage(page, addon, version, callback)));
            this.getChildren().setAll((Object[])new Node[]{container});
            ModTranslations.Mod mod = ModTranslations.getModByCurseForgeId(addon.getSlug());
            content.setTitle(mod != null ? mod.getDisplayName() : addon.getTitle());
            content.setSubtitle(addon.getDescription());
            content.getTags().setAll((Collection)addon.getCategories().stream().map(page::getLocalizedCategory).collect(Collectors.toList()));
            if (StringUtils.isNotBlank(addon.getIconUrl())) {
                imageView.setImage(new Image(addon.getIconUrl(), 40.0, 40.0, true, true, true));
            }
        }
    }

    public static interface DownloadCallback {
        public void download(Profile var1, @Nullable String var2, RemoteMod.Version var3);
    }

    private static class ModDownloadPageSkin
    extends SkinBase<DownloadPage> {
        protected ModDownloadPageSkin(DownloadPage control) {
            super((Control)control);
            VBox pane = new VBox(8.0);
            pane.getStyleClass().add((Object)"gray-background");
            pane.setPadding(new Insets(10.0));
            ScrollPane scrollPane = new ScrollPane((Node)pane);
            JFXScrollPane.smoothScrolling(scrollPane);
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            HBox descriptionPane = new HBox(8.0);
            descriptionPane.setAlignment(Pos.CENTER);
            pane.getChildren().add((Object)descriptionPane);
            descriptionPane.getStyleClass().add((Object)"card-non-transparent");
            BorderPane.setMargin((Node)descriptionPane, (Insets)new Insets(11.0, 11.0, 0.0, 11.0));
            ImageView imageView = new ImageView();
            if (StringUtils.isNotBlank(((DownloadPage)this.getSkinnable()).addon.getIconUrl())) {
                imageView.setImage(new Image(((DownloadPage)this.getSkinnable()).addon.getIconUrl(), 40.0, 40.0, true, true, true));
            }
            descriptionPane.getChildren().add((Object)FXUtils.limitingSize((Node)imageView, 40.0, 40.0));
            TwoLineListItem content = new TwoLineListItem();
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            ModTranslations.Mod mod = ModTranslations.getModByCurseForgeId(((DownloadPage)this.getSkinnable()).addon.getSlug());
            content.setTitle(mod != null ? mod.getDisplayName() : ((DownloadPage)this.getSkinnable()).addon.getTitle());
            content.setSubtitle(((DownloadPage)this.getSkinnable()).addon.getDescription());
            content.getTags().setAll((Collection)((DownloadPage)this.getSkinnable()).addon.getCategories().stream().map(category -> ((DownloadPage)this.getSkinnable()).page.getLocalizedCategory((String)category)).collect(Collectors.toList()));
            descriptionPane.getChildren().add((Object)content);
            if (((DownloadPage)this.getSkinnable()).mod != null) {
                JFXHyperlink openMcmodButton = new JFXHyperlink(I18n.i18n("mods.mcmod"));
                openMcmodButton.setOnAction(e -> FXUtils.openLink(ModManager.getMcmodUrl(((DownloadPage)this.getSkinnable()).mod.getMcmod())));
                descriptionPane.getChildren().add((Object)openMcmodButton);
                if (StringUtils.isNotBlank(((DownloadPage)this.getSkinnable()).mod.getMcbbs())) {
                    JFXHyperlink openMcbbsButton = new JFXHyperlink(I18n.i18n("mods.mcbbs"));
                    openMcbbsButton.setOnAction(e -> FXUtils.openLink(ModManager.getMcbbsUrl(((DownloadPage)this.getSkinnable()).mod.getMcbbs())));
                    descriptionPane.getChildren().add((Object)openMcbbsButton);
                }
            }
            JFXHyperlink openUrlButton = new JFXHyperlink(control.page.getLocalizedOfficialPage());
            openUrlButton.setOnAction(e -> FXUtils.openLink(((DownloadPage)this.getSkinnable()).addon.getPageUrl()));
            descriptionPane.getChildren().add((Object)openUrlButton);
            ComponentList dependencyPane = new ComponentList();
            dependencyPane.getStyleClass().add((Object)"no-padding");
            FXUtils.onChangeAndOperate(control.loaded, loaded -> {
                if (loaded.booleanValue()) {
                    dependencyPane.getContent().setAll((Collection)control.dependencies.stream().map(dependency -> new DependencyModItem(((DownloadPage)this.getSkinnable()).page, (RemoteMod)dependency, control.version, control.callback)).collect(Collectors.toList()));
                }
            });
            Node title = ComponentList.createComponentListTitle(I18n.i18n("mods.dependencies"));
            BooleanBinding show = Bindings.createBooleanBinding(() -> !control.dependencies.isEmpty(), (Observable[])new Observable[]{control.loaded});
            title.managedProperty().bind((ObservableValue)show);
            title.visibleProperty().bind((ObservableValue)show);
            dependencyPane.managedProperty().bind((ObservableValue)show);
            dependencyPane.visibleProperty().bind((ObservableValue)show);
            pane.getChildren().addAll((Object[])new Node[]{title, dependencyPane});
            SpinnerPane spinnerPane = new SpinnerPane();
            VBox.setVgrow((Node)spinnerPane, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)spinnerPane);
            spinnerPane.loadingProperty().bind((ObservableValue)((DownloadPage)this.getSkinnable()).loadingProperty());
            spinnerPane.failedReasonProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((DownloadPage)this.getSkinnable()).isFailed()) {
                    return I18n.i18n("download.failed.refresh");
                }
                return null;
            }, (Observable[])new Observable[]{((DownloadPage)this.getSkinnable()).failedProperty()}));
            spinnerPane.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> ((DownloadPage)this.getSkinnable()).loadModVersions()));
            ComponentList list = new ComponentList();
            StackPane.setAlignment((Node)list, (Pos)Pos.TOP_CENTER);
            spinnerPane.setContent((Node)list);
            FXUtils.onChangeAndOperate(control.loaded, loaded -> {
                if (control.versions == null) {
                    return;
                }
                for (String gameVersion : control.versions.keys().stream().sorted(VersionNumber.VERSION_COMPARATOR.reversed()).collect(Collectors.toList())) {
                    ComponentList sublist = new ComponentList();
                    sublist.setLazyInitializer(self -> self.getContent().setAll((Collection)control.versions.get(gameVersion).stream().map(version -> new ModItem((RemoteMod.Version)version, control)).collect(Collectors.toList())));
                    sublist.getStyleClass().add((Object)"no-padding");
                    sublist.setTitle(gameVersion);
                    list.getContent().add((Object)sublist);
                }
            });
            this.getChildren().setAll((Object[])new Node[]{scrollPane});
        }
    }

    private static final class ModItem
    extends StackPane {
        ModItem(RemoteMod.Version dataItem, DownloadPage selfPage) {
            HBox pane = new HBox(8.0);
            pane.setPadding(new Insets(8.0));
            pane.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem content = new TwoLineListItem();
            StackPane graphicPane = new StackPane();
            JFXButton saveAsButton = new JFXButton();
            RipplerContainer container = new RipplerContainer((Node)pane);
            container.setOnMouseClicked(e -> selfPage.download(dataItem));
            this.getChildren().setAll((Object[])new Node[]{container});
            saveAsButton.getStyleClass().add((Object)"toggle-icon4");
            saveAsButton.setGraphic(SVG.contentSaveMoveOutline(Theme.blackFillBinding(), -1.0, -1.0));
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            pane.getChildren().setAll((Object[])new Node[]{graphicPane, content, saveAsButton});
            content.setTitle(dataItem.getName());
            content.setSubtitle(FORMATTER.format(dataItem.getDatePublished()));
            saveAsButton.setOnMouseClicked(e -> selfPage.saveAs(dataItem));
            switch (dataItem.getVersionType()) {
                case Release: {
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.releaseCircleOutline(Theme.blackFillBinding(), 24.0, 24.0)});
                    content.getTags().add((Object)I18n.i18n("version.game.release"));
                    break;
                }
                case Beta: {
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.betaCircleOutline(Theme.blackFillBinding(), 24.0, 24.0)});
                    content.getTags().add((Object)I18n.i18n("version.game.snapshot"));
                    break;
                }
                case Alpha: {
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.alphaCircleOutline(Theme.blackFillBinding(), 24.0, 24.0)});
                    content.getTags().add((Object)I18n.i18n("version.game.snapshot"));
                }
            }
        }
    }
}

