/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public class ModDownloadListPage
extends DownloadListPage {
    public ModDownloadListPage(DownloadPage.DownloadCallback callback, boolean versionSelection) {
        super(null, callback, versionSelection);
        this.repository = new Repository();
        this.supportChinese.set(true);
        ((ObservableList)this.downloadSources.get()).setAll((Object[])new String[]{"mods.curseforge", "mods.modrinth"});
        this.downloadSource.set((Object)"mods.curseforge");
    }

    @Override
    protected String getLocalizedCategory(String category) {
        if ("mods.modrinth".equals(this.downloadSource.get())) {
            return I18n.i18n("modrinth.category." + category);
        }
        return I18n.i18n("curse.category." + category);
    }

    @Override
    protected String getLocalizedOfficialPage() {
        if ("mods.modrinth".equals(this.downloadSource.get())) {
            return I18n.i18n("mods.modrinth");
        }
        return I18n.i18n("mods.curseforge");
    }

    private class Repository
    implements RemoteModRepository {
        private Repository() {
        }

        @Override
        public Stream<RemoteMod> search(String gameVersion, RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort) throws IOException {
            String newSearchFilter;
            if (StringUtils.CHINESE_PATTERN.matcher(searchFilter).find()) {
                List<ModTranslations.Mod> mods = ModTranslations.searchMod(searchFilter);
                ArrayList<String> searchFilters = new ArrayList<String>();
                int count = 0;
                for (ModTranslations.Mod mod : mods) {
                    String englishName = mod.getName();
                    if (StringUtils.isNotBlank(mod.getSubname())) {
                        englishName = mod.getSubname();
                    }
                    searchFilters.add(englishName);
                    if (++count < 3) continue;
                    break;
                }
                newSearchFilter = String.join((CharSequence)" ", searchFilters);
            } else {
                newSearchFilter = searchFilter;
            }
            if ("mods.modrinth".equals(ModDownloadListPage.this.downloadSource.get())) {
                return ModrinthRemoteModRepository.INSTANCE.search(gameVersion, category, pageOffset, pageSize, newSearchFilter, sort);
            }
            return CurseForgeRemoteModRepository.MODS.search(gameVersion, category, pageOffset, pageSize, newSearchFilter, sort);
        }

        @Override
        public Stream<RemoteModRepository.Category> getCategories() throws IOException {
            if ("mods.modrinth".equals(ModDownloadListPage.this.downloadSource.get())) {
                return ModrinthRemoteModRepository.INSTANCE.getCategories();
            }
            return CurseForgeRemoteModRepository.MODS.getCategories();
        }

        @Override
        public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RemoteMod getModById(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

