/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.wizard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javafx.scene.Node;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Summary;
import org.jackhuang.hmcl.ui.wizard.WizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Logging;

public class WizardController
implements Navigation {
    private final WizardDisplayer displayer;
    private WizardProvider provider = null;
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private final Stack<Node> pages = new Stack();
    private boolean stopped = false;

    public WizardController(WizardDisplayer displayer) {
        this.displayer = displayer;
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public WizardDisplayer getDisplayer() {
        return this.displayer;
    }

    public void setProvider(WizardProvider provider) {
        this.provider = provider;
    }

    public List<Node> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    @Override
    public void onStart() {
        Objects.requireNonNull(this.provider);
        this.settings.clear();
        this.provider.start(this.settings);
        this.pages.clear();
        Node page = this.navigatingTo(0);
        this.pages.push(page);
        if (this.stopped) {
            return;
        }
        if (page instanceof WizardPage) {
            ((WizardPage)page).onNavigate(this.settings);
        }
        this.displayer.onStart();
        Logging.LOG.info("Navigating to " + page + ", pages: " + this.pages);
        this.displayer.navigateTo(page, Navigation.NavigationDirection.START);
    }

    @Override
    public void onNext() {
        this.onNext(this.navigatingTo(this.pages.size()));
    }

    public void onNext(Node page) {
        this.pages.push(page);
        if (this.stopped) {
            return;
        }
        if (page instanceof WizardPage) {
            ((WizardPage)page).onNavigate(this.settings);
        }
        Logging.LOG.info("Navigating to " + page + ", pages: " + this.pages);
        this.displayer.navigateTo(page, Navigation.NavigationDirection.NEXT);
    }

    @Override
    public void onPrev(boolean cleanUp) {
        Node prevPage;
        if (!this.canPrev()) {
            if (this.provider.cancelIfCannotGoBack()) {
                this.onCancel();
                return;
            }
            throw new IllegalStateException("Cannot go backward since this is the back page. Pages: " + this.pages);
        }
        Node page = this.pages.pop();
        if (cleanUp && page instanceof WizardPage) {
            ((WizardPage)page).cleanup(this.settings);
        }
        if ((prevPage = this.pages.peek()) instanceof WizardPage) {
            ((WizardPage)prevPage).onNavigate(this.settings);
        }
        Logging.LOG.info("Navigating to " + prevPage + ", pages: " + this.pages);
        this.displayer.navigateTo(prevPage, Navigation.NavigationDirection.PREVIOUS);
    }

    @Override
    public boolean canPrev() {
        return this.pages.size() > 1;
    }

    @Override
    public void onFinish() {
        Object result = this.provider.finish(this.settings);
        if (result instanceof Summary) {
            this.displayer.navigateTo(((Summary)result).getComponent(), Navigation.NavigationDirection.NEXT);
        } else if (result instanceof Task) {
            this.displayer.handleTask(this.settings, (Task)result);
        } else if (result != null) {
            throw new IllegalStateException("Unrecognized wizard result: " + result);
        }
    }

    @Override
    public void onEnd() {
        this.stopped = true;
        this.settings.clear();
        this.pages.clear();
        this.displayer.onEnd();
    }

    @Override
    public void onCancel() {
        this.displayer.onCancel();
        this.onEnd();
    }

    protected Node navigatingTo(int step) {
        return this.provider.createPage(this, step, this.settings);
    }
}

