/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.layout.Region;
import javax.swing.JOptionPane;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.UpgradeDialog;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.upgrade.ExecutableHeaderHelper;
import org.jackhuang.hmcl.upgrade.HMCLDownloadTask;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;

public final class UpdateHandler {
    private UpdateHandler() {
    }

    public static boolean processArguments(String[] args) {
        UpdateHandler.breakForceUpdateFeature();
        if (UpdateHandler.isNestedApplication()) {
            try {
                UpdateHandler.performMigration();
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to perform migration", e);
                JOptionPane.showMessageDialog(null, I18n.i18n("fatal.apply_update_failure", "http://www.mcbbs.net/thread-142335-1-1.html") + "\n" + StringUtils.getStackTrace(e), "Error", 0);
            }
            return true;
        }
        if (args.length == 2 && args[0].equals("--apply-to")) {
            try {
                UpdateHandler.applyUpdate(Paths.get(args[1], new String[0]));
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to apply update", e);
                JOptionPane.showMessageDialog(null, I18n.i18n("fatal.apply_update_failure", "http://www.mcbbs.net/thread-142335-1-1.html") + "\n" + StringUtils.getStackTrace(e), "Error", 0);
            }
            return true;
        }
        if (UpdateHandler.isFirstLaunchAfterUpgrade()) {
            JOptionPane.showMessageDialog(null, I18n.i18n("fatal.migration_requires_manual_reboot"), "Info", 1);
            return true;
        }
        return false;
    }

    public static void updateFrom(RemoteVersion version) {
        FXUtils.checkFxUserThread();
        Controllers.dialog((Region)new UpgradeDialog(version, () -> {
            Path downloaded;
            try {
                downloaded = Files.createTempFile("hmcl-update-", ".jar", new FileAttribute[0]);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to create temp file", e);
                return;
            }
            HMCLDownloadTask task = new HMCLDownloadTask(version, downloaded);
            TaskExecutor executor = task.executor();
            Controllers.taskDialog(executor, I18n.i18n("message.downloading"));
            Lang.thread(() -> {
                boolean success = executor.test();
                if (success) {
                    try {
                        if (!IntegrityChecker.isSelfVerified()) {
                            throw new IOException("Current JAR is not verified");
                        }
                        UpdateHandler.requestUpdate(downloaded, UpdateHandler.getCurrentLocation());
                        System.exit(0);
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to update to " + version, e);
                        Platform.runLater(() -> Controllers.dialog(StringUtils.getStackTrace(e), I18n.i18n("update.failed"), MessageDialogPane.MessageType.ERROR));
                    }
                } else {
                    Exception e = executor.getException();
                    Logging.LOG.log(Level.WARNING, "Failed to update to " + version, e);
                    Platform.runLater(() -> Controllers.dialog(e.toString(), I18n.i18n("update.failed"), MessageDialogPane.MessageType.ERROR));
                }
            });
        }));
    }

    private static void applyUpdate(Path target) throws IOException {
        Logging.LOG.info("Applying update to " + target);
        Path self = UpdateHandler.getCurrentLocation();
        IntegrityChecker.requireVerifiedJar(self);
        ExecutableHeaderHelper.copyWithHeader(self, target);
        Optional<Path> newFilename = UpdateHandler.tryRename(target, Metadata.VERSION);
        if (newFilename.isPresent()) {
            Logging.LOG.info("Move " + target + " to " + newFilename.get());
            try {
                Files.move(target, newFilename.get(), new CopyOption[0]);
                target = newFilename.get();
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to move target", e);
            }
        }
        UpdateHandler.startJava(target, new String[0]);
    }

    private static void requestUpdate(Path updateTo, Path self) throws IOException {
        IntegrityChecker.requireVerifiedJar(updateTo);
        UpdateHandler.startJava(updateTo, "--apply-to", self.toString());
    }

    private static void startJava(Path jar, String ... appArgs) throws IOException {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(JavaVersion.fromCurrentEnvironment().getBinary().toString());
        commandline.add("-jar");
        commandline.add(jar.toAbsolutePath().toString());
        commandline.addAll(Arrays.asList(appArgs));
        Logging.LOG.info("Starting process: " + commandline);
        new ProcessBuilder(commandline).directory(Paths.get("", new String[0]).toAbsolutePath().toFile()).inheritIO().start();
    }

    private static Optional<Path> tryRename(Path path, String newVersion) {
        String newFilename;
        String filename = path.getFileName().toString();
        Matcher matcher = Pattern.compile("^(?<prefix>[hH][mM][cC][lL][.-])(?<version>\\d+(?:\\.\\d+)*)(?<suffix>\\.[^.]+)$").matcher(filename);
        if (matcher.find() && !(newFilename = matcher.group("prefix") + newVersion + matcher.group("suffix")).equals(filename)) {
            return Optional.of(path.resolveSibling(newFilename));
        }
        return Optional.empty();
    }

    private static Path getCurrentLocation() throws IOException {
        return JarUtils.thisJar().orElseThrow(() -> new IOException("Failed to find current HMCL location"));
    }

    private static void performMigration() throws IOException {
        Logging.LOG.info("Migrating from old versions");
        Path location = UpdateHandler.getParentApplicationLocation().orElseThrow(() -> new IOException("Failed to get parent application location"));
        UpdateHandler.requestUpdate(UpdateHandler.getCurrentLocation(), location);
    }

    private static boolean isNestedApplication() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement element = stacktrace[i];
            if (!Main.class.getName().equals(element.getClassName()) || !"main".equals(element.getMethodName())) continue;
            return i + 1 != stacktrace.length;
        }
        return false;
    }

    private static Optional<Path> getParentApplicationLocation() {
        Path path;
        String command = System.getProperty("sun.java.command");
        if (command != null && Files.isRegularFile(path = Paths.get(command, new String[0]), new LinkOption[0])) {
            return Optional.of(path.toAbsolutePath());
        }
        return Optional.empty();
    }

    private static boolean isFirstLaunchAfterUpgrade() {
        Optional<Path> currentPath = JarUtils.thisJar();
        if (currentPath.isPresent()) {
            Path updated = Metadata.HMCL_DIRECTORY.resolve("HMCL-" + Metadata.VERSION + ".jar");
            if (currentPath.get().toAbsolutePath().equals(updated.toAbsolutePath())) {
                return true;
            }
        }
        return false;
    }

    private static void breakForceUpdateFeature() {
        Path hmclVersionJson = Metadata.HMCL_DIRECTORY.resolve("hmclver.json");
        if (Files.isRegularFile(hmclVersionJson, new LinkOption[0])) {
            try {
                Map content = new Gson().fromJson(FileUtils.readText(hmclVersionJson), Map.class);
                Object ver = content.get("ver");
                if (ver instanceof String && ((String)ver).startsWith("3.")) {
                    Files.delete(hmclVersionJson);
                    Logging.LOG.info("Successfully broke the force update feature");
                }
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to break the force update feature", e);
            }
            catch (JsonParseException e) {
                hmclVersionJson.toFile().delete();
            }
        }
    }
}

