/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import org.jackhuang.hmcl.util.Logging;

public final class Pack200Utils {
    private static final String[] IMPL_NAMES = new String[]{"java.util.jar.Pack200", "org.glavo.pack200.Pack200", "io.pack200.Pack200"};
    private static final MethodHandle newUnpackerHandle;
    private static final MethodHandle unpackHandle;
    private static final MethodHandle unpackFileHandle;

    private Pack200Utils() {
    }

    public static boolean isSupported() {
        return newUnpackerHandle != null;
    }

    public static void unpack(InputStream in, JarOutputStream out) throws IOException {
        if (newUnpackerHandle == null) {
            throw new UnsupportedOperationException("Pack200");
        }
        try {
            unpackHandle.invoke(newUnpackerHandle.invoke(), in, out);
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void unpack(File in, JarOutputStream out) throws IOException {
        if (newUnpackerHandle == null) {
            throw new UnsupportedOperationException("Pack200");
        }
        try {
            unpackFileHandle.invoke(newUnpackerHandle.invoke(), in, out);
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class<?> pack200Class = null;
        Class<?> unpackerClass = null;
        for (String implName : IMPL_NAMES) {
            try {
                pack200Class = Class.forName(implName);
                unpackerClass = Class.forName(implName + "$Unpacker");
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (pack200Class == null) {
            Logging.LOG.warning("Pack200 not found");
            newUnpackerHandle = null;
            unpackHandle = null;
            unpackFileHandle = null;
        } else {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle newUnpacker = null;
            MethodHandle unpack = null;
            MethodHandle unpackFile = null;
            try {
                newUnpacker = lookup.findStatic(pack200Class, "newUnpacker", MethodType.methodType(unpackerClass));
                unpack = lookup.findVirtual(unpackerClass, "unpack", MethodType.methodType(Void.TYPE, InputStream.class, JarOutputStream.class));
                unpackFile = lookup.findVirtual(unpackerClass, "unpack", MethodType.methodType(Void.TYPE, File.class, JarOutputStream.class));
            }
            catch (Throwable e) {
                Logging.LOG.log(Level.WARNING, "Failed to find pack200 methods", e);
            }
            if (newUnpacker != null) {
                newUnpackerHandle = newUnpacker;
                unpackHandle = unpack;
                unpackFileHandle = unpackFile;
            } else {
                newUnpackerHandle = null;
                unpackHandle = null;
                unpackFileHandle = null;
            }
        }
    }
}

