/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EnumOrdinalDeserializer<T extends Enum<T>>
implements JsonDeserializer<T> {
    private Map<String, T> mapping = new HashMap<String, T>();

    public EnumOrdinalDeserializer(Class<T> enumClass) {
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            this.mapping.put(String.valueOf(constant.ordinal()), constant);
            String name = constant.name();
            try {
                SerializedName annotation = enumClass.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name = annotation.value();
                    for (String alternate : annotation.alternate()) {
                        this.mapping.put(alternate, constant);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
            this.mapping.put(name, constant);
        }
    }

    @Override
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return (T)((Enum)this.mapping.get(json.getAsString()));
    }
}

